/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet.generators;

import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.emmet.ZenCodingTemplate;
import com.intellij.codeInsight.template.emmet.generators.ZenCodingGenerator;
import com.intellij.codeInsight.template.emmet.tokens.TemplateToken;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.diagnostic.AttachmentFactory;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.xml.util.HtmlUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XmlZenCodingGenerator
extends ZenCodingGenerator {
    @Override
    public TemplateImpl generateTemplate(@NotNull TemplateToken token, boolean hasChildren, @NotNull PsiElement context) {
        if (token == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "token", "com/intellij/codeInsight/template/emmet/generators/XmlZenCodingGenerator", "generateTemplate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/template/emmet/generators/XmlZenCodingGenerator", "generateTemplate"));
        }
        String s = this.toString(token, hasChildren, context);
        TemplateImpl tokenTemplate = token.getTemplate();
        assert (tokenTemplate != null);
        TemplateImpl template = tokenTemplate.copy();
        template.setString(s);
        return template;
    }

    @Override
    public TemplateImpl createTemplateByKey(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInsight/template/emmet/generators/XmlZenCodingGenerator", "createTemplateByKey"));
        }
        StringBuilder builder = new StringBuilder("<");
        builder.append(key).append('>');
        if (!HtmlUtil.isSingleHtmlTag(key)) {
            builder.append("$END$</").append(key).append('>');
        }
        return new TemplateImpl("", builder.toString(), "");
    }

    @NotNull
    private String toString(@NotNull TemplateToken token, boolean hasChildren, @NotNull PsiElement context) {
        XmlTag tag;
        if (token == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "token", "com/intellij/codeInsight/template/emmet/generators/XmlZenCodingGenerator", "toString"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/template/emmet/generators/XmlZenCodingGenerator", "toString"));
        }
        XmlFile file = token.getFile();
        XmlDocument document = file.getDocument();
        if (document != null && (tag = document.getRootTag()) != null) {
            String string = this.toString(tag, token.getAttribute2Value(), hasChildren, context);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/generators/XmlZenCodingGenerator", "toString"));
            }
            return string;
        }
        String string = file.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/generators/XmlZenCodingGenerator", "toString"));
        }
        return string;
    }

    public abstract String toString(@NotNull XmlTag var1, @NotNull List<Couple<String>> var2, boolean var3, @NotNull PsiElement var4);

    @NotNull
    public abstract String buildAttributesString(@NotNull List<Couple<String>> var1, boolean var2, int var3, int var4, @Nullable String var5);

    @Override
    public abstract boolean isMyContext(@NotNull PsiElement var1, boolean var2);

    @Override
    @Nullable
    public String computeTemplateKey(@NotNull CustomTemplateCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/codeInsight/template/emmet/generators/XmlZenCodingGenerator", "computeTemplateKey"));
        }
        Editor editor = callback.getEditor();
        int currentOffset = editor.getCaretModel().getOffset();
        int startOffset = Math.min(editor.getDocument().getLineStartOffset(editor.getDocument().getLineNumber(currentOffset)), currentOffset);
        CharSequence documentText = editor.getDocument().getCharsSequence();
        PsiElement prevVisibleLeaf = callback.getContext();
        while (prevVisibleLeaf != null) {
            TextRange textRange = prevVisibleLeaf.getTextRange();
            int endOffset = textRange.getEndOffset();
            if (endOffset <= currentOffset) {
                if (endOffset <= startOffset) break;
                IElementType prevType = prevVisibleLeaf.getNode().getElementType();
                if (prevType == XmlTokenType.XML_TAG_END || prevType == XmlTokenType.XML_EMPTY_ELEMENT_END) {
                    startOffset = endOffset;
                    break;
                }
            }
            prevVisibleLeaf = PsiTreeUtil.prevVisibleLeaf((PsiElement)prevVisibleLeaf);
        }
        if (startOffset < 0 || currentOffset > documentText.length() || currentOffset < startOffset) {
            Logger.getInstance(this.getClass()).error("Error while calculating emmet abbreviation. Offset: " + currentOffset + "; Start: " + startOffset, new Attachment[]{AttachmentFactory.createAttachment(editor.getDocument())});
            return null;
        }
        String key = this.computeKey(documentText.subSequence(startOffset, currentOffset));
        return !StringUtil.isEmpty((String)key) && ZenCodingTemplate.checkTemplateKey(key, callback, this) ? key : null;
    }
}

