/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.actions;

import com.intellij.compiler.ModuleCompilerUtil;
import com.intellij.compiler.ant.BuildProperties;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Chunk;
import com.intellij.util.ListWithSelection;
import com.intellij.util.ui.Table;
import com.intellij.util.ui.table.ComboBoxTableCellEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.plaf.LabelUI;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class GenerateAntBuildDialog
extends DialogWrapper {
    private JPanel myPanel;
    private JRadioButton myRbGenerateSingleFileBuild;
    private JRadioButton myRbGenerateMultipleFilesBuild;
    private JCheckBox myCbEnableUIFormsCompilation;
    private JRadioButton myRbBackupFiles;
    private JRadioButton myRbOverwriteFiles;
    private JCheckBox myCbForceTargetJdk;
    private JCheckBox myCbInlineRuntimeClasspath;
    private JPanel myChunksPanel;
    private JCheckBox myGenerateIdeaHomeProperty;
    private JTextField myOutputFileNameField;
    private final Project myProject;
    @NonNls
    private static final String SINGLE_FILE_PROPERTY = "GenerateAntBuildDialog.generateSingleFile";
    @NonNls
    private static final String UI_FORM_PROPERTY = "GenerateAntBuildDialog.enableUiFormCompile";
    @NonNls
    private static final String FORCE_TARGET_JDK_PROPERTY = "GenerateAntBuildDialog.forceTargetJdk";
    @NonNls
    private static final String BACKUP_FILES_PROPERTY = "GenerateAntBuildDialog.backupFiles";
    @NonNls
    private static final String INLINE_RUNTIME_CLASSPATH_PROPERTY = "GenerateAntBuildDialog.inclineRuntiemClasspath";
    @NonNls
    private static final String GENERATE_IDEA_HOME_PROPERTY = "GenerateAntBuildDialog.generateIdeaHomeProperty";
    @NonNls
    private static final String OUTPUT_FILE_NAME_PROPERTY = "GenerateAntBuildDialog.outputFileNameProperty";
    private MyTableModel myTableModel;
    private Table myTable;

    public GenerateAntBuildDialog(Project project) {
        super(project, false);
        this.myProject = project;
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(CompilerBundle.message((String)"generate.ant.build.title", (Object[])objectArray));
        this.init();
        this.loadSettings();
    }

    private List<Chunk<Module>> getCycleChunks() {
        List chunks = ModuleCompilerUtil.getSortedModuleChunks((Project)this.myProject, Arrays.asList(ModuleManager.getInstance((Project)this.myProject).getModules()));
        Iterator it = chunks.iterator();
        while (it.hasNext()) {
            Chunk chunk = (Chunk)it.next();
            if (chunk.getNodes().size() != 1) continue;
            it.remove();
        }
        return chunks;
    }

    private void loadSettings() {
        PropertiesComponent properties = PropertiesComponent.getInstance((Project)this.myProject);
        if (properties.isValueSet(SINGLE_FILE_PROPERTY)) {
            boolean singleFile = properties.isTrueValue(SINGLE_FILE_PROPERTY);
            this.myRbGenerateSingleFileBuild.setSelected(singleFile);
            this.myRbGenerateMultipleFilesBuild.setSelected(!singleFile);
        }
        if (properties.isValueSet(UI_FORM_PROPERTY)) {
            this.myCbEnableUIFormsCompilation.setSelected(properties.isTrueValue(UI_FORM_PROPERTY));
        }
        if (properties.isValueSet(FORCE_TARGET_JDK_PROPERTY)) {
            this.myCbForceTargetJdk.setSelected(properties.isTrueValue(FORCE_TARGET_JDK_PROPERTY));
        }
        if (properties.isValueSet(BACKUP_FILES_PROPERTY)) {
            boolean backup = properties.isTrueValue(BACKUP_FILES_PROPERTY);
            this.myRbBackupFiles.setSelected(backup);
            this.myRbOverwriteFiles.setSelected(!backup);
        }
        if (properties.isValueSet(INLINE_RUNTIME_CLASSPATH_PROPERTY)) {
            this.myCbInlineRuntimeClasspath.setSelected(properties.isTrueValue(INLINE_RUNTIME_CLASSPATH_PROPERTY));
        }
        if (properties.isValueSet(GENERATE_IDEA_HOME_PROPERTY)) {
            this.myGenerateIdeaHomeProperty.setSelected(properties.isTrueValue(GENERATE_IDEA_HOME_PROPERTY));
        }
        if (properties.isValueSet(OUTPUT_FILE_NAME_PROPERTY)) {
            this.myOutputFileNameField.setText(properties.getValue(OUTPUT_FILE_NAME_PROPERTY));
        } else {
            this.myOutputFileNameField.setText(BuildProperties.getProjectBuildFileName((Project)this.myProject));
        }
    }

    private void saveSettings() {
        PropertiesComponent properties = PropertiesComponent.getInstance((Project)this.myProject);
        properties.setValue(SINGLE_FILE_PROPERTY, Boolean.toString(this.myRbGenerateSingleFileBuild.isSelected()));
        properties.setValue(UI_FORM_PROPERTY, Boolean.toString(this.myCbEnableUIFormsCompilation.isSelected()));
        properties.setValue(FORCE_TARGET_JDK_PROPERTY, Boolean.toString(this.myCbForceTargetJdk.isSelected()));
        properties.setValue(BACKUP_FILES_PROPERTY, Boolean.toString(this.myRbBackupFiles.isSelected()));
        properties.setValue(INLINE_RUNTIME_CLASSPATH_PROPERTY, Boolean.toString(this.myCbInlineRuntimeClasspath.isSelected()));
        properties.setValue(GENERATE_IDEA_HOME_PROPERTY, Boolean.toString(this.myGenerateIdeaHomeProperty.isSelected()));
        String outputFileName = this.getOutputFileName();
        if (outputFileName.length() > 0) {
            properties.setValue(OUTPUT_FILE_NAME_PROPERTY, outputFileName);
        } else {
            properties.unsetValue(OUTPUT_FILE_NAME_PROPERTY);
        }
    }

    public void dispose() {
        this.saveSettings();
        super.dispose();
    }

    protected JComponent createCenterPanel() {
        ButtonGroup group = new ButtonGroup();
        group.add(this.myRbGenerateMultipleFilesBuild);
        group.add(this.myRbGenerateSingleFileBuild);
        ButtonGroup group1 = new ButtonGroup();
        group1.add(this.myRbBackupFiles);
        group1.add(this.myRbOverwriteFiles);
        this.myRbGenerateMultipleFilesBuild.setSelected(true);
        this.myRbBackupFiles.setSelected(true);
        this.myCbEnableUIFormsCompilation.setSelected(true);
        this.myCbForceTargetJdk.setSelected(true);
        this.myCbInlineRuntimeClasspath.setSelected(false);
        this.initChunksPanel();
        return this.myPanel;
    }

    private void initChunksPanel() {
        List<Chunk<Module>> chunks = this.getCycleChunks();
        if (chunks.isEmpty()) {
            return;
        }
        this.myChunksPanel.setLayout(new BorderLayout());
        this.myChunksPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)CompilerBundle.message((String)"generate.ant.build.dialog.cyclic.modules.table.title", (Object[])new Object[0]), (boolean)true));
        JLabel textLabel = new JLabel(CompilerBundle.message((String)"generate.ant.build.dialog.cyclic.modules.table.description", (Object[])new Object[0]));
        textLabel.setUI((LabelUI)new MultiLineLabelUI());
        textLabel.setBorder(IdeBorderFactory.createEmptyBorder((int)4, (int)4, (int)6, (int)4));
        this.myChunksPanel.add((Component)textLabel, "North");
        this.myTableModel = new MyTableModel(chunks);
        this.myTable = new Table((TableModel)this.myTableModel);
        MyTableCellRenderer cellRenderer = new MyTableCellRenderer();
        TableColumn nameColumn = this.myTable.getColumnModel().getColumn(1);
        nameColumn.setCellEditor(ComboBoxTableCellEditor.INSTANCE);
        nameColumn.setCellRenderer(cellRenderer);
        TableColumn labelColumn = this.myTable.getColumnModel().getColumn(0);
        labelColumn.setCellRenderer(cellRenderer);
        Dimension preferredSize = new Dimension(this.myTable.getPreferredSize());
        preferredSize.height = (this.myTableModel.getRowCount() + 2) * this.myTable.getRowHeight() + this.myTable.getTableHeader().getHeight();
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myTable);
        scrollPane.setPreferredSize(preferredSize);
        this.myChunksPanel.add((Component)scrollPane, "Center");
    }

    protected void doOKAction() {
        TableCellEditor cellEditor;
        if (this.myTable != null && (cellEditor = this.myTable.getCellEditor()) != null) {
            cellEditor.stopCellEditing();
        }
        super.doOKAction();
    }

    public boolean isGenerateSingleFileBuild() {
        return this.myRbGenerateSingleFileBuild.isSelected();
    }

    public boolean isFormsCompilationEnabled() {
        return this.myCbEnableUIFormsCompilation.isSelected();
    }

    public boolean isForceTargetJdk() {
        return this.myCbForceTargetJdk.isSelected();
    }

    public boolean isBackupFiles() {
        return this.myRbBackupFiles.isSelected();
    }

    public boolean isRuntimeClasspathInlined() {
        return this.myCbInlineRuntimeClasspath.isSelected();
    }

    public String[] getRepresentativeModuleNames() {
        return this.myTableModel != null ? this.myTableModel.getModuleRepresentatives() : ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public boolean isIdeaHomeGenerated() {
        return this.myGenerateIdeaHomeProperty.isSelected();
    }

    public String getOutputFileName() {
        return this.myOutputFileNameField.getText().trim();
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/actions/GenerateAntBuildDialog", "createActions"));
        }
        return actionArray;
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("editing.generateAntBuild");
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JPanel jPanel;
        JCheckBox jCheckBox4;
        JTextField jTextField;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JRadioButton jRadioButton4;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myRbGenerateMultipleFilesBuild = jRadioButton4 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton4, ResourceBundle.getBundle("messages/CompilerBundle").getString("label.generate.ant.script.generate.multiple.files"));
        jPanel3.add((Component)jRadioButton4, new GridConstraints(0, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.myRbGenerateSingleFileBuild = jRadioButton3 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton3, ResourceBundle.getBundle("messages/CompilerBundle").getString("label.generate.ant.script.single.file"));
        jPanel3.add((Component)jRadioButton3, new GridConstraints(1, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.myRbBackupFiles = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("messages/CompilerBundle").getString("label.generate.ant.script.backup.files"));
        jPanel3.add((Component)jRadioButton2, new GridConstraints(0, 3, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myRbOverwriteFiles = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("messages/CompilerBundle").getString("label.generate.ant.script.overwrite.files"));
        jPanel3.add((Component)jRadioButton, new GridConstraints(1, 3, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myOutputFileNameField = jTextField = new JTextField();
        jPanel3.add((Component)jTextField, new GridConstraints(2, 2, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/CompilerBundle").getString("label.generate.ant.script.filename"));
        jPanel3.add((Component)jLabel, new GridConstraints(2, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myCbEnableUIFormsCompilation = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("messages/CompilerBundle").getString("label.generate.ant.script.enable.ui.forms.compilation"));
        jPanel2.add((Component)jCheckBox4, new GridConstraints(1, 0, 1, 1, 9, 0, 3, 0, null, null, null));
        this.myChunksPanel = jPanel = new JPanel();
        jPanel2.add((Component)jPanel, new GridConstraints(5, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        this.myCbForceTargetJdk = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/CompilerBundle").getString("label.generate.ant.script.use.jdk.definitions"));
        jPanel2.add((Component)jCheckBox3, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbInlineRuntimeClasspath = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/CompilerBundle").getString("label.generate.ant.script.inline.runtime.classpaths"));
        jPanel2.add((Component)jCheckBox2, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myGenerateIdeaHomeProperty = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/CompilerBundle").getString("label.generate.ant.script.generate.idea.home"));
        jCheckBox.setSelected(false);
        jPanel2.add((Component)jCheckBox, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static class MyTableCellRenderer
    extends DefaultTableCellRenderer {
        private MyTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof ListWithSelection) {
                value = ((ListWithSelection)value).getSelection();
            }
            JLabel component = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            component.setHorizontalAlignment(0);
            return component;
        }
    }

    private static class MyTableModel
    extends AbstractTableModel {
        private static final int NUMBER_COLUMN = 0;
        private static final int NAME_COLUMN = 1;
        private final List<Pair<String, ListWithSelection>> myItems = new ArrayList<Pair<String, ListWithSelection>>();

        private MyTableModel(List<Chunk<Module>> chunks) {
            for (Chunk<Module> chunk : chunks) {
                ListWithSelection item = new ListWithSelection();
                for (Module module : chunk.getNodes()) {
                    item.add((Object)module.getName());
                }
                item.selectFirst();
                this.myItems.add((Pair<String, ListWithSelection>)new Pair((Object)MyTableModel.createCycleName(chunk), (Object)item));
            }
        }

        private static String createCycleName(Chunk<Module> chunk) {
            StringBuilder buf = new StringBuilder();
            for (Module module : chunk.getNodes()) {
                if (buf.length() > 0) {
                    buf.append(", ");
                }
                buf.append(module.getName());
            }
            buf.insert(0, "[");
            buf.append("]");
            return buf.toString();
        }

        public String[] getModuleRepresentatives() {
            String[] names = new String[this.myItems.size()];
            int index = 0;
            for (Pair<String, ListWithSelection> pair : this.myItems) {
                names[index++] = (String)((ListWithSelection)pair.getSecond()).getSelection();
            }
            return names;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.myItems.size();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        public Class getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return ListWithSelection.class;
                }
            }
            return super.getColumnClass(columnIndex);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.myItems.get(rowIndex).getFirst();
                }
                case 1: {
                    return this.myItems.get(rowIndex).getSecond();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 1) {
                ((ListWithSelection)this.myItems.get(rowIndex).getSecond()).select(aValue);
            }
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return CompilerBundle.message((String)"generate.ant.build.dialog.cyclic.modules.table.number.column.header", (Object[])new Object[0]);
                }
                case 1: {
                    return CompilerBundle.message((String)"generate.ant.build.dialog.cyclic.modules.table.name.column.header", (Object[])new Object[0]);
                }
            }
            return super.getColumnName(columnIndex);
        }
    }
}

