/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.index;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.dupLocator.DuplicatesProfile;
import com.intellij.dupLocator.DuplocatorState;
import com.intellij.dupLocator.index.DuplicatesIndex;
import com.intellij.dupLocator.treeHash.FragmentsCollector;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.SmartList;
import com.intellij.util.indexing.FileBasedIndex;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TIntObjectHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuplicatesInspectionBase
extends LocalInspectionTool {
    @Nullable
    public ProblemDescriptor[] checkFile(final @NotNull PsiFile psiFile, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/dupLocator/index/DuplicatesInspectionBase", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/dupLocator/index/DuplicatesInspectionBase", "checkFile"));
        }
        final VirtualFile virtualFile = psiFile.getVirtualFile();
        if (!(virtualFile instanceof VirtualFileWithId) || !DuplicatesIndex.ourEnabled) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        final DuplicatesProfile profile = DuplicatesIndex.findDuplicatesProfile(psiFile.getFileType());
        if (profile == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        final DuplocatorState state = profile.getDuplocatorState(psiFile.getLanguage());
        SmartList descriptors = new SmartList();
        final TreeMap reportedRanges = new TreeMap();
        final TIntObjectHashMap reportedFiles = new TIntObjectHashMap();
        final TIntObjectHashMap reportedPsi = new TIntObjectHashMap();
        final TIntIntHashMap reportedOffsetInOtherFiles = new TIntIntHashMap();
        final TIntIntHashMap fragmentSize = new TIntIntHashMap();
        profile.createVisitor(new FragmentsCollector(){

            @Override
            public void add(int hash, int cost, final @Nullable PsiFragment frag) {
                if (!DuplicatesIndex.isIndexedFragment(frag, cost, profile, state)) {
                    return;
                }
                ProgressManager.checkCanceled();
                FileBasedIndex.getInstance().processValues(DuplicatesIndex.NAME, (Object)hash, null, (FileBasedIndex.ValueProcessor)new FileBasedIndex.ValueProcessor<TIntArrayList>(){
                    final ProjectFileIndex myProjectFileIndex;
                    {
                        this.myProjectFileIndex = ProjectFileIndex.SERVICE.getInstance((Project)psiFile.getProject());
                    }

                    public boolean process(VirtualFile file, TIntArrayList list) {
                        int len = list.size();
                        for (int i = 0; i < len; ++i) {
                            Integer fragmentStartOffsetInteger;
                            SortedMap map;
                            ProgressManager.checkCanceled();
                            int value = list.getQuick(i);
                            if (this.myProjectFileIndex.isInSource(virtualFile) && !this.myProjectFileIndex.isInSource(file)) {
                                return true;
                            }
                            if (!this.myProjectFileIndex.isInSource(virtualFile) && this.myProjectFileIndex.isInSource(file)) {
                                return true;
                            }
                            int startOffset = frag.getStartOffset();
                            int endOffset = frag.getEndOffset();
                            if (file.equals(virtualFile) && value >= startOffset && value < endOffset) continue;
                            PsiElement[] elements = frag.getElements();
                            PsiElement target = elements[0];
                            TextRange rangeInElement = null;
                            if (elements.length > 1) {
                                PsiElement firstElement = elements[0];
                                target = firstElement.getParent();
                                PsiElement lastElement = elements[elements.length - 1];
                                rangeInElement = new TextRange(elements[0].getStartOffsetInParent(), lastElement.getStartOffsetInParent() + lastElement.getTextLength());
                            }
                            int newFragmentSize = !(map = reportedRanges.subMap(fragmentStartOffsetInteger = Integer.valueOf(startOffset), endOffset)).isEmpty() ? 0 : 1;
                            Iterator<Integer> iterator = map.keySet().iterator();
                            while (iterator.hasNext()) {
                                Integer next = iterator.next();
                                iterator.remove();
                                reportedFiles.remove(next.intValue());
                                reportedOffsetInOtherFiles.remove(next.intValue());
                                reportedPsi.remove(next.intValue());
                                newFragmentSize += fragmentSize.remove(next.intValue());
                            }
                            reportedRanges.put(fragmentStartOffsetInteger, rangeInElement);
                            reportedFiles.put(fragmentStartOffsetInteger.intValue(), (Object)file);
                            reportedOffsetInOtherFiles.put(fragmentStartOffsetInteger.intValue(), value);
                            reportedPsi.put(fragmentStartOffsetInteger.intValue(), (Object)target);
                            fragmentSize.put(fragmentStartOffsetInteger.intValue(), newFragmentSize);
                            return false;
                        }
                        return true;
                    }
                }, GlobalSearchScope.projectScope((Project)psiFile.getProject()));
            }
        }, true).visitNode((PsiElement)psiFile);
        for (Map.Entry entry : reportedRanges.entrySet()) {
            Integer offset = (Integer)entry.getKey();
            if (fragmentSize.get(offset.intValue()) < 3) continue;
            VirtualFile file = (VirtualFile)reportedFiles.get(offset.intValue());
            String message = "Found duplicated code in " + file.getPath();
            PsiElement targetElement = (PsiElement)reportedPsi.get(offset.intValue());
            TextRange rangeInElement = (TextRange)entry.getValue();
            int offsetInOtherFile = reportedOffsetInOtherFiles.get(offset.intValue());
            LocalQuickFix fix = this.createNavigateToDupeFix(file, offsetInOtherFile);
            ProblemDescriptor descriptor = manager.createProblemDescriptor(targetElement, rangeInElement, message, ProblemHighlightType.WEAK_WARNING, isOnTheFly, new LocalQuickFix[]{fix});
            descriptors.add((Object)descriptor);
        }
        return descriptors.isEmpty() ? null : (ProblemDescriptor[])descriptors.toArray((Object[])new ProblemDescriptor[descriptors.size()]);
    }

    protected LocalQuickFix createNavigateToDupeFix(@NotNull VirtualFile file, int offsetInOtherFile) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/dupLocator/index/DuplicatesInspectionBase", "createNavigateToDupeFix"));
        }
        return null;
    }
}

