/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.push.ui;

import com.intellij.CommonBundle;
import com.intellij.dvcs.push.PushController;
import com.intellij.dvcs.push.PushSupport;
import com.intellij.dvcs.push.VcsPushOptionValue;
import com.intellij.dvcs.push.VcsPushOptionsPanel;
import com.intellij.dvcs.push.ui.PushLog;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.OptionAction;
import com.intellij.openapi.ui.ValidationInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsPushDialog
extends DialogWrapper {
    private static final String ID = "Vcs.Push.Dialog";
    @NotNull
    private final Project myProject;
    private final PushLog myListPanel;
    private final PushController myController;
    private final Map<PushSupport, VcsPushOptionsPanel> myAdditionalPanels;
    private Action myPushAction;
    @Nullable
    private ForcePushAction myForcePushAction;

    public VcsPushDialog(@NotNull Project project, @NotNull List<? extends Repository> selectedRepositories, @Nullable Repository currentRepo) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/push/ui/VcsPushDialog", "<init>"));
        }
        if (selectedRepositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedRepositories", "com/intellij/dvcs/push/ui/VcsPushDialog", "<init>"));
        }
        super(project);
        this.myProject = project;
        this.myController = new PushController(project, this, selectedRepositories, currentRepo);
        this.myAdditionalPanels = this.myController.createAdditionalPanels();
        this.myListPanel = this.myController.getPushPanelLog();
        this.init();
        this.enableOkActions(this.myController.isPushAllowed());
        this.setOKButtonText("Push");
        this.setOKButtonMnemonic(80);
        this.setTitle("Push Commits");
    }

    protected JComponent createCenterPanel() {
        JPanel rootPanel = new JPanel(new BorderLayout(0, 15));
        rootPanel.add((Component)this.myListPanel, "Center");
        JPanel optionsPanel = new JPanel((LayoutManager)new MigLayout("ins 0 0, flowx"));
        for (VcsPushOptionsPanel panel : this.myAdditionalPanels.values()) {
            optionsPanel.add((Component)panel);
        }
        rootPanel.add((Component)optionsPanel, "South");
        return rootPanel;
    }

    protected String getDimensionServiceKey() {
        return ID;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        this.enableOkActions(this.myController.isPushAllowed());
        return null;
    }

    protected boolean postponeValidation() {
        return false;
    }

    @NotNull
    protected Action[] createActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        if (this.myController.isForcePushEnabled()) {
            this.myForcePushAction = new ForcePushAction();
            this.myForcePushAction.setEnabled(this.myController.isForcePushAllowed());
            this.myPushAction = new ComplexPushAction(this.myForcePushAction);
        } else {
            this.myPushAction = new SimplePushAction();
        }
        this.myPushAction.putValue("DefaultAction", Boolean.TRUE);
        actions.add(this.myPushAction);
        actions.add(this.getCancelAction());
        actions.add(this.getHelpAction());
        Action[] actionArray = actions.toArray(new Action[actions.size()]);
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/ui/VcsPushDialog", "createActions"));
        }
        return actionArray;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myListPanel.getPreferredFocusedComponent();
    }

    @NotNull
    protected Action getOKAction() {
        Action action = this.myPushAction;
        if (action == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/ui/VcsPushDialog", "getOKAction"));
        }
        return action;
    }

    protected String getHelpId() {
        return ID;
    }

    public void enableOkActions(boolean isEnabled) {
        this.myPushAction.setEnabled(isEnabled);
        if (this.myForcePushAction != null) {
            this.myForcePushAction.setEnabled(isEnabled && this.myController.isForcePushAllowed());
        }
    }

    @Nullable
    public VcsPushOptionValue getAdditionalOptionValue(@NotNull PushSupport support) {
        if (support == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "support", "com/intellij/dvcs/push/ui/VcsPushDialog", "getAdditionalOptionValue"));
        }
        VcsPushOptionsPanel panel = this.myAdditionalPanels.get(support);
        return panel == null ? null : panel.getValue();
    }

    private class ComplexPushAction
    extends SimplePushAction
    implements OptionAction {
        private final Action[] myOptions;

        private ComplexPushAction(Action additionalAction) {
            this.myOptions = new Action[]{additionalAction};
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            for (Action optionAction : this.myOptions) {
                optionAction.setEnabled(isEnabled);
            }
        }

        @NotNull
        public Action[] getOptions() {
            if (this.myOptions == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/ui/VcsPushDialog$ComplexPushAction", "getOptions"));
            }
            return this.myOptions;
        }
    }

    private class ForcePushAction
    extends AbstractAction {
        ForcePushAction() {
            super("&Force Push");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int answer = Messages.showOkCancelDialog((Project)VcsPushDialog.this.myProject, (String)"You're going to force push. It will overwrite commits at the remote. Are you sure you want to proceed?", (String)"Force Push", (String)"&Force Push", (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getWarningIcon());
            if (answer == 0) {
                VcsPushDialog.this.myController.push(true);
                VcsPushDialog.this.close(0);
            }
        }
    }

    private class SimplePushAction
    extends AbstractAction {
        SimplePushAction() {
            super("&Push");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            VcsPushDialog.this.myController.push(false);
            VcsPushDialog.this.close(0);
        }
    }
}

