/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.ui;

import com.intellij.facet.ui.FacetConfigurationQuickFix;
import com.intellij.facet.ui.FacetEditorValidator;
import com.intellij.facet.ui.FacetValidatorsManager;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ui.UserActivityListener;
import com.intellij.ui.UserActivityWatcher;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class FacetErrorPanel {
    private final JPanel myMainPanel;
    private JPanel myButtonPanel;
    private JButton myQuickFixButton;
    private FacetConfigurationQuickFix myCurrentQuickFix;
    private final JLabel myWarningLabel;
    private final FacetValidatorsManagerImpl myValidatorsManager;
    private boolean myNoErrors = true;
    private final List<Runnable> myListeners;

    public FacetErrorPanel() {
        this.$$$setupUI$$$();
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myValidatorsManager = new FacetValidatorsManagerImpl();
        this.myWarningLabel = new JLabel();
        this.myWarningLabel.setIcon(AllIcons.General.WarningDialog);
        this.myQuickFixButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FacetErrorPanel.this.myCurrentQuickFix != null) {
                    FacetErrorPanel.this.myCurrentQuickFix.run((JComponent)FacetErrorPanel.this.myQuickFixButton);
                    FacetErrorPanel.this.myValidatorsManager.validate();
                }
            }
        });
        this.myMainPanel = new JPanel(new BorderLayout());
        this.myMainPanel.add("East", this.myButtonPanel);
        this.myMainPanel.add("Center", this.myWarningLabel);
        this.setNoErrors();
    }

    public void addListener(Runnable listener) {
        this.myListeners.add(listener);
    }

    private void changeValidity(boolean noErrors) {
        this.myNoErrors = noErrors;
        for (Runnable listener : this.myListeners) {
            listener.run();
        }
    }

    private void setNoErrors() {
        this.myMainPanel.setVisible(false);
        this.myWarningLabel.setVisible(false);
        this.myQuickFixButton.setVisible(false);
        this.changeValidity(true);
    }

    public void disposeUIResources() {
        this.myCurrentQuickFix = null;
    }

    public JComponent getComponent() {
        return this.myMainPanel;
    }

    public boolean isOk() {
        return this.myNoErrors;
    }

    @NotNull
    public FacetValidatorsManager getValidatorsManager() {
        FacetValidatorsManagerImpl facetValidatorsManagerImpl = this.myValidatorsManager;
        if (facetValidatorsManagerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/impl/ui/FacetErrorPanel", "getValidatorsManager"));
        }
        return facetValidatorsManagerImpl;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JPanel jPanel;
        this.myButtonPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myQuickFixButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("messages/IdeBundle").getString("button.facet.quickfix.text"));
        jPanel.add((Component)jButton, new GridConstraints(0, 0, 1, 1, 1, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myButtonPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private class FacetValidatorsManagerImpl
    implements FacetValidatorsManager {
        private final List<FacetEditorValidator> myValidators = new ArrayList<FacetEditorValidator>();

        private FacetValidatorsManagerImpl() {
        }

        public void registerValidator(FacetEditorValidator validator, JComponent ... componentsToWatch) {
            this.myValidators.add(validator);
            UserActivityWatcher watcher = new UserActivityWatcher();
            for (JComponent component : componentsToWatch) {
                watcher.register((Component)component);
            }
            watcher.addUserActivityListener(new UserActivityListener(){

                public void stateChanged() {
                    FacetValidatorsManagerImpl.this.validate();
                }
            });
        }

        public void validate() {
            for (FacetEditorValidator validator : this.myValidators) {
                ValidationResult validationResult = validator.check();
                if (validationResult.isOk()) continue;
                FacetErrorPanel.this.myMainPanel.setVisible(true);
                FacetErrorPanel.this.myWarningLabel.setText(XmlStringUtil.wrapInHtml((CharSequence)validationResult.getErrorMessage()));
                FacetErrorPanel.this.myWarningLabel.setVisible(true);
                FacetErrorPanel.this.myCurrentQuickFix = validationResult.getQuickFix();
                FacetErrorPanel.this.myQuickFixButton.setVisible(FacetErrorPanel.this.myCurrentQuickFix != null);
                if (FacetErrorPanel.this.myCurrentQuickFix != null) {
                    String buttonText = FacetErrorPanel.this.myCurrentQuickFix.getFixButtonText();
                    FacetErrorPanel.this.myQuickFixButton.setText(buttonText != null ? buttonText : IdeBundle.message((String)"button.facet.quickfix.text", (Object[])new Object[0]));
                }
                FacetErrorPanel.this.changeValidity(false);
                return;
            }
            FacetErrorPanel.this.myCurrentQuickFix = null;
            FacetErrorPanel.this.setNoErrors();
        }
    }
}

