/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindResult;
import com.intellij.find.FindSettings;
import com.intellij.find.FindUtil;
import com.intellij.find.editorHeaderActions.AddOccurrenceAction;
import com.intellij.find.editorHeaderActions.CloseOnESCAction;
import com.intellij.find.editorHeaderActions.FindAllAction;
import com.intellij.find.editorHeaderActions.NextOccurrenceAction;
import com.intellij.find.editorHeaderActions.PrevOccurrenceAction;
import com.intellij.find.editorHeaderActions.RemoveOccurrenceAction;
import com.intellij.find.editorHeaderActions.ReplaceOnEnterAction;
import com.intellij.find.editorHeaderActions.RestorePreviousSettingsAction;
import com.intellij.find.editorHeaderActions.SelectAllAction;
import com.intellij.find.editorHeaderActions.ShowHistoryAction;
import com.intellij.find.editorHeaderActions.ShowMoreOptions;
import com.intellij.find.editorHeaderActions.SwitchToFind;
import com.intellij.find.editorHeaderActions.SwitchToReplace;
import com.intellij.find.editorHeaderActions.ToggleExceptCommentsAction;
import com.intellij.find.editorHeaderActions.ToggleExceptCommentsAndLiteralsAction;
import com.intellij.find.editorHeaderActions.ToggleExceptLiteralsAction;
import com.intellij.find.editorHeaderActions.ToggleInCommentsAction;
import com.intellij.find.editorHeaderActions.ToggleInLiteralsOnlyAction;
import com.intellij.find.editorHeaderActions.ToggleMatchCase;
import com.intellij.find.editorHeaderActions.ToggleMultiline;
import com.intellij.find.editorHeaderActions.TogglePreserveCaseAction;
import com.intellij.find.editorHeaderActions.ToggleRegex;
import com.intellij.find.editorHeaderActions.ToggleSelectionOnlyAction;
import com.intellij.find.editorHeaderActions.ToggleWholeWordsOnlyAction;
import com.intellij.find.editorHeaderActions.Utils;
import com.intellij.find.editorHeaderActions.VariantsCompletionAction;
import com.intellij.find.impl.livePreview.LivePreviewController;
import com.intellij.find.impl.livePreview.SearchResults;
import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.impl.EditorHeaderComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.LightColors;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorSearchComponent
extends EditorHeaderComponent
implements DataProvider,
SelectionListener,
SearchResults.SearchResultsListener {
    private JLabel myMatchInfoLabel;
    private LinkLabel myClickToHighlightLabel;
    private final Project myProject;
    private ActionToolbar myActionsToolbar;
    @NotNull
    private final Editor myEditor;
    private final JBSplitter mySplitPane;
    private final JPanel myLeftComponent;
    private final JPanel myRightComponent;
    private JTextComponent mySearchField;
    private JComponent mySearchRootComponent;
    private JTextComponent myReplaceField;
    private JComponent myReplaceRootComponent;
    private final Getter<JTextComponent> mySearchFieldGetter;
    private final Getter<JTextComponent> myReplaceFieldGetter;
    private final Color myDefaultBackground;
    private JButton myReplaceButton;
    private JButton myReplaceAllButton;
    private JButton myExcludeButton;
    public static final Color COMPLETION_BACKGROUND_COLOR = new Color(235, 244, 254);
    private static final Color FOCUS_CATCHER_COLOR = new Color(0x9999FF);
    private JComponent myToolbarComponent;
    private final LivePreviewController myLivePreviewController;
    private final SearchResults mySearchResults;
    private final FindModel myFindModel;
    private JPanel myReplacementPane;

    @NotNull
    public Editor getEditor() {
        Editor editor = this.myEditor;
        if (editor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/EditorSearchComponent", "getEditor"));
        }
        return editor;
    }

    public JTextComponent getSearchField() {
        return this.mySearchField;
    }

    public JTextComponent getReplaceField() {
        return this.myReplaceField;
    }

    public JComponent getToolbarComponent() {
        return this.myToolbarComponent;
    }

    private void updateReplaceButton() {
        if (this.myReplaceButton != null) {
            this.myReplaceButton.setEnabled(this.canReplaceCurrent());
        }
    }

    public void restoreFindModel() {
        FindModel model = FindManager.getInstance((Project)this.myProject).getPreviousFindModel();
        if (model != null) {
            this.myFindModel.copyFrom(model);
            this.updateUIWithFindModel();
        }
    }

    private static FindModel createDefaultFindModel(Project p, Editor e) {
        String selectedText;
        FindModel findModel = new FindModel();
        findModel.copyFrom(FindManager.getInstance((Project)p).getFindInFileModel());
        if (e.getSelectionModel().hasSelection() && (selectedText = e.getSelectionModel().getSelectedText()) != null) {
            findModel.setStringToFind(selectedText);
        }
        findModel.setPromptOnReplace(false);
        return findModel;
    }

    public EditorSearchComponent(@NotNull Editor editor, Project project) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/find/EditorSearchComponent", "<init>"));
        }
        this(editor, project, EditorSearchComponent.createDefaultFindModel(project, editor));
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (SpeedSearchSupply.SPEED_SEARCH_CURRENT_QUERY.is(dataId)) {
            return this.mySearchField.getText();
        }
        if (CommonDataKeys.EDITOR_EVEN_IF_INACTIVE.is(dataId)) {
            return this.myEditor;
        }
        return null;
    }

    @Override
    public void searchResultsUpdated(SearchResults sr) {
        if (this.mySearchField.getText().isEmpty()) {
            this.updateUIWithEmptyResults();
        } else {
            int count = sr.getMatchesCount();
            if (count <= this.mySearchResults.getMatchesLimit()) {
                this.myClickToHighlightLabel.setVisible(false);
                if (count > 0) {
                    this.setRegularBackground();
                    if (count > 1) {
                        this.myMatchInfoLabel.setText(count + " matches");
                    } else {
                        this.myMatchInfoLabel.setText("1 match");
                    }
                } else {
                    this.setNotFoundBackground();
                    this.myMatchInfoLabel.setText("No matches ");
                    this.boldMatchInfo();
                }
            } else {
                this.setRegularBackground();
                this.myMatchInfoLabel.setText("More than " + this.mySearchResults.getMatchesLimit() + " matches");
                this.myClickToHighlightLabel.setVisible(true);
                this.boldMatchInfo();
            }
        }
        this.updateExcludeStatus();
    }

    @Override
    public void cursorMoved() {
        this.updateExcludeStatus();
    }

    @Override
    public void updateFinished() {
    }

    public EditorSearchComponent(@NotNull Editor editor, Project project, FindModel findModel) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/find/EditorSearchComponent", "<init>"));
        }
        this.mySplitPane = new JBSplitter(false);
        this.myLeftComponent = new JPanel(new BorderLayout());
        this.myRightComponent = new JPanel(new BorderLayout());
        this.mySplitPane.setBorder(IdeBorderFactory.createEmptyBorder((int)1, (int)0, (int)2, (int)0));
        this.mySplitPane.setHonorComponentsMinimumSize(true);
        this.mySplitPane.setProportion(0.25f);
        this.mySplitPane.setAndLoadSplitterProportionKey("FindSplitterProportion");
        this.mySplitPane.setOpaque(false);
        this.mySplitPane.getDivider().setOpaque(false);
        this.myLeftComponent.setOpaque(false);
        this.myRightComponent.setOpaque(false);
        this.mySplitPane.setFirstComponent((JComponent)this.myLeftComponent);
        this.mySplitPane.setSecondComponent((JComponent)this.myRightComponent);
        this.add((Component)this.mySplitPane, "North");
        this.mySearchFieldGetter = new Getter<JTextComponent>(){

            public JTextComponent get() {
                return EditorSearchComponent.this.mySearchField;
            }
        };
        this.myReplaceFieldGetter = new Getter<JTextComponent>(){

            public JTextComponent get() {
                return EditorSearchComponent.this.myReplaceField;
            }
        };
        this.myFindModel = findModel;
        this.myProject = project;
        this.myEditor = editor;
        this.mySearchResults = new SearchResults(this.myEditor, this.myProject);
        this.myLivePreviewController = new LivePreviewController(this.mySearchResults, this);
        this.myDefaultBackground = new JTextField().getBackground();
        this.configureLeadPanel();
        new SwitchToFind(this);
        new SwitchToReplace(this);
        this.myFindModel.addObserver(new FindModel.FindModelObserver(){

            public void findModelChanged(FindModel findModel) {
                String stringToFind = EditorSearchComponent.this.myFindModel.getStringToFind();
                if (!EditorSearchComponent.wholeWordsApplicable(stringToFind)) {
                    EditorSearchComponent.this.myFindModel.setWholeWordsOnly(false);
                }
                EditorSearchComponent.this.updateUIWithFindModel();
                EditorSearchComponent.this.updateResults(true);
                EditorSearchComponent.syncFindModels(FindManager.getInstance((Project)EditorSearchComponent.this.myProject).getFindInFileModel(), EditorSearchComponent.this.myFindModel);
            }
        });
        this.updateUIWithFindModel();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.initLivePreview();
        }
    }

    private void configureLeadPanel() {
        SearchTextField searchTextField;
        JPanel myLeadPanel = EditorSearchComponent.createLeadPane();
        this.myRightComponent.add((Component)myLeadPanel, "West");
        Ref ref = Ref.create();
        this.mySearchField = this.createTextField("North", (Ref<JComponent>)ref);
        this.mySearchRootComponent = (JComponent)ref.get();
        SearchTextField searchTextField2 = searchTextField = ref.get() instanceof SearchTextField ? (SearchTextField)ref.get() : null;
        if (searchTextField != null) {
            this.setupHistoryToSearchField(searchTextField, FindSettings.getInstance().getRecentFindStrings());
        }
        UIUtil.addUndoRedoActions((JTextComponent)this.mySearchField);
        this.setupSearchFieldListener();
        if (this.myActionsToolbar == null) {
            this.initToolbar();
        }
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.setOpaque(false);
        centerPanel.add((Component)this.myToolbarComponent, "Center");
        this.myRightComponent.add((Component)centerPanel, "Center");
        if (this.secondaryActionsAvailable() && this.myToolbarComponent instanceof ActionToolbarImpl) {
            new ShowMoreOptions(this.myToolbarComponent, this.mySearchField);
        }
        NonOpaquePanel tailPanel = new NonOpaquePanel((LayoutManager)new BorderLayout(5, 0));
        NonOpaquePanel tailContainer = new NonOpaquePanel((LayoutManager)new BorderLayout(5, 0));
        tailContainer.add((Component)tailPanel, "East");
        centerPanel.add((Component)tailContainer, "East");
        JLabel closeLabel = new JLabel(" ", AllIcons.Actions.Cross, 4);
        closeLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                EditorSearchComponent.this.close();
            }
        });
        closeLabel.setToolTipText("Close search bar (Escape)");
        tailPanel.add((Component)closeLabel, "East");
        Utils.setSmallerFont(this.mySearchField);
        this.mySearchField.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (StringUtil.isEmpty((String)EditorSearchComponent.this.mySearchField.getText())) {
                    EditorSearchComponent.this.close();
                } else {
                    EditorSearchComponent.this.requestFocus(EditorSearchComponent.this.myEditor.getContentComponent());
                    EditorSearchComponent.this.addTextToRecent(EditorSearchComponent.this.mySearchField);
                }
            }
        }, KeyStroke.getKeyStroke(10, SystemInfo.isMac ? 256 : 128), 0);
        final String initialText = this.myFindModel.getStringToFind();
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                EditorSearchComponent.this.setInitialText(initialText);
            }
        });
        new RestorePreviousSettingsAction(this, this.mySearchField);
        new VariantsCompletionAction(this, this.mySearchFieldGetter);
        Utils.setSmallerFontForChildren(this.myToolbarComponent);
    }

    private void setupHistoryToSearchField(SearchTextField field, String[] strings) {
        field.setHistorySize(20);
        field.setHistory(ContainerUtil.reverse(Arrays.asList(strings)));
    }

    private void initToolbar() {
        DefaultActionGroup actionGroup = new DefaultActionGroup("search bar", false);
        actionGroup.add((AnAction)new ShowHistoryAction(this.mySearchFieldGetter, this));
        actionGroup.add((AnAction)new PrevOccurrenceAction(this, this.mySearchFieldGetter));
        actionGroup.add((AnAction)new NextOccurrenceAction(this, this.mySearchFieldGetter));
        actionGroup.add((AnAction)new AddOccurrenceAction(this));
        actionGroup.add((AnAction)new RemoveOccurrenceAction(this));
        actionGroup.add((AnAction)new SelectAllAction(this));
        actionGroup.add((AnAction)new FindAllAction(this));
        actionGroup.add((AnAction)new ToggleMultiline(this));
        actionGroup.add((AnAction)new ToggleMatchCase(this));
        actionGroup.add((AnAction)new ToggleRegex(this));
        this.myMatchInfoLabel = new JLabel();
        this.myClickToHighlightLabel = new LinkLabel("Click to highlight", null, new LinkListener(){

            public void linkSelected(LinkLabel aSource, Object aLinkData) {
                EditorSearchComponent.this.setMatchesLimit(Integer.MAX_VALUE);
                EditorSearchComponent.this.updateResults(true);
            }
        });
        this.myClickToHighlightLabel.setVisible(false);
        this.myActionsToolbar = ActionManager.getInstance().createActionToolbar("EditorToolbar", (ActionGroup)actionGroup, true);
        this.myActionsToolbar.setSecondaryActionsTooltip("More Options(" + ShowMoreOptions.SHORT_CUT + ")");
        actionGroup.addAction((AnAction)new ToggleWholeWordsOnlyAction(this));
        if (this.secondaryActionsAvailable()) {
            actionGroup.addAction((AnAction)new ToggleInCommentsAction(this)).setAsSecondary(true);
            actionGroup.addAction((AnAction)new ToggleInLiteralsOnlyAction(this)).setAsSecondary(true);
            actionGroup.addAction((AnAction)new ToggleExceptCommentsAction(this)).setAsSecondary(true);
            actionGroup.addAction((AnAction)new ToggleExceptLiteralsAction(this)).setAsSecondary(true);
            actionGroup.addAction((AnAction)new ToggleExceptCommentsAndLiteralsAction(this)).setAsSecondary(true);
        }
        actionGroup.addAction((AnAction)new TogglePreserveCaseAction(this));
        actionGroup.addAction((AnAction)new ToggleSelectionOnlyAction(this));
        class MyCustomComponentDoNothingAction
        extends AnAction
        implements CustomComponentAction {
            private final JComponent c;

            MyCustomComponentDoNothingAction(JComponent c) {
                this.c = c;
                c.setBorder(IdeBorderFactory.createEmptyBorder((Insets)new Insets(0, 10, 0, 0)));
            }

            public void actionPerformed(AnActionEvent e) {
            }

            public JComponent createCustomComponent(Presentation presentation) {
                return this.c;
            }
        }
        actionGroup.add((AnAction)new MyCustomComponentDoNothingAction(this.myMatchInfoLabel));
        actionGroup.add((AnAction)new MyCustomComponentDoNothingAction((JComponent)this.myClickToHighlightLabel));
        this.myActionsToolbar.setLayoutPolicy(2);
        this.myToolbarComponent = this.myActionsToolbar.getComponent();
        this.myToolbarComponent.setBorder(null);
        this.myToolbarComponent.setOpaque(false);
    }

    public void selectAllText() {
        this.mySearchField.selectAll();
    }

    private boolean secondaryActionsAvailable() {
        return true;
    }

    private void setupSearchFieldListener() {
        this.mySearchField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                EditorSearchComponent.this.searchFieldDocumentChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                EditorSearchComponent.this.searchFieldDocumentChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                EditorSearchComponent.this.searchFieldDocumentChanged();
            }
        });
    }

    private void searchFieldDocumentChanged() {
        this.setMatchesLimit(10000);
        String text = this.mySearchField.getText();
        this.myFindModel.setStringToFind(text);
        if (!StringUtil.isEmpty((String)text)) {
            this.updateResults(true);
        } else {
            this.nothingToSearchFor();
        }
        if (this.mySearchField instanceof JTextArea) {
            EditorSearchComponent.adjustRows((JTextArea)this.mySearchField, 2, 6);
        }
    }

    private static void adjustRows(JTextArea area, int minRows, int maxRows) {
        area.setRows(Math.max(minRows, Math.min(maxRows, area.getText().split("\n").length)));
    }

    public boolean isRegexp() {
        return this.myFindModel.isRegularExpressions();
    }

    public void setRegexp(boolean val) {
        this.myFindModel.setRegularExpressions(val);
    }

    public FindModel getFindModel() {
        return this.myFindModel;
    }

    private static void syncFindModels(FindModel to, FindModel from) {
        to.setCaseSensitive(from.isCaseSensitive());
        to.setWholeWordsOnly(from.isWholeWordsOnly());
        to.setRegularExpressions(from.isRegularExpressions());
        to.setSearchContext(from.getSearchContext());
        if (from.isReplaceState()) {
            to.setPreserveCase(from.isPreserveCase());
        }
    }

    private void updateUIWithFindModel() {
        String stringToFind;
        boolean needToResetFocus = false;
        this.myActionsToolbar.updateActionsImmediately();
        if (this.myFindModel.isMultiline() && this.mySearchField instanceof JTextField || !this.myFindModel.isMultiline() && this.mySearchField instanceof JTextArea) {
            needToResetFocus = this.mySearchField.hasFocus();
            this.myLeftComponent.removeAll();
            this.myRightComponent.removeAll();
            this.myReplaceRootComponent = null;
            this.mySearchRootComponent = null;
            this.configureLeadPanel();
            if (this.myReplacementPane != null) {
                this.myReplacementPane = null;
            }
        }
        if (!StringUtil.equals((CharSequence)(stringToFind = this.myFindModel.getStringToFind()), (CharSequence)this.mySearchField.getText())) {
            this.mySearchField.setText(stringToFind);
        }
        this.myLivePreviewController.setTrackingSelection(!this.myFindModel.isGlobal());
        if (this.myFindModel.isReplaceState() && this.myReplacementPane == null) {
            this.configureReplacementPane();
        } else if (!this.myFindModel.isReplaceState() && this.myReplacementPane != null) {
            if (this.myReplaceRootComponent != null) {
                this.myLeftComponent.remove(this.myReplaceRootComponent);
                this.myReplaceRootComponent = null;
                this.myReplaceField = null;
            }
            this.myRightComponent.remove(this.myReplacementPane);
            this.myReplacementPane = null;
        }
        if (this.myFindModel.isReplaceState()) {
            String stringToReplace = this.myFindModel.getStringToReplace();
            if (!StringUtil.equals((CharSequence)stringToReplace, (CharSequence)this.myReplaceField.getText())) {
                this.myReplaceField.setText(stringToReplace);
            }
            this.updateExcludeStatus();
        }
        this.updateReplaceButton();
        Utils.setSmallerFontForChildren(this.myToolbarComponent);
        this.revalidate();
        if (needToResetFocus) {
            this.mySearchField.requestFocusInWindow();
        }
    }

    private static boolean wholeWordsApplicable(String stringToFind) {
        return !stringToFind.startsWith(" ") && !stringToFind.startsWith("\t") && !stringToFind.endsWith(" ") && !stringToFind.endsWith("\t");
    }

    private void setMatchesLimit(int value) {
        this.mySearchResults.setMatchesLimit(value);
    }

    private void configureReplacementPane() {
        SearchTextField searchTextField;
        this.myReplacementPane = new NonOpaquePanel((LayoutManager)new FlowLayout(0, 5, 0));
        Ref ref = Ref.create();
        this.myReplaceField = this.createTextField("South", (Ref<JComponent>)ref);
        this.myReplaceRootComponent = (JComponent)ref.get();
        SearchTextField searchTextField2 = searchTextField = ref.get() instanceof SearchTextField ? (SearchTextField)ref.get() : null;
        if (searchTextField != null) {
            this.setupHistoryToSearchField(searchTextField, FindSettings.getInstance().getRecentReplaceStrings());
        }
        UIUtil.addUndoRedoActions((JTextComponent)this.myReplaceField);
        this.revalidate();
        DocumentListener replaceFieldListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                EditorSearchComponent.this.replaceFieldDocumentChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                EditorSearchComponent.this.replaceFieldDocumentChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                EditorSearchComponent.this.replaceFieldDocumentChanged();
            }
        };
        this.myReplaceField.getDocument().addDocumentListener(replaceFieldListener);
        if (!this.getFindModel().isMultiline()) {
            new ReplaceOnEnterAction(this, this.myReplaceField);
        }
        this.myReplaceField.setText(this.myFindModel.getStringToReplace());
        this.myRightComponent.add((Component)this.myReplacementPane, "South");
        this.myReplaceButton = new JButton("Replace");
        this.myReplaceButton.setFocusable(false);
        this.myReplaceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditorSearchComponent.this.replaceCurrent();
            }
        });
        this.myReplaceAllButton = new JButton("Replace all");
        this.myReplaceAllButton.setFocusable(false);
        this.myReplaceAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditorSearchComponent.this.myLivePreviewController.performReplaceAll();
            }
        });
        this.myExcludeButton = new JButton("");
        this.myExcludeButton.setFocusable(false);
        this.myExcludeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditorSearchComponent.this.myLivePreviewController.exclude();
                EditorSearchComponent.this.moveCursor(SearchResults.Direction.DOWN);
            }
        });
        if (!UISettings.getInstance().DISABLE_MNEMONICS_IN_CONTROLS) {
            this.myReplaceButton.setMnemonic('p');
            this.myReplaceAllButton.setMnemonic('a');
            this.myExcludeButton.setMnemonic('l');
        }
        DefaultActionGroup actionsGroup = new DefaultActionGroup(new AnAction[]{new ShowHistoryAction(this.myReplaceFieldGetter, this)});
        ActionToolbar tb = ActionManager.getInstance().createActionToolbar("ReplaceBar", (ActionGroup)actionsGroup, true);
        tb.setLayoutPolicy(2);
        JComponent tbComponent = tb.getComponent();
        tbComponent.setOpaque(false);
        tbComponent.setBorder(null);
        this.myReplacementPane.add(tbComponent);
        this.myReplacementPane.add(this.myReplaceButton);
        this.myReplacementPane.add(this.myReplaceAllButton);
        this.myReplacementPane.add(this.myExcludeButton);
        EditorSearchComponent.setSmallerFontAndOpaque(this.myReplaceButton);
        EditorSearchComponent.setSmallerFontAndOpaque(this.myReplaceAllButton);
        EditorSearchComponent.setSmallerFontAndOpaque(this.myExcludeButton);
        Utils.setSmallerFont(this.myReplaceField);
        new VariantsCompletionAction(this, this.myReplaceFieldGetter);
        new NextOccurrenceAction(this, this.myReplaceFieldGetter);
        new PrevOccurrenceAction(this, this.myReplaceFieldGetter);
    }

    private void replaceFieldDocumentChanged() {
        this.setMatchesLimit(10000);
        this.myFindModel.setStringToReplace(this.myReplaceField.getText());
        if (this.myReplaceField instanceof JTextArea) {
            EditorSearchComponent.adjustRows((JTextArea)this.myReplaceField, 2, 6);
        }
    }

    private boolean canReplaceCurrent() {
        return this.myLivePreviewController != null && this.myLivePreviewController.canReplace();
    }

    public void replaceCurrent() {
        if (this.mySearchResults.getCursor() != null) {
            this.myLivePreviewController.performReplace();
        }
    }

    private void updateExcludeStatus() {
        if (this.myExcludeButton != null && this.mySearchResults != null) {
            FindResult cursor = this.mySearchResults.getCursor();
            this.myExcludeButton.setText(cursor == null || !this.mySearchResults.isExcluded(cursor) ? "Exclude" : "Include");
            this.myReplaceAllButton.setEnabled(this.mySearchResults.hasMatches());
            this.myExcludeButton.setEnabled(cursor != null);
            this.updateReplaceButton();
        }
    }

    private static JPanel createLeadPane() {
        return new NonOpaquePanel((LayoutManager)new BorderLayout());
    }

    public void showHistory(boolean byClickingToolbarButton, JTextComponent textField) {
        FeatureUsageTracker.getInstance().triggerFeatureUsed("find.recent.search");
        FindSettings settings = FindSettings.getInstance();
        Object[] recent = textField == this.mySearchField ? settings.getRecentFindStrings() : settings.getRecentReplaceStrings();
        boolean toShowAd = textField == this.mySearchField && textField.getText().isEmpty() && FindManager.getInstance((Project)this.myProject).getPreviousFindModel() != null;
        Utils.showCompletionPopup(byClickingToolbarButton ? this.myToolbarComponent : null, (JList)new JBList(ArrayUtil.reverseArray((Object[])recent)), "Recent " + (textField == this.mySearchField ? "Searches" : "Replaces"), textField, toShowAd ? RestorePreviousSettingsAction.getAd() : null);
    }

    private String gerRestoreFindModelAd() {
        return "Use " + KeyStroke.getKeyStroke(10, 0) + " to restore your last search/replace settings";
    }

    private void paintBorderOfTextField(Graphics g) {
        if (!UIUtil.isUnderAquaLookAndFeel() && !UIUtil.isUnderGTKLookAndFeel() && !UIUtil.isUnderNimbusLookAndFeel() && this.isFocusOwner()) {
            Rectangle bounds = this.getBounds();
            g.setColor(FOCUS_CATCHER_COLOR);
            g.drawRect(0, 0, bounds.width - 1, bounds.height - 1);
        }
    }

    private JTextComponent createTextField(Object constraint, Ref<JComponent> componentRef) {
        JTextComponent editorTextField;
        if (this.myFindModel.isMultiline()) {
            editorTextField = new JTextArea(""){

                @Override
                protected void paintBorder(Graphics g) {
                    super.paintBorder(g);
                    EditorSearchComponent.this.paintBorderOfTextField(g);
                }

                @Override
                public Dimension getPreferredSize() {
                    return super.getPreferredSize();
                }
            };
            ((JTextArea)editorTextField).setColumns(25);
            ((JTextArea)editorTextField).setRows(2);
            JBScrollPane scrollPane = new JBScrollPane((Component)editorTextField, 20, 30);
            this.myLeftComponent.add((Component)scrollPane, constraint);
            componentRef.set((Object)scrollPane);
        } else {
            SearchTextField stf = new SearchTextField(true);
            stf.setOpaque(false);
            editorTextField = stf.getTextEditor();
            if (UIUtil.isUnderGTKLookAndFeel()) {
                editorTextField.setOpaque(false);
            }
            this.myLeftComponent.add((Component)stf, constraint);
            componentRef.set((Object)stf);
        }
        editorTextField.setMinimumSize(new Dimension(200, -1));
        editorTextField.putClientProperty("AuxEditorComponent", Boolean.TRUE);
        editorTextField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                editorTextField.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                editorTextField.repaint();
            }
        });
        new CloseOnESCAction(this, editorTextField);
        return editorTextField;
    }

    public void setInitialText(String initialText) {
        String text;
        String string = text = initialText != null ? initialText : "";
        if (text.contains("\n")) {
            this.myFindModel.setMultiline(true);
        }
        this.setTextInField(text);
        this.mySearchField.selectAll();
    }

    private void requestFocus(Component c) {
        IdeFocusManager.getInstance((Project)this.myProject).requestFocus(c, true);
    }

    public void searchBackward() {
        this.moveCursor(SearchResults.Direction.UP);
        this.addTextToRecent(this.mySearchField);
    }

    public void searchForward() {
        this.moveCursor(SearchResults.Direction.DOWN);
        this.addTextToRecent(this.mySearchField);
    }

    public void addTextToRecent(JTextComponent textField) {
        String text = textField.getText();
        if (text.length() > 0) {
            if (textField == this.mySearchField) {
                FindSettings.getInstance().addStringToFind(text);
                if (this.mySearchRootComponent instanceof SearchTextField) {
                    ((SearchTextField)this.mySearchRootComponent).addCurrentTextToHistory();
                }
            } else {
                FindSettings.getInstance().addStringToReplace(text);
                if (this.myReplaceRootComponent instanceof SearchTextField) {
                    ((SearchTextField)this.myReplaceRootComponent).addCurrentTextToHistory();
                }
            }
        }
    }

    public void selectionChanged(SelectionEvent e) {
        this.updateResults(false);
    }

    private void moveCursor(SearchResults.Direction direction) {
        this.myLivePreviewController.moveCursor(direction);
    }

    private static void setSmallerFontAndOpaque(JComponent component) {
        Utils.setSmallerFont(component);
        component.setOpaque(false);
    }

    @Override
    public void requestFocus() {
        this.mySearchField.setSelectionStart(0);
        this.mySearchField.setSelectionEnd(this.mySearchField.getText().length());
        this.requestFocus(this.mySearchField);
    }

    public void close() {
        IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)this.myEditor.getContentComponent(), false);
        this.myLivePreviewController.dispose();
        this.myEditor.setHeaderComponent(null);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.initLivePreview();
    }

    private void initLivePreview() {
        this.myLivePreviewController.on();
        this.myLivePreviewController.setUserActivityDelay(0);
        this.updateResults(false);
        this.myLivePreviewController.setUserActivityDelay(30);
        this.mySearchResults.addListener(this);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.myLivePreviewController.off();
        this.mySearchResults.removeListener(this);
        this.addTextToRecent(this.mySearchField);
        if (this.myReplaceField != null) {
            this.addTextToRecent(this.myReplaceField);
        }
    }

    private void updateResults(boolean allowedToChangedEditorSelection) {
        this.myMatchInfoLabel.setFont(this.myMatchInfoLabel.getFont().deriveFont(0));
        String text = this.myFindModel.getStringToFind();
        if (text.length() == 0) {
            this.nothingToSearchFor();
        } else {
            if (this.myFindModel.isRegularExpressions()) {
                try {
                    Pattern.compile(text);
                }
                catch (Exception e) {
                    this.setNotFoundBackground();
                    this.myMatchInfoLabel.setText("Incorrect regular expression");
                    this.boldMatchInfo();
                    this.myClickToHighlightLabel.setVisible(false);
                    this.mySearchResults.clear();
                    return;
                }
            }
            FindManager findManager = FindManager.getInstance((Project)this.myProject);
            if (allowedToChangedEditorSelection) {
                findManager.setFindWasPerformed();
                FindModel copy = new FindModel();
                copy.copyFrom(this.myFindModel);
                copy.setReplaceState(false);
                findManager.setFindNextModel(copy);
            }
            if (this.myLivePreviewController != null) {
                this.myLivePreviewController.updateInBackground(this.myFindModel, allowedToChangedEditorSelection);
            }
        }
    }

    private void nothingToSearchFor() {
        this.updateUIWithEmptyResults();
        if (this.mySearchResults != null) {
            this.mySearchResults.clear();
        }
    }

    private void updateUIWithEmptyResults() {
        this.setRegularBackground();
        this.myMatchInfoLabel.setText("");
        this.myClickToHighlightLabel.setVisible(false);
    }

    private void boldMatchInfo() {
        Font font = this.myMatchInfoLabel.getFont();
        if (!font.isBold()) {
            this.myMatchInfoLabel.setFont(font.deriveFont(1));
        }
    }

    private void setRegularBackground() {
        this.mySearchField.setBackground(this.myDefaultBackground);
    }

    private void setNotFoundBackground() {
        this.mySearchField.setBackground(LightColors.RED);
    }

    public String getTextInField() {
        return this.mySearchField.getText();
    }

    public void setTextInField(String text) {
        this.mySearchField.setText(text);
        this.myFindModel.setStringToFind(text);
    }

    public boolean hasMatches() {
        return this.mySearchResults != null && this.mySearchResults.hasMatches();
    }

    @Override
    public Insets getInsets() {
        Insets insets = super.getInsets();
        if (UIUtil.isUnderGTKLookAndFeel() || UIUtil.isUnderNimbusLookAndFeel()) {
            ++insets.top;
            insets.bottom += 2;
        }
        return insets;
    }

    public void selectAllOccurrences() {
        FindUtil.selectSearchResultsInEditor(this.myEditor, this.mySearchResults.getOccurrences().iterator(), -1);
    }

    public void removeOccurrence() {
        this.mySearchResults.prevOccurrence(true);
    }

    public void addNextOccurrence() {
        this.mySearchResults.nextOccurrence(true);
    }

    public void clearUndoInTextFields() {
        UIUtil.resetUndoRedoActions((JTextComponent)this.mySearchField);
        UIUtil.resetUndoRedoActions((JTextComponent)this.myReplaceField);
    }
}

