/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javadoc;

import com.intellij.javadoc.JavadocBundle;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.Gray;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

final class JavadocGenerationPanel
extends JPanel {
    JPanel myPanel;
    TextFieldWithBrowseButton myTfOutputDir;
    JTextField myOtherOptionsField;
    JTextField myHeapSizeField;
    private JSlider myScopeSlider;
    JCheckBox myHierarchy;
    JCheckBox myNavigator;
    JCheckBox myIndex;
    JCheckBox mySeparateIndex;
    JCheckBox myTagUse;
    JCheckBox myTagAuthor;
    JCheckBox myTagVersion;
    JCheckBox myTagDeprecated;
    JCheckBox myDeprecatedList;
    JCheckBox myOpenInBrowserCheckBox;
    JTextField myLocaleTextField;
    JCheckBox myIncludeLibraryCb;

    JavadocGenerationPanel() {
        this.$$$setupUI$$$();
        this.myTfOutputDir.addBrowseFolderListener(JavadocBundle.message("javadoc.generate.output.directory.browse", new Object[0]), null, null, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        this.myIndex.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JavadocGenerationPanel.this.mySeparateIndex.setEnabled(JavadocGenerationPanel.this.myIndex.isSelected());
            }
        });
        this.myTagDeprecated.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JavadocGenerationPanel.this.myDeprecatedList.setEnabled(JavadocGenerationPanel.this.myTagDeprecated.isSelected());
            }
        });
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(new Integer(1), new JLabel("public"));
        labelTable.put(new Integer(2), new JLabel("protected"));
        labelTable.put(new Integer(3), new JLabel("package"));
        labelTable.put(new Integer(4), new JLabel("private"));
        this.myScopeSlider.setMaximum(4);
        this.myScopeSlider.setMinimum(1);
        this.myScopeSlider.setValue(1);
        this.myScopeSlider.setLabelTable(labelTable);
        this.myScopeSlider.putClientProperty("JSlider.isFilled", Boolean.TRUE);
        this.myScopeSlider.setPreferredSize(new Dimension(80, 50));
        this.myScopeSlider.setPaintLabels(true);
        this.myScopeSlider.setSnapToTicks(true);
        this.myScopeSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JavadocGenerationPanel.this.handleSlider();
            }
        });
    }

    private void handleSlider() {
        int value = this.myScopeSlider.getValue();
        Dictionary labelTable = this.myScopeSlider.getLabelTable();
        Enumeration enumeration = labelTable.keys();
        while (enumeration.hasMoreElements()) {
            Integer key = (Integer)enumeration.nextElement();
            JLabel label = (JLabel)labelTable.get(key);
            label.setForeground(key <= value ? Color.black : Gray._100);
        }
    }

    void setScope(String scope) {
        if ("public".equals(scope)) {
            this.myScopeSlider.setValue(1);
        } else if ("protected".equals(scope)) {
            this.myScopeSlider.setValue(2);
        } else if ("private".equals(scope)) {
            this.myScopeSlider.setValue(4);
        } else {
            this.myScopeSlider.setValue(3);
        }
        this.handleSlider();
    }

    String getScope() {
        switch (this.myScopeSlider.getValue()) {
            case 1: {
                return "public";
            }
            case 2: {
                return "protected";
            }
            case 3: {
                return "package";
            }
            case 4: {
                return "private";
            }
        }
        return null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JTextField jTextField;
        JCheckBox jCheckBox2;
        JTextField jTextField2;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JSlider jSlider;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JCheckBox jCheckBox7;
        JCheckBox jCheckBox8;
        JCheckBox jCheckBox9;
        JCheckBox jCheckBox10;
        JCheckBox jCheckBox11;
        JTextField jTextField3;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(8, 2, new Insets(2, 5, 0, 5), -1, 7, false, false));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/JavadocBundle").getString("javadoc.generate.arguments"));
        jPanel.add((Component)jLabel, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myOtherOptionsField = jTextField3 = new JTextField();
        jPanel.add((Component)jTextField3, new GridConstraints(4, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, 0, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        this.myHierarchy = jCheckBox11 = new JCheckBox();
        jCheckBox11.setSelected(false);
        this.$$$loadButtonText$$$(jCheckBox11, ResourceBundle.getBundle("messages/JavadocBundle").getString("javadoc.generate.options.hierarchy"));
        jPanel3.add((Component)jCheckBox11, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myNavigator = jCheckBox10 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox10, ResourceBundle.getBundle("messages/JavadocBundle").getString("javadoc.generate.options.navigator"));
        jPanel3.add((Component)jCheckBox10, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myIndex = jCheckBox9 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox9, ResourceBundle.getBundle("messages/JavadocBundle").getString("javadoc.generate.options.index"));
        jPanel3.add((Component)jCheckBox9, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySeparateIndex = jCheckBox8 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox8, ResourceBundle.getBundle("messages/JavadocBundle").getString("javadoc.generate.options.index.per.letter"));
        jCheckBox8.setMargin(new Insets(2, 18, 2, 2));
        ((Component)jCheckBox8).setEnabled(false);
        jPanel3.add((Component)jCheckBox8, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, 0, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(0, 2, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        this.myTagDeprecated = jCheckBox7 = new JCheckBox();
        jCheckBox7.setText("@deprecated");
        jPanel4.add((Component)jCheckBox7, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myDeprecatedList = jCheckBox6 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox6, ResourceBundle.getBundle("messages/JavadocBundle").getString("javadoc.generate.tag.list.deprecated"));
        jCheckBox6.setMargin(new Insets(2, 18, 2, 2));
        jCheckBox6.setFocusPainted(true);
        ((Component)jCheckBox6).setEnabled(false);
        jPanel4.add((Component)jCheckBox6, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myTagAuthor = jCheckBox5 = new JCheckBox();
        jCheckBox5.setText("@author");
        jPanel4.add((Component)jCheckBox5, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myTagUse = jCheckBox4 = new JCheckBox();
        jCheckBox4.setText("@use");
        jPanel4.add((Component)jCheckBox4, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myTagVersion = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("@version");
        jPanel4.add((Component)jCheckBox3, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 8, 2, 0, 3, null, new Dimension(151, -1), null));
        jPanel5.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        this.myScopeSlider = jSlider = new JSlider();
        jSlider.setValueIsAdjusting(false);
        jSlider.setPaintTrack(true);
        jSlider.setSnapToTicks(false);
        jSlider.setOrientation(1);
        jSlider.setPaintLabels(true);
        jSlider.setPaintTicks(false);
        jSlider.setMaximum(0);
        ((Component)jSlider).setVisible(true);
        jPanel5.add((Component)jSlider, new GridConstraints(0, 0, 1, 1, 8, 2, 3, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/JavadocBundle").getString("javadoc.generate.output.directory"));
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTfOutputDir = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/JavadocBundle").getString("javadoc.generate.heap.size"));
        jPanel.add((Component)jLabel3, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myHeapSizeField = jTextField2 = new JTextField();
        jTextField2.setText("");
        jPanel.add((Component)jTextField2, new GridConstraints(5, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myOpenInBrowserCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setSelected(true);
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/JavadocBundle").getString("javadoc.generate.open.in.browser"));
        jCheckBox2.setMargin(new Insets(2, 0, 2, 2));
        jCheckBox2.setDoubleBuffered(false);
        jCheckBox2.setBorderPaintedFlat(false);
        jCheckBox2.setFocusCycleRoot(false);
        jPanel.add((Component)jCheckBox2, new GridConstraints(6, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(7, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("messages/JavadocBundle").getString("javadoc.generate.locale"));
        jPanel.add((Component)jLabel4, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLocaleTextField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(3, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myIncludeLibraryCb = jCheckBox = new JCheckBox();
        jCheckBox.setText("Include jdk and library sources in -sourcepath");
        jCheckBox.setMargin(new Insets(0, 8, 10, 3));
        jPanel.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        jLabel.setLabelFor(jTextField3);
        jLabel2.setLabelFor((Component)textFieldWithBrowseButton);
        jLabel3.setLabelFor(jTextField2);
        jLabel4.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

