/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.boilerplate;

import com.intellij.ide.util.projectWizard.WebProjectTemplate;
import com.intellij.lang.javascript.boilerplate.GithubDownloadUtil;
import com.intellij.lang.javascript.boilerplate.GithubProjectGeneratorPeer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.templates.github.GeneratorException;
import com.intellij.platform.templates.github.GithubTagInfo;
import com.intellij.platform.templates.github.ZipUtil;
import com.intellij.util.PlatformUtils;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractGithubTagDownloadedProjectGenerator
extends WebProjectTemplate<GithubTagInfo> {
    private static final Logger LOG = Logger.getInstance(AbstractGithubTagDownloadedProjectGenerator.class);

    @Override
    @NotNull
    @Nls
    public final String getName() {
        String string = this.getDisplayName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/boilerplate/AbstractGithubTagDownloadedProjectGenerator", "getName"));
        }
        return string;
    }

    @NotNull
    protected abstract String getDisplayName();

    @NotNull
    protected abstract String getGithubUserName();

    @NotNull
    protected abstract String getGithubRepositoryName();

    @Override
    @Nullable
    public abstract String getDescription();

    private String getTitle() {
        return this.getDisplayName();
    }

    @Override
    @Nullable
    public String getHelpId() {
        return "create.from.template." + this.getGithubUserName() + "." + this.getGithubRepositoryName();
    }

    @Override
    public void generateProject(@NotNull Project project, final @NotNull VirtualFile baseDir, @NotNull GithubTagInfo tag, @NotNull Module module) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/boilerplate/AbstractGithubTagDownloadedProjectGenerator", "generateProject"));
        }
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/intellij/lang/javascript/boilerplate/AbstractGithubTagDownloadedProjectGenerator", "generateProject"));
        }
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/lang/javascript/boilerplate/AbstractGithubTagDownloadedProjectGenerator", "generateProject"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/lang/javascript/boilerplate/AbstractGithubTagDownloadedProjectGenerator", "generateProject"));
        }
        try {
            this.unpackToDir(project, VfsUtilCore.virtualToIoFile((VirtualFile)baseDir), tag);
        }
        catch (GeneratorException e) {
            this.showErrorMessage(project, e.getMessage());
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                baseDir.refresh(true, true);
            }
        });
    }

    @NotNull
    public GithubProjectGeneratorPeer createPeer() {
        GithubProjectGeneratorPeer githubProjectGeneratorPeer = new GithubProjectGeneratorPeer(this);
        if (githubProjectGeneratorPeer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/boilerplate/AbstractGithubTagDownloadedProjectGenerator", "createPeer"));
        }
        return githubProjectGeneratorPeer;
    }

    @Override
    public boolean isPrimaryGenerator() {
        return PlatformUtils.isWebStorm();
    }

    private void unpackToDir(@Nullable Project project, @NotNull File extractToDir, @NotNull GithubTagInfo tag) throws GeneratorException {
        if (extractToDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extractToDir", "com/intellij/lang/javascript/boilerplate/AbstractGithubTagDownloadedProjectGenerator", "unpackToDir"));
        }
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/lang/javascript/boilerplate/AbstractGithubTagDownloadedProjectGenerator", "unpackToDir"));
        }
        File zipArchiveFile = this.getCacheFile(tag);
        String primaryUrl = this.getPrimaryZipArchiveUrlForDownload(tag);
        boolean downloaded = false;
        if (primaryUrl != null) {
            try {
                this.downloadAndUnzip(project, primaryUrl, zipArchiveFile, extractToDir, false);
                downloaded = true;
            }
            catch (GeneratorException e) {
                LOG.info("Can't download " + primaryUrl, (Throwable)e);
                FileUtil.delete((File)zipArchiveFile);
            }
        }
        if (!downloaded) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw new GeneratorException("Download " + tag.getZipballUrl() + " is skipped in unit test mode");
            }
            this.downloadAndUnzip(project, tag.getZipballUrl(), zipArchiveFile, extractToDir, true);
        }
    }

    private void downloadAndUnzip(@Nullable Project project, @NotNull String url, @NotNull File zipArchiveFile, @NotNull File extractToDir, boolean retryOnError) throws GeneratorException {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/lang/javascript/boilerplate/AbstractGithubTagDownloadedProjectGenerator", "downloadAndUnzip"));
        }
        if (zipArchiveFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "zipArchiveFile", "com/intellij/lang/javascript/boilerplate/AbstractGithubTagDownloadedProjectGenerator", "downloadAndUnzip"));
        }
        if (extractToDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extractToDir", "com/intellij/lang/javascript/boilerplate/AbstractGithubTagDownloadedProjectGenerator", "downloadAndUnzip"));
        }
        GithubDownloadUtil.downloadContentToFileWithProgressSynchronously(project, url, this.getTitle(), zipArchiveFile, this.getGithubUserName(), this.getGithubRepositoryName(), retryOnError);
        LOG.info("Content of " + url + " has been successfully downloaded to " + zipArchiveFile.getAbsolutePath() + ", size " + zipArchiveFile.length() + " bytes");
        ZipUtil.unzipWithProgressSynchronously(project, this.getTitle(), zipArchiveFile, extractToDir, true);
    }

    @Nullable
    public abstract String getPrimaryZipArchiveUrlForDownload(@NotNull GithubTagInfo var1);

    @NotNull
    private File getCacheFile(@NotNull GithubTagInfo tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/lang/javascript/boilerplate/AbstractGithubTagDownloadedProjectGenerator", "getCacheFile"));
        }
        String fileName = tag.getName() + ".zip";
        try {
            fileName = URLEncoder.encode(fileName, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn("Can't urlEncode", (Throwable)e);
        }
        File file = GithubDownloadUtil.findCacheFile(this.getGithubUserName(), this.getGithubRepositoryName(), fileName);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/boilerplate/AbstractGithubTagDownloadedProjectGenerator", "getCacheFile"));
        }
        return file;
    }

    private void showErrorMessage(@NotNull Project project, @NotNull String message) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/boilerplate/AbstractGithubTagDownloadedProjectGenerator", "showErrorMessage"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/lang/javascript/boilerplate/AbstractGithubTagDownloadedProjectGenerator", "showErrorMessage"));
        }
        String fullMessage = "Error creating " + this.getDisplayName() + " project. " + message;
        String title = "Create " + this.getDisplayName() + " Project";
        Messages.showErrorDialog((Project)project, (String)fullMessage, (String)title);
    }
}

