/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.util;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.ExternalSystemUiAware;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ExternalProjectPojo;
import com.intellij.openapi.externalSystem.service.task.ui.ExternalSystemTasksTreeModel;
import com.intellij.openapi.externalSystem.service.ui.DefaultExternalSystemUiAware;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemLocalSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ExternalSystemUiUtil {
    public static final int INSETS = 7;
    private static final int BALLOON_FADEOUT_TIME = 5000;

    private ExternalSystemUiUtil() {
    }

    public static void showBalloon(@NotNull JComponent component, @NotNull MessageType messageType, @NotNull String message) {
        Balloon.Position position;
        int x;
        int y;
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/externalSystem/util/ExternalSystemUiUtil", "showBalloon"));
        }
        if (messageType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageType", "com/intellij/openapi/externalSystem/util/ExternalSystemUiUtil", "showBalloon"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/openapi/externalSystem/util/ExternalSystemUiUtil", "showBalloon"));
        }
        BalloonBuilder builder = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message, messageType, null).setDisposable((Disposable)ApplicationManager.getApplication()).setFadeoutTime(5000L);
        Balloon balloon = builder.createBalloon();
        Dimension size = component.getSize();
        if (size == null) {
            y = 0;
            x = 0;
            position = Balloon.Position.above;
        } else {
            x = Math.min(10, size.width / 2);
            y = size.height;
            position = Balloon.Position.below;
        }
        balloon.show(new RelativePoint((Component)component, new Point(x, y)), position);
    }

    @NotNull
    public static GridBag getLabelConstraints(int indentLevel) {
        Insets insets = new Insets(7, 7 + 7 * indentLevel, 0, 7);
        GridBag gridBag = new GridBag().anchor(17).weightx(0.0).insets(insets);
        if (gridBag == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/util/ExternalSystemUiUtil", "getLabelConstraints"));
        }
        return gridBag;
    }

    @NotNull
    public static GridBag getFillLineConstraints(int indentLevel) {
        Insets insets = new Insets(7, 7 + 7 * indentLevel, 0, 7);
        GridBag gridBag = new GridBag().weightx(1.0).coverLine().fillCellHorizontally().anchor(17).insets(insets);
        if (gridBag == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/util/ExternalSystemUiUtil", "getFillLineConstraints"));
        }
        return gridBag;
    }

    public static void fillBottom(@NotNull JComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/externalSystem/util/ExternalSystemUiUtil", "fillBottom"));
        }
        component.add(Box.createVerticalGlue(), new GridBag().weightx(1.0).weighty(1.0).fillCell().coverLine());
    }

    public static void apply(final @NotNull AbstractExternalSystemLocalSettings settings, final @NotNull ExternalSystemTasksTreeModel model) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/openapi/externalSystem/util/ExternalSystemUiUtil", "apply"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/openapi/externalSystem/util/ExternalSystemUiUtil", "apply"));
        }
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                Map projects = settings.getAvailableProjects();
                for (Map.Entry entry : projects.entrySet()) {
                    model.ensureSubProjectsStructure((ExternalProjectPojo)entry.getKey(), (Collection)entry.getValue());
                }
                Map tasks = settings.getAvailableTasks();
                for (Map.Entry entry : tasks.entrySet()) {
                    model.ensureTasks((String)entry.getKey(), (Collection)entry.getValue());
                }
            }
        });
    }

    public static void showUi(@NotNull Object o, boolean show) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/openapi/externalSystem/util/ExternalSystemUiUtil", "showUi"));
        }
        for (Class<?> clazz = o.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                field.setAccessible(true);
                try {
                    Object v = field.get(o);
                    if (!(v instanceof JComponent)) continue;
                    ((JComponent)v).setVisible(show);
                }
                catch (IllegalAccessException e) {
                    // empty catch block
                }
            }
        }
    }

    public static void disposeUi(@NotNull Object o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/openapi/externalSystem/util/ExternalSystemUiUtil", "disposeUi"));
        }
        for (Class<?> clazz = o.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                field.setAccessible(true);
                try {
                    Object v = field.get(o);
                    if (!(v instanceof JComponent)) continue;
                    field.set(o, null);
                }
                catch (IllegalAccessException e) {
                    // empty catch block
                }
            }
        }
    }

    @NotNull
    public static ExternalSystemUiAware getUiAware(@NotNull ProjectSystemId externalSystemId) {
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/util/ExternalSystemUiUtil", "getUiAware"));
        }
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)externalSystemId);
        DefaultExternalSystemUiAware defaultExternalSystemUiAware = manager instanceof ExternalSystemUiAware ? (ExternalSystemUiAware)manager : DefaultExternalSystemUiAware.INSTANCE;
        if (defaultExternalSystemUiAware == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/util/ExternalSystemUiUtil", "getUiAware"));
        }
        return defaultExternalSystemUiAware;
    }

    public static void executeAction(@NotNull String actionId, @NotNull InputEvent e) {
        if (actionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/intellij/openapi/externalSystem/util/ExternalSystemUiUtil", "executeAction"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/externalSystem/util/ExternalSystemUiUtil", "executeAction"));
        }
        ActionManager actionManager = ActionManager.getInstance();
        AnAction action = actionManager.getAction(actionId);
        if (action == null) {
            return;
        }
        Presentation presentation = new Presentation();
        DataContext context = DataManager.getInstance().getDataContext(e.getComponent());
        AnActionEvent event = new AnActionEvent(e, context, "", presentation, actionManager, 0);
        action.update(event);
        if (presentation.isEnabled()) {
            action.actionPerformed(event);
        }
    }
}

