/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.roots.ui.configuration.ErrorPaneConfigurable;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.ui.popup.ListItemDescriptor;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.GroupedElementsRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SeparatorWithText;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import com.intellij.ui.popup.list.GroupedItemsListRenderer;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;

public class SidePanel
extends JPanel {
    private final JList myList;
    private final DefaultListModel myModel;
    private final Place.Navigator myNavigator;
    private final ArrayList<Place> myPlaces = new ArrayList();
    private final Map<Integer, String> myIndex2Separator = new HashMap<Integer, String>();
    private final Map<Place, Presentation> myPlace2Presentation = new HashMap<Place, Presentation>();
    private final History myHistory;

    public SidePanel(Place.Navigator navigator, History history) {
        this.myHistory = history;
        this.myNavigator = navigator;
        this.setLayout(new BorderLayout());
        this.myModel = new DefaultListModel();
        this.myList = new JBList((ListModel)this.myModel);
        if (Registry.is((String)"ide.new.project.settings")) {
            this.myList.setBackground(UIUtil.getSidePanelColor());
            this.myList.setBorder(new EmptyBorder(5, 0, 0, 0));
        }
        final ListItemDescriptor descriptor = new ListItemDescriptor(){

            public String getTextFor(Object value) {
                return ((Presentation)SidePanel.this.myPlace2Presentation.get(value)).getText();
            }

            public String getTooltipFor(Object value) {
                return this.getTextFor(value);
            }

            public Icon getIconFor(Object value) {
                return Registry.is((String)"ide.new.project.settings") ? EmptyIcon.create((int)16, (int)20) : null;
            }

            public boolean hasSeparatorAboveOf(Object value) {
                int index = SidePanel.this.myPlaces.indexOf(value);
                return SidePanel.this.myIndex2Separator.get(index) != null;
            }

            public String getCaptionAboveOf(Object value) {
                return (String)SidePanel.this.myIndex2Separator.get(SidePanel.this.myPlaces.indexOf(value));
            }
        };
        this.myList.setCellRenderer(new GroupedItemsListRenderer(descriptor){
            JPanel myExtraPanel;
            CountLabel myCountLabel;
            {
                super(x0);
                this.mySeparatorComponent.setCaptionCentered(false);
            }

            protected Color getForeground() {
                return Registry.is((String)"ide.new.project.settings") ? new JBColor((Color)Gray._60, (Color)Gray._140) : super.getForeground();
            }

            protected SeparatorWithText createSeparator() {
                return new SeparatorWithText(){

                    protected void paintComponent(Graphics g) {
                        if (Registry.is((String)"ide.new.project.settings")) {
                            JBColor separatorColor = new JBColor(GroupedElementsRenderer.POPUP_SEPARATOR_FOREGROUND, (Color)Gray._80);
                            g.setColor((Color)separatorColor);
                            if ("--".equals(this.getCaption())) {
                                GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g);
                                int h = this.getHeight() / 2;
                                g.drawLine(30, h, this.getWidth() - 30, h);
                                ((Graphics2D)g).setPaint(new GradientPaint(5.0f, h, ColorUtil.toAlpha((Color)separatorColor, (int)0), 30.0f, h, (Color)separatorColor));
                                g.drawLine(5, h, 30, h);
                                ((Graphics2D)g).setPaint(new GradientPaint(this.getWidth() - 5, h, ColorUtil.toAlpha((Color)separatorColor, (int)0), this.getWidth() - 30, h, (Color)separatorColor));
                                g.drawLine(this.getWidth() - 5, h, this.getWidth() - 30, h);
                                config.restore();
                                return;
                            }
                            Rectangle viewR = new Rectangle(0, 1.getVgap(), this.getWidth() - 1, this.getHeight() - 1.getVgap() - 1);
                            Rectangle iconR = new Rectangle();
                            Rectangle textR = new Rectangle();
                            String s = SwingUtilities.layoutCompoundLabel(g.getFontMetrics(), this.getCaption(), null, 0, 2, 0, 2, viewR, iconR, textR, 0);
                            GraphicsUtil.setupAAPainting((Graphics)g);
                            g.setColor((Color)new JBColor(Gray._255.withAlpha(80), Gray._0.withAlpha(80)));
                            g.drawString(s, textR.x + 10, textR.y + 1 + g.getFontMetrics().getAscent());
                            g.setColor((Color)new JBColor(new Color(6253947), (Color)Gray._120));
                            g.drawString(s, textR.x + 10, textR.y + g.getFontMetrics().getAscent());
                        } else {
                            super.paintComponent(g);
                        }
                    }
                };
            }

            protected void layout() {
                if (Registry.is((String)"ide.new.project.settings")) {
                    this.myRendererComponent.add((Component)this.mySeparatorComponent, (Object)"North");
                    this.myExtraPanel.add((Component)this.myComponent, "Center");
                    this.myExtraPanel.add((Component)this.myCountLabel, "East");
                    this.myRendererComponent.add((Component)this.myExtraPanel, (Object)"Center");
                } else {
                    super.layout();
                }
            }

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                ErrorPaneConfigurable errorPane;
                this.myCountLabel.setText("");
                Component component = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if ("Problems".equals(descriptor.getTextFor(value)) && (errorPane = (ErrorPaneConfigurable)((Place)value).getPath("category")) != null && errorPane.getErrorsCount() > 0) {
                    this.myCountLabel.setSelected(isSelected);
                    this.myCountLabel.setText(String.valueOf(errorPane.getErrorsCount()));
                }
                return component;
            }

            @Override
            protected JComponent createItemComponent() {
                this.myExtraPanel = new NonOpaquePanel((LayoutManager)new BorderLayout());
                this.myCountLabel = new CountLabel();
                JComponent component = super.createItemComponent();
                if (Registry.is((String)"ide.new.project.settings")) {
                    this.myTextLabel.setForeground((Color)Gray._240);
                    this.myTextLabel.setOpaque(true);
                }
                return component;
            }

            protected Color getBackground() {
                return Registry.is((String)"ide.new.project.settings") ? UIUtil.getSidePanelColor() : super.getBackground();
            }
        });
        this.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myList, (boolean)Registry.is((String)"ide.new.project.settings")), "Center");
        this.myList.setSelectionMode(0);
        this.myList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                Object value = SidePanel.this.myList.getSelectedValue();
                if (value != null) {
                    SidePanel.this.myNavigator.navigateTo((Place)value, false);
                }
            }
        });
    }

    public JList getList() {
        return this.myList;
    }

    public void addPlace(Place place, @NotNull Presentation presentation) {
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/openapi/roots/ui/configuration/SidePanel", "addPlace"));
        }
        this.myModel.addElement(place);
        this.myPlaces.add(place);
        this.myPlace2Presentation.put(place, presentation);
        this.revalidate();
        this.repaint();
    }

    public void addSeparator(String text) {
        this.myIndex2Separator.put(this.myPlaces.size(), text);
    }

    public Collection<Place> getPlaces() {
        return this.myPlaces;
    }

    public void select(Place place) {
        this.myList.setSelectedValue(place, true);
    }

    private static class CountLabel
    extends JLabel {
        private boolean mySelected;

        public CountLabel() {
            this.setBorder(new Border(){

                @Override
                public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                }

                @Override
                public Insets getBorderInsets(Component c) {
                    return StringUtil.isEmpty((String)CountLabel.this.getText()) ? new Insets(0, 0, 0, 0) : new Insets(2, 6, 2, 12);
                }

                @Override
                public boolean isBorderOpaque() {
                    return false;
                }
            });
            this.setFont(UIUtil.getListFont().deriveFont(1));
        }

        public boolean isSelected() {
            return this.mySelected;
        }

        public void setSelected(boolean selected) {
            this.mySelected = selected;
        }

        @Override
        protected void paintComponent(Graphics g) {
            g.setColor(this.isSelected() ? UIUtil.getListSelectionBackground() : UIUtil.getSidePanelColor());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (StringUtil.isEmpty((String)this.getText())) {
                return;
            }
            JBColor deepBlue = new JBColor(new Color(9938098), new Color(92, 98, 113));
            g.setColor(this.isSelected() ? Gray._255.withAlpha(UIUtil.isUnderDarcula() ? 100 : 220) : deepBlue);
            GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g);
            g.fillRoundRect(0, 3, this.getWidth() - 6 - 1, this.getHeight() - 6, this.getHeight() - 6, this.getHeight() - 6);
            config.restore();
            this.setForeground(this.isSelected() ? deepBlue.darker() : UIUtil.getListForeground((boolean)true));
            super.paintComponent(g);
        }
    }
}

