/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.templates;

import com.intellij.ide.util.projectWizard.ProjectTemplateFileProcessor;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.impl.ComponentManagerImpl;
import com.intellij.openapi.components.impl.stores.ComponentStoreImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;

public class SystemFileProcessor
extends ProjectTemplateFileProcessor {
    private static final String[] COMPONENT_NAMES = new String[]{"FileEditorManager", "org.jetbrains.idea.maven.project.MavenWorkspaceSettingsComponent"};
    private static final Logger LOG = Logger.getInstance(SystemFileProcessor.class);

    @Override
    @Nullable
    protected String encodeFileText(String content, VirtualFile file, Project project) throws IOException {
        String fileName = file.getName();
        if (file.getParent().getName().equals(".idea") && fileName.equals("workspace.xml")) {
            ArrayList componentList = new ArrayList();
            for (String componentName : COMPONENT_NAMES) {
                Object component = project.getComponent(componentName);
                if (component == null) {
                    try {
                        component = ServiceManager.getService((Project)project, Class.forName(componentName));
                    }
                    catch (ClassNotFoundException ignore) {
                        // empty catch block
                    }
                }
                ContainerUtil.addIfNotNull(componentList, (Object)component);
            }
            if (!componentList.isEmpty()) {
                Element root = new Element("project");
                for (final Object component : componentList) {
                    final Element element = new Element("component");
                    element.setAttribute("name", ComponentManagerImpl.getComponentName(component));
                    root.addContent(element);
                    UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (component instanceof JDOMExternalizable) {
                                try {
                                    ((JDOMExternalizable)component).writeExternal(element);
                                }
                                catch (WriteExternalException ignore) {
                                    LOG.error((Throwable)ignore);
                                }
                            } else {
                                Object state = ((PersistentStateComponent)component).getState();
                                Element element1 = XmlSerializer.serialize((Object)state);
                                element.addContent((Collection)element1.cloneContent());
                                element.setAttribute("name", ComponentStoreImpl.getComponentName((PersistentStateComponent)component));
                            }
                        }
                    });
                }
                PathMacroManager.getInstance((ComponentManager)project).collapsePaths(root);
                return JDOMUtil.writeElement((Element)root);
            }
        }
        return null;
    }
}

