/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui;

import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.util.Comparing;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.profile.codeInspection.ui.InspectionToolsConfigurable;

public class IDEInspectionToolsConfigurable
extends InspectionToolsConfigurable {
    private String myCurrentSelection;

    public IDEInspectionToolsConfigurable(InspectionProjectProfileManager projectProfileManager, InspectionProfileManager profileManager) {
        super(projectProfileManager, profileManager);
    }

    @Override
    protected InspectionProfileImpl getCurrentProfile() {
        return (InspectionProfileImpl)this.myProfileManager.getRootProfile();
    }

    @Override
    public void reset() {
        super.reset();
        this.myCurrentSelection = this.getSelectedObject().getName();
    }

    @Override
    public void selectProfile(String name) {
        super.selectProfile(name);
        this.myCurrentSelection = name;
    }

    @Override
    public void apply() throws ConfigurationException {
        super.apply();
        String rootProfile = this.getSelectedObject().getName();
        this.myProfileManager.setRootProfile(rootProfile);
        this.myCurrentSelection = rootProfile;
    }

    @Override
    public boolean isModified() {
        if (!Comparing.strEqual((String)this.getSelectedObject().getName(), (String)this.myCurrentSelection)) {
            return true;
        }
        return super.isModified();
    }
}

