/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.facade;

import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.GraphColorManager;
import com.intellij.vcs.log.graph.GraphCommit;
import com.intellij.vcs.log.graph.GraphCommitImpl;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.impl.facade.CollapsedVisibleGraph;
import com.intellij.vcs.log.graph.impl.facade.ContainingBranchesGetter;
import com.intellij.vcs.log.graph.impl.facade.FilterVisibleGraph;
import com.intellij.vcs.log.graph.impl.facade.bek.BekChecker;
import com.intellij.vcs.log.graph.impl.facade.bek.BekIntMap;
import com.intellij.vcs.log.graph.impl.facade.bek.BekSorter;
import com.intellij.vcs.log.graph.impl.facade.bek.DelegatedPermanentGraphInfo;
import com.intellij.vcs.log.graph.impl.permanent.GraphLayoutBuilder;
import com.intellij.vcs.log.graph.impl.permanent.GraphLayoutImpl;
import com.intellij.vcs.log.graph.impl.permanent.PermanentCommitsInfoIml;
import com.intellij.vcs.log.graph.impl.permanent.PermanentLinearGraphBuilder;
import com.intellij.vcs.log.graph.impl.permanent.PermanentLinearGraphImpl;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PermanentGraphImpl<CommitId>
implements PermanentGraph<CommitId>,
PermanentGraphInfo<CommitId> {
    @NotNull
    private final PermanentCommitsInfoIml<CommitId> myPermanentCommitsInfo;
    @NotNull
    private final PermanentLinearGraphImpl myPermanentLinearGraph;
    @NotNull
    private final GraphLayoutImpl myPermanentGraphLayout;
    @NotNull
    private final GraphColorManager<CommitId> myGraphColorManager;
    @NotNull
    private final Set<CommitId> myBranchesCommitId;
    @NotNull
    private final Set<Integer> myBranchNodeIndexes;
    @NotNull
    private final Map<CommitId, GraphCommit<CommitId>> myCommitsWithNotLoadParent;
    @NotNull
    private final ContainingBranchesGetter myBranchesGetter;
    @NotNull
    private final PermanentGraphInfo<CommitId> myBekGraphInfo;

    @NotNull
    public static <CommitId> PermanentGraphImpl<CommitId> newInstance(@NotNull List<? extends GraphCommit<CommitId>> graphCommits, final @NotNull GraphColorManager<CommitId> graphColorManager, @NotNull Set<CommitId> branchesCommitId) {
        if (graphCommits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphCommits", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "newInstance"));
        }
        if (graphColorManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphColorManager", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "newInstance"));
        }
        if (branchesCommitId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchesCommitId", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "newInstance"));
        }
        PermanentLinearGraphBuilder permanentLinearGraphBuilder = PermanentLinearGraphBuilder.newInstance(graphCommits);
        PermanentLinearGraphImpl linearGraph = permanentLinearGraphBuilder.build();
        Map commitsWithNotLoadParent = permanentLinearGraphBuilder.getCommitsWithNotLoadParent();
        final PermanentCommitsInfoIml commitIdPermanentCommitsInfo = PermanentCommitsInfoIml.newInstance(graphCommits);
        GraphLayoutImpl permanentGraphLayout = GraphLayoutBuilder.build(linearGraph, new Comparator<Integer>(){

            @Override
            public int compare(@NotNull Integer nodeIndex1, @NotNull Integer nodeIndex2) {
                if (nodeIndex1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeIndex1", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl$1", "compare"));
                }
                if (nodeIndex2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeIndex2", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl$1", "compare"));
                }
                Object commitId1 = commitIdPermanentCommitsInfo.getCommitId(nodeIndex1);
                Object commitId2 = commitIdPermanentCommitsInfo.getCommitId(nodeIndex2);
                return graphColorManager.compareHeads(commitId2, commitId1);
            }
        });
        PermanentGraphImpl permanentGraphImpl = new PermanentGraphImpl(linearGraph, permanentGraphLayout, commitIdPermanentCommitsInfo, graphColorManager, branchesCommitId, commitsWithNotLoadParent);
        if (permanentGraphImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "newInstance"));
        }
        return permanentGraphImpl;
    }

    public PermanentGraphImpl(@NotNull PermanentLinearGraphImpl permanentLinearGraph, @NotNull GraphLayoutImpl permanentGraphLayout, @NotNull PermanentCommitsInfoIml<CommitId> permanentCommitsInfo, @NotNull GraphColorManager<CommitId> graphColorManager, @NotNull Set<CommitId> branchesCommitId, @NotNull Map<CommitId, GraphCommit<CommitId>> commitsWithNotLoadParent) {
        if (permanentLinearGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "permanentLinearGraph", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "<init>"));
        }
        if (permanentGraphLayout == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "permanentGraphLayout", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "<init>"));
        }
        if (permanentCommitsInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "permanentCommitsInfo", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "<init>"));
        }
        if (graphColorManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphColorManager", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "<init>"));
        }
        if (branchesCommitId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchesCommitId", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "<init>"));
        }
        if (commitsWithNotLoadParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitsWithNotLoadParent", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "<init>"));
        }
        this.myPermanentGraphLayout = permanentGraphLayout;
        this.myPermanentCommitsInfo = permanentCommitsInfo;
        this.myPermanentLinearGraph = permanentLinearGraph;
        this.myGraphColorManager = graphColorManager;
        this.myBranchesCommitId = branchesCommitId;
        this.myCommitsWithNotLoadParent = commitsWithNotLoadParent;
        this.myBranchNodeIndexes = permanentCommitsInfo.convertToCommitIndexes(branchesCommitId);
        this.myBranchesGetter = new ContainingBranchesGetter(permanentLinearGraph, this.myBranchNodeIndexes);
        this.myBekGraphInfo = this.createBekSort();
    }

    @NotNull
    public VisibleGraph<CommitId> createVisibleGraph(@NotNull PermanentGraph.SortType sortType, @Nullable Set<CommitId> headsOfVisibleBranches, @Nullable Condition<CommitId> filter) {
        if (sortType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sortType", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "createVisibleGraph"));
        }
        if (filter == null) {
            CollapsedVisibleGraph<CommitId> collapsedVisibleGraph = CollapsedVisibleGraph.newInstance(this.getBekPermanentGraphInfo(sortType), headsOfVisibleBranches);
            if (collapsedVisibleGraph == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "createVisibleGraph"));
            }
            return collapsedVisibleGraph;
        }
        FilterVisibleGraph<CommitId> filterVisibleGraph = FilterVisibleGraph.newInstance(this.getBekPermanentGraphInfo(sortType), headsOfVisibleBranches, filter);
        if (filterVisibleGraph == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "createVisibleGraph"));
        }
        return filterVisibleGraph;
    }

    @NotNull
    private PermanentGraphInfo<CommitId> getBekPermanentGraphInfo(@NotNull PermanentGraph.SortType sortType) {
        if (sortType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sortType", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "getBekPermanentGraphInfo"));
        }
        if (sortType == PermanentGraph.SortType.Normal) {
            PermanentGraphImpl permanentGraphImpl = this;
            if (permanentGraphImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "getBekPermanentGraphInfo"));
            }
            return permanentGraphImpl;
        }
        PermanentGraphInfo<CommitId> permanentGraphInfo = this.myBekGraphInfo;
        if (permanentGraphInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "getBekPermanentGraphInfo"));
        }
        return permanentGraphInfo;
    }

    @NotNull
    private PermanentGraphInfo<CommitId> createBekSort() {
        if (!BekSorter.isBekEnabled()) {
            PermanentGraphImpl permanentGraphImpl = this;
            if (permanentGraphImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "createBekSort"));
            }
            return permanentGraphImpl;
        }
        BekIntMap bekMap = BekSorter.createBekMap(this.myPermanentLinearGraph, this.myPermanentGraphLayout, this.myPermanentCommitsInfo.getTimestampGetter());
        DelegatedPermanentGraphInfo graphInfo = new DelegatedPermanentGraphInfo(this, bekMap);
        assert (BekChecker.checkLinearGraph(graphInfo.getPermanentLinearGraph()));
        DelegatedPermanentGraphInfo delegatedPermanentGraphInfo = graphInfo;
        if (delegatedPermanentGraphInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "createBekSort"));
        }
        return delegatedPermanentGraphInfo;
    }

    @NotNull
    public List<GraphCommit<CommitId>> getAllCommits() {
        ArrayList result = ContainerUtil.newArrayList();
        for (int index = 0; index < this.myPermanentLinearGraph.nodesCount(); ++index) {
            CommitId commitId = this.myPermanentCommitsInfo.getCommitId(index);
            GraphCommit<CommitId> graphCommit = this.myCommitsWithNotLoadParent.get(commitId);
            if (graphCommit == null) {
                List<CommitId> parentsCommitIds = this.myPermanentCommitsInfo.convertToCommitIdList(this.myPermanentLinearGraph.getDownNodes(index));
                graphCommit = new GraphCommitImpl<CommitId>(commitId, parentsCommitIds, this.myPermanentCommitsInfo.getTimestamp(index));
            }
            result.add(graphCommit);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "getAllCommits"));
        }
        return arrayList;
    }

    @NotNull
    public List<CommitId> getChildren(@NotNull CommitId commit) {
        if (commit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commit", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "getChildren"));
        }
        int commitIndex = this.myPermanentCommitsInfo.getPermanentNodeIndex(commit);
        List<CommitId> list = this.myPermanentCommitsInfo.convertToCommitIdList(this.myPermanentLinearGraph.getUpNodes(commitIndex));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "getChildren"));
        }
        return list;
    }

    @NotNull
    public Set<CommitId> getContainingBranches(@NotNull CommitId commit) {
        if (commit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commit", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "getContainingBranches"));
        }
        int commitIndex = this.myPermanentCommitsInfo.getPermanentNodeIndex(commit);
        Set<CommitId> set = this.myPermanentCommitsInfo.convertToCommitIdSet(this.myBranchesGetter.getBranchNodeIndexes(commitIndex));
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "getContainingBranches"));
        }
        return set;
    }

    @Override
    @NotNull
    public PermanentCommitsInfoIml<CommitId> getPermanentCommitsInfo() {
        PermanentCommitsInfoIml<CommitId> permanentCommitsInfoIml = this.myPermanentCommitsInfo;
        if (permanentCommitsInfoIml == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "getPermanentCommitsInfo"));
        }
        return permanentCommitsInfoIml;
    }

    @Override
    @NotNull
    public LinearGraph getPermanentLinearGraph() {
        PermanentLinearGraphImpl permanentLinearGraphImpl = this.myPermanentLinearGraph;
        if (permanentLinearGraphImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "getPermanentLinearGraph"));
        }
        return permanentLinearGraphImpl;
    }

    @Override
    @NotNull
    public GraphLayoutImpl getPermanentGraphLayout() {
        GraphLayoutImpl graphLayoutImpl = this.myPermanentGraphLayout;
        if (graphLayoutImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "getPermanentGraphLayout"));
        }
        return graphLayoutImpl;
    }

    @Override
    @NotNull
    public GraphColorManager<CommitId> getGraphColorManager() {
        GraphColorManager<CommitId> graphColorManager = this.myGraphColorManager;
        if (graphColorManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "getGraphColorManager"));
        }
        return graphColorManager;
    }

    @NotNull
    public Set<CommitId> getBranchesCommitId() {
        Set<CommitId> set = this.myBranchesCommitId;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "getBranchesCommitId"));
        }
        return set;
    }

    @NotNull
    public Set<Integer> getBranchNodeIndexes() {
        Set<Integer> set = this.myBranchNodeIndexes;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "getBranchNodeIndexes"));
        }
        return set;
    }

    @Override
    @NotNull
    public Condition<Integer> getNotCollapsedNodes() {
        Condition<Integer> condition = new Condition<Integer>(){

            public boolean value(Integer integer) {
                return PermanentGraphImpl.this.myBranchNodeIndexes.contains(integer);
            }
        };
        if (condition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "getNotCollapsedNodes"));
        }
        return condition;
    }

    @Override
    @NotNull
    public Map<CommitId, GraphCommit<CommitId>> getCommitsWithNotLoadParent() {
        Map<CommitId, GraphCommit<CommitId>> map = this.myCommitsWithNotLoadParent;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "getCommitsWithNotLoadParent"));
        }
        return map;
    }
}

