/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.print;

import com.intellij.util.SmartList;
import com.intellij.util.containers.SLRUMap;
import com.intellij.vcs.log.graph.api.LinearGraphWithElementInfo;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class EdgesInRowGenerator {
    private static final int CACHE_SIZE = 10;
    private static final int BLOCK_SIZE = 40;
    private final int WALK_SIZE;
    @NotNull
    private final LinearGraphWithElementInfo myGraph;
    @NotNull
    private final SLRUMap<Integer, GraphEdges> cacheNU;
    private final SLRUMap<Integer, GraphEdges> cacheND;

    public EdgesInRowGenerator(@NotNull LinearGraphWithElementInfo graph) {
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/intellij/vcs/log/graph/impl/print/EdgesInRowGenerator", "<init>"));
        }
        this(graph, 1000);
    }

    public EdgesInRowGenerator(@NotNull LinearGraphWithElementInfo graph, int walk_size) {
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/intellij/vcs/log/graph/impl/print/EdgesInRowGenerator", "<init>"));
        }
        this.cacheNU = new SLRUMap(10, 20);
        this.cacheND = new SLRUMap(10, 20);
        this.myGraph = graph;
        this.WALK_SIZE = walk_size;
    }

    @NotNull
    public Set<GraphEdge> getEdgesInRow(int rowIndex) {
        GraphEdges neighborU = this.getNeighborU(rowIndex);
        while (neighborU.myRow < rowIndex) {
            neighborU = this.oneDownStep(neighborU);
        }
        GraphEdges neighborD = this.getNeighborD(rowIndex);
        while (neighborD.myRow > rowIndex) {
            neighborD = this.oneUpStep(neighborD);
        }
        Set result = neighborU.myEdges;
        result.addAll(neighborD.myEdges);
        Set set = result;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/print/EdgesInRowGenerator", "getEdgesInRow"));
        }
        return set;
    }

    public void invalidate() {
        this.cacheNU.clear();
        this.cacheND.clear();
    }

    @NotNull
    private GraphEdges getNeighborU(int rowIndex) {
        int upNeighborIndex = EdgesInRowGenerator.getUpNeighborIndex(rowIndex);
        GraphEdges graphEdges = (GraphEdges)this.cacheNU.get((Object)upNeighborIndex);
        if (graphEdges == null) {
            graphEdges = this.getUCorrectEdges(upNeighborIndex);
            this.cacheNU.put((Object)upNeighborIndex, (Object)graphEdges);
        }
        GraphEdges graphEdges2 = graphEdges.newInstance();
        if (graphEdges2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/print/EdgesInRowGenerator", "getNeighborU"));
        }
        return graphEdges2;
    }

    @NotNull
    private GraphEdges getNeighborD(int rowIndex) {
        int downNeighborIndex = EdgesInRowGenerator.getUpNeighborIndex(rowIndex) + 40;
        if (downNeighborIndex >= this.myGraph.nodesCount()) {
            GraphEdges graphEdges = new GraphEdges(this.myGraph.nodesCount() - 1);
            if (graphEdges == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/print/EdgesInRowGenerator", "getNeighborD"));
            }
            return graphEdges;
        }
        GraphEdges graphEdges = (GraphEdges)this.cacheND.get((Object)downNeighborIndex);
        if (graphEdges == null) {
            graphEdges = this.getDCorrectEdges(downNeighborIndex);
            this.cacheND.put((Object)downNeighborIndex, (Object)graphEdges);
        }
        GraphEdges graphEdges2 = graphEdges.newInstance();
        if (graphEdges2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/print/EdgesInRowGenerator", "getNeighborD"));
        }
        return graphEdges2;
    }

    private static int getUpNeighborIndex(int rowIndex) {
        return rowIndex / 40 * 40;
    }

    @NotNull
    private GraphEdges getUCorrectEdges(int rowIndex) {
        int startCalculateIndex = Math.max(rowIndex - this.WALK_SIZE, 0);
        GraphEdges graphEdges = new GraphEdges(startCalculateIndex);
        for (int i = startCalculateIndex; i < rowIndex; ++i) {
            graphEdges = this.oneDownStep(graphEdges);
        }
        GraphEdges graphEdges2 = graphEdges;
        if (graphEdges2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/print/EdgesInRowGenerator", "getUCorrectEdges"));
        }
        return graphEdges2;
    }

    @NotNull
    private GraphEdges getDCorrectEdges(int rowIndex) {
        int endCalculateIndex = Math.min(rowIndex + this.WALK_SIZE, this.myGraph.nodesCount() - 1);
        GraphEdges graphEdges = new GraphEdges(endCalculateIndex);
        for (int i = endCalculateIndex; i > rowIndex; --i) {
            graphEdges = this.oneUpStep(graphEdges);
        }
        GraphEdges graphEdges2 = graphEdges;
        if (graphEdges2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/print/EdgesInRowGenerator", "getDCorrectEdges"));
        }
        return graphEdges2;
    }

    @NotNull
    private GraphEdges oneDownStep(@NotNull GraphEdges graphEdges) {
        if (graphEdges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphEdges", "com/intellij/vcs/log/graph/impl/print/EdgesInRowGenerator", "oneDownStep"));
        }
        Set edgesInCurrentRow = graphEdges.myEdges;
        int currentRow = graphEdges.myRow;
        edgesInCurrentRow.addAll(this.createDownEdges(currentRow));
        edgesInCurrentRow.removeAll(this.createUpEdges(currentRow + 1));
        GraphEdges graphEdges2 = new GraphEdges(edgesInCurrentRow, currentRow + 1);
        if (graphEdges2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/print/EdgesInRowGenerator", "oneDownStep"));
        }
        return graphEdges2;
    }

    @NotNull
    private GraphEdges oneUpStep(@NotNull GraphEdges graphEdges) {
        if (graphEdges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphEdges", "com/intellij/vcs/log/graph/impl/print/EdgesInRowGenerator", "oneUpStep"));
        }
        Set edgesInCurrentRow = graphEdges.myEdges;
        int currentRow = graphEdges.myRow;
        edgesInCurrentRow.addAll(this.createUpEdges(currentRow));
        edgesInCurrentRow.removeAll(this.createDownEdges(currentRow - 1));
        GraphEdges graphEdges2 = new GraphEdges(edgesInCurrentRow, currentRow - 1);
        if (graphEdges2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/print/EdgesInRowGenerator", "oneUpStep"));
        }
        return graphEdges2;
    }

    public List<GraphEdge> createUpEdges(int nodeIndex) {
        SmartList result = new SmartList();
        for (int upNode : this.myGraph.getUpNodes(nodeIndex)) {
            GraphEdge.Type type = this.myGraph.getEdgeType(upNode, nodeIndex);
            result.add(new GraphEdge(upNode, nodeIndex, type));
        }
        return result;
    }

    public List<GraphEdge> createDownEdges(int nodeIndex) {
        SmartList result = new SmartList();
        for (int downNode : this.myGraph.getDownNodes(nodeIndex)) {
            GraphEdge.Type type = this.myGraph.getEdgeType(nodeIndex, downNode);
            result.add(new GraphEdge(nodeIndex, downNode, type));
        }
        return result;
    }

    private static class GraphEdges {
        @NotNull
        private final Set<GraphEdge> myEdges;
        private final int myRow;

        private GraphEdges(int row) {
            this(new HashSet<GraphEdge>(), row);
        }

        private GraphEdges(@NotNull Set<GraphEdge> edges, int row) {
            if (edges == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "edges", "com/intellij/vcs/log/graph/impl/print/EdgesInRowGenerator$GraphEdges", "<init>"));
            }
            this.myEdges = edges;
            this.myRow = row;
        }

        @NotNull
        GraphEdges newInstance() {
            GraphEdges graphEdges = new GraphEdges(new HashSet<GraphEdge>(this.myEdges), this.myRow);
            if (graphEdges == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/print/EdgesInRowGenerator$GraphEdges", "newInstance"));
            }
            return graphEdges;
        }
    }
}

