/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.dsl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import gnu.trove.THashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="DslActivationStatus", storages={@Storage(file="$APP_CONFIG$/dslActivation.xml")})
public class DslActivationStatus
implements ApplicationComponent,
PersistentStateComponent<Element> {
    private final Map<VirtualFile, String> myStatus = new THashMap();
    private static final String ENABLED = "enabled";

    public static DslActivationStatus getInstance() {
        return (DslActivationStatus)ApplicationManager.getApplication().getComponent(DslActivationStatus.class);
    }

    public void activateUntilModification(@NotNull VirtualFile vfile) {
        if (vfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vfile", "org/jetbrains/plugins/groovy/dsl/DslActivationStatus", "activateUntilModification"));
        }
        this.myStatus.put(vfile, ENABLED);
    }

    public void disableFile(@NotNull VirtualFile vfile, @NotNull String error) {
        if (vfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vfile", "org/jetbrains/plugins/groovy/dsl/DslActivationStatus", "disableFile"));
        }
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "org/jetbrains/plugins/groovy/dsl/DslActivationStatus", "disableFile"));
        }
        this.myStatus.put(vfile, error);
    }

    @Nullable
    public String getInactivityReason(VirtualFile file) {
        String status = this.myStatus.get(file);
        return status == null || status == ENABLED ? null : status;
    }

    public boolean isActivated(VirtualFile file) {
        return this.myStatus.get(file) == ENABLED;
    }

    @NotNull
    public String getComponentName() {
        if ("DslActivationStatus" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/dsl/DslActivationStatus", "getComponentName"));
        }
        return "DslActivationStatus";
    }

    @Nullable
    public Element getState() {
        Element root = new Element("x");
        for (Map.Entry<VirtualFile, String> entry : this.myStatus.entrySet()) {
            VirtualFile file = entry.getKey();
            String status = entry.getValue();
            Element element = new Element("file");
            root.addContent(element);
            element.setAttribute("url", file.getUrl());
            element.setAttribute("status", status == ENABLED ? "" : status);
        }
        return root;
    }

    public void loadState(Element state) {
        List children = state.getChildren("file");
        for (Element element : children) {
            String url = element.getAttributeValue("url", "");
            String status = element.getAttributeValue("status", ENABLED);
            VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(url);
            if (file == null) continue;
            this.myStatus.put(file, status);
        }
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }
}

