/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.path;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NullableFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrThrowStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBuiltinTypeClassExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrImmediateTupleType;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrExpressionImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class GrIndexPropertyImpl
extends GrExpressionImpl
implements GrIndexProperty {
    private static final Function<GrIndexPropertyImpl, PsiType> TYPE_CALCULATOR = new NullableFunction<GrIndexPropertyImpl, PsiType>(){

        public PsiType fun(GrIndexPropertyImpl index) {
            return index.inferType(null);
        }
    };
    private static final ResolveCache.PolyVariantResolver<MyReference> RESOLVER = new ResolveCache.PolyVariantResolver<MyReference>(){

        @NotNull
        public GroovyResolveResult[] resolve(@NotNull MyReference reference, boolean incompleteCode) {
            if (reference == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/path/GrIndexPropertyImpl$2", "resolve"));
            }
            GrIndexPropertyImpl index = reference.getElement();
            GroovyResolveResult[] groovyResolveResultArray = index.resolveImpl(incompleteCode, null, null);
            if (groovyResolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/path/GrIndexPropertyImpl$2", "resolve"));
            }
            return groovyResolveResultArray;
        }
    };
    private final MyReference myReference;

    private PsiType inferType(@Nullable Boolean isSetter) {
        String name;
        GrArgumentList argList;
        PsiType[] argTypes;
        GrExpression selected = this.getInvokedExpression();
        PsiType thisType = selected.getType();
        if (thisType == null) {
            thisType = TypesUtil.getJavaLangObject(this);
        }
        if ((argTypes = PsiUtil.getArgumentTypes(argList = this.getArgumentList())) == null) {
            return null;
        }
        PsiManagerEx manager = this.getManager();
        GlobalSearchScope resolveScope = this.getResolveScope();
        if (argTypes.length == 0) {
            String qname;
            PsiElement resolved;
            PsiPrimitiveType arrType = null;
            if (selected instanceof GrBuiltinTypeClassExpression) {
                arrType = ((GrBuiltinTypeClassExpression)selected).getPrimitiveType();
            }
            if (selected instanceof GrReferenceExpression && (resolved = ((GrReferenceExpression)selected).resolve()) instanceof PsiClass && (qname = ((PsiClass)resolved).getQualifiedName()) != null) {
                arrType = TypesUtil.createTypeByFQClassName(qname, this);
            }
            if (arrType != null) {
                PsiArrayType param = arrType.createArrayType();
                return TypesUtil.createJavaLangClassType((PsiType)param, this.getProject(), resolveScope);
            }
        }
        if (PsiImplUtil.isSimpleArrayAccess(thisType, argTypes, this, isSetter != null ? isSetter : PsiUtil.isLValue(this))) {
            return TypesUtil.boxPrimitiveType(((PsiArrayType)thisType).getComponentType(), (PsiManager)manager, resolveScope);
        }
        GroovyResolveResult[] candidates = isSetter != null ? (isSetter != false ? this.multiResolveSetter(false) : this.multiResolveGetter(false)) : this.multiResolve(false);
        Object[] args = PsiUtil.getArgumentTypes(argList.getNamedArguments(), argList.getExpressionArguments(), GrClosableBlock.EMPTY_ARRAY, true, null, false);
        GroovyResolveResult candidate = PsiImplUtil.extractUniqueResult(candidates);
        PsiElement element = candidate.getElement();
        if (element instanceof PsiNamedElement && "putAt".equals(name = ((PsiNamedElement)element).getName()) && args != null) {
            args = (PsiType[])ArrayUtil.append((Object[])args, (Object)TypeInferenceHelper.getInitializerTypeFor(this), PsiType.class);
        }
        PsiType overloadedOperatorType = ResolveUtil.extractReturnTypeFromCandidate(candidate, this, (PsiType[])args);
        PsiType componentType = GrIndexPropertyImpl.extractMapValueType(thisType, (PsiType[])args, (PsiManager)manager, resolveScope);
        if (!(overloadedOperatorType == null || componentType != null && TypesUtil.isAssignableByMethodCallConversion(overloadedOperatorType, componentType, selected))) {
            return TypesUtil.boxPrimitiveType(overloadedOperatorType, (PsiManager)manager, resolveScope);
        }
        return componentType;
    }

    @Nullable
    private static PsiType extractMapValueType(PsiType thisType, PsiType[] argTypes, PsiManager manager, GlobalSearchScope resolveScope) {
        if (argTypes.length != 1 || !InheritanceUtil.isInheritor((PsiType)thisType, (String)"java.util.Map")) {
            return null;
        }
        PsiType substituted = com.intellij.psi.util.PsiUtil.substituteTypeParameter((PsiType)thisType, (String)"java.util.Map", (int)1, (boolean)true);
        return TypesUtil.boxPrimitiveType(substituted, manager, resolveScope);
    }

    private GroovyResolveResult[] resolveImpl(boolean incompleteCode, @Nullable GrExpression upToArgument, @Nullable Boolean isSetter) {
        String name;
        GrArgumentList argList;
        Object[] argTypes;
        GrExpression invoked;
        PsiType thisType;
        if (isSetter == null) {
            isSetter = PsiUtil.isLValue(this);
        }
        if ((thisType = (invoked = this.getInvokedExpression()).getType()) == null) {
            thisType = TypesUtil.getJavaLangObject(this);
        }
        if ((argTypes = PsiUtil.getArgumentTypes((argList = this.getArgumentList()).getNamedArguments(), argList.getExpressionArguments(), GrClosableBlock.EMPTY_ARRAY, true, upToArgument, false)) == null) {
            return GroovyResolveResult.EMPTY_ARRAY;
        }
        GlobalSearchScope resolveScope = this.getResolveScope();
        if (argTypes.length == 0) {
            String qname;
            PsiElement resolved;
            PsiPrimitiveType arrType = null;
            if (invoked instanceof GrBuiltinTypeClassExpression) {
                arrType = ((GrBuiltinTypeClassExpression)invoked).getPrimitiveType();
            }
            if (invoked instanceof GrReferenceExpression && (resolved = ((GrReferenceExpression)invoked).resolve()) instanceof PsiClass && (qname = ((PsiClass)resolved).getQualifiedName()) != null) {
                arrType = TypesUtil.createTypeByFQClassName(qname, this);
            }
            if (arrType != null) {
                return GroovyResolveResult.EMPTY_ARRAY;
            }
        }
        String string = name = isSetter != false ? "putAt" : "getAt";
        if (isSetter.booleanValue() && !incompleteCode) {
            argTypes = (PsiType[])ArrayUtil.append((Object[])argTypes, (Object)TypeInferenceHelper.getInitializerTypeFor(this), PsiType.class);
        }
        if (PsiImplUtil.isSimpleArrayAccess(thisType, (PsiType[])argTypes, this, isSetter)) {
            return GroovyResolveResult.EMPTY_ARRAY;
        }
        Object[] candidates = ResolveUtil.getMethodCandidates(thisType, name, (PsiElement)invoked, true, incompleteCode, false, (PsiType[])argTypes);
        if (candidates.length == 2) {
            for (int i = 0; i < candidates.length; ++i) {
                PsiMethod staticMethod;
                PsiParameter param;
                GroovyResolveResult candidate = candidates[i];
                PsiElement element = candidate.getElement();
                if (!(element instanceof GrGdkMethod) || !(param = (staticMethod = ((GrGdkMethod)element).getStaticMethod()).getParameterList().getParameters()[0]).getType().equalsToText("java.lang.Object")) continue;
                return new GroovyResolveResult[]{candidates[1 - i]};
            }
        }
        if (candidates.length != 1) {
            GrImmediateTupleType tupleType = new GrImmediateTupleType((PsiType[])argTypes, JavaPsiFacade.getInstance((Project)this.getProject()), resolveScope);
            Object[] tupleCandidates = ResolveUtil.getMethodCandidates(thisType, name, (PsiElement)invoked, new PsiType[]{tupleType});
            candidates = incompleteCode ? (GroovyResolveResult[])ArrayUtil.mergeArrays((Object[])candidates, (Object[])tupleCandidates, (ArrayFactory)new ArrayFactory<GroovyResolveResult>(){

                @NotNull
                public GroovyResolveResult[] create(int count) {
                    GroovyResolveResult[] groovyResolveResultArray = new GroovyResolveResult[count];
                    if (groovyResolveResultArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/path/GrIndexPropertyImpl$3", "create"));
                    }
                    return groovyResolveResultArray;
                }
            }) : tupleCandidates;
        }
        return candidates;
    }

    public GrIndexPropertyImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/path/GrIndexPropertyImpl", "<init>"));
        }
        super(node);
        this.myReference = new MyReference();
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitIndexProperty(this);
    }

    public String toString() {
        return "Property by index";
    }

    @Override
    @NotNull
    public GrExpression getInvokedExpression() {
        GrExpression grExpression = (GrExpression)this.findNotNullChildByClass(GrExpression.class);
        if (grExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/path/GrIndexPropertyImpl", "getInvokedExpression"));
        }
        return grExpression;
    }

    @Override
    @NotNull
    public GrArgumentList getArgumentList() {
        GrArgumentList grArgumentList = (GrArgumentList)this.findNotNullChildByClass(GrArgumentList.class);
        if (grArgumentList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/path/GrIndexPropertyImpl", "getArgumentList"));
        }
        return grArgumentList;
    }

    @Override
    @Nullable
    public PsiType getGetterType() {
        return this.inferType(false);
    }

    @Override
    @Nullable
    public PsiType getSetterType() {
        return this.inferType(true);
    }

    @Override
    @NotNull
    public GroovyResolveResult[] multiResolveGetter(boolean incomplete) {
        GroovyResolveResult[] groovyResolveResultArray = this.resolveImpl(incomplete, null, false);
        if (groovyResolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/path/GrIndexPropertyImpl", "multiResolveGetter"));
        }
        return groovyResolveResultArray;
    }

    @Override
    @NotNull
    public GroovyResolveResult[] multiResolveSetter(boolean incomplete) {
        GroovyResolveResult[] groovyResolveResultArray = this.resolveImpl(incomplete, null, false);
        if (groovyResolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/path/GrIndexPropertyImpl", "multiResolveSetter"));
        }
        return groovyResolveResultArray;
    }

    @Override
    @NotNull
    public GroovyResolveResult[] multiResolve(boolean incompleteCode) {
        GroovyResolveResult[] groovyResolveResultArray = TypeInferenceHelper.getCurrentContext().multiResolve(this.myReference, incompleteCode, RESOLVER);
        if (groovyResolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/path/GrIndexPropertyImpl", "multiResolve"));
        }
        return groovyResolveResultArray;
    }

    @Override
    public PsiType getType() {
        return TypeInferenceHelper.getCurrentContext().getExpressionType(this, TYPE_CALCULATOR);
    }

    @Override
    public PsiType getNominalType() {
        if (this.getParent() instanceof GrThrowStatement) {
            return super.getNominalType();
        }
        GroovyResolveResult[] candidates = this.multiResolve(true);
        if (candidates.length == 1) {
            return this.extractLastParameterType(candidates[0]);
        }
        return null;
    }

    @Nullable
    private PsiType extractLastParameterType(GroovyResolveResult candidate) {
        PsiParameter[] parameters;
        PsiElement element = candidate.getElement();
        if (element instanceof PsiMethod && (parameters = ((PsiMethod)element).getParameterList().getParameters()).length > 1) {
            PsiParameter last = parameters[parameters.length - 1];
            return TypesUtil.substituteBoxAndNormalizeType(last.getType(), candidate.getSubstitutor(), candidate.getSpreadState(), this);
        }
        return null;
    }

    @Override
    @NotNull
    public GrNamedArgument[] getNamedArguments() {
        GrArgumentList list = this.getArgumentList();
        GrNamedArgument[] grNamedArgumentArray = list.getNamedArguments();
        if (grNamedArgumentArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/path/GrIndexPropertyImpl", "getNamedArguments"));
        }
        return grNamedArgumentArray;
    }

    @Override
    @NotNull
    public GrExpression[] getExpressionArguments() {
        GrArgumentList list = this.getArgumentList();
        GrExpression[] grExpressionArray = list.getExpressionArguments();
        if (grExpressionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/path/GrIndexPropertyImpl", "getExpressionArguments"));
        }
        return grExpressionArray;
    }

    @Override
    public GrNamedArgument addNamedArgument(GrNamedArgument namedArgument) throws IncorrectOperationException {
        GrArgumentList list = this.getArgumentList();
        return list.addNamedArgument(namedArgument);
    }

    @Override
    @NotNull
    public GroovyResolveResult[] getCallVariants(@Nullable GrExpression upToArgument) {
        if (upToArgument == null) {
            GroovyResolveResult[] groovyResolveResultArray = this.multiResolve(true);
            if (groovyResolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/path/GrIndexPropertyImpl", "getCallVariants"));
            }
            return groovyResolveResultArray;
        }
        GroovyResolveResult[] groovyResolveResultArray = this.resolveImpl(true, upToArgument, null);
        if (groovyResolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/path/GrIndexPropertyImpl", "getCallVariants"));
        }
        return groovyResolveResultArray;
    }

    @Override
    @NotNull
    public GrClosableBlock[] getClosureArguments() {
        if (GrClosableBlock.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/path/GrIndexPropertyImpl", "getClosureArguments"));
        }
        return GrClosableBlock.EMPTY_ARRAY;
    }

    @Override
    public PsiMethod resolveMethod() {
        return PsiImplUtil.extractUniqueElement(this.multiResolve(false));
    }

    @Override
    @NotNull
    public GroovyResolveResult advancedResolve() {
        GroovyResolveResult[] results = this.multiResolve(false);
        GroovyResolveResult groovyResolveResult = results.length == 1 ? results[0] : GroovyResolveResult.EMPTY_RESULT;
        if (groovyResolveResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/path/GrIndexPropertyImpl", "advancedResolve"));
        }
        return groovyResolveResult;
    }

    public PsiReference getReference() {
        return this.myReference;
    }

    private class MyReference
    implements PsiPolyVariantReference {
        private MyReference() {
        }

        public GrIndexPropertyImpl getElement() {
            return GrIndexPropertyImpl.this;
        }

        public TextRange getRangeInElement() {
            int offset = GrIndexPropertyImpl.this.getArgumentList().getStartOffsetInParent();
            return new TextRange(offset, offset + 1);
        }

        public PsiElement resolve() {
            return GrIndexPropertyImpl.this.resolveMethod();
        }

        @NotNull
        public String getCanonicalText() {
            if ("Array-style access" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/path/GrIndexPropertyImpl$MyReference", "getCanonicalText"));
            }
            return "Array-style access";
        }

        public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
            return GrIndexPropertyImpl.this;
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/path/GrIndexPropertyImpl$MyReference", "bindToElement"));
            }
            return GrIndexPropertyImpl.this;
        }

        public boolean isReferenceTo(PsiElement element) {
            return GrIndexPropertyImpl.this.getManager().areElementsEquivalent(this.resolve(), element);
        }

        @NotNull
        public Object[] getVariants() {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/path/GrIndexPropertyImpl$MyReference", "getVariants"));
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }

        public boolean isSoft() {
            return false;
        }

        @NotNull
        public ResolveResult[] multiResolve(boolean incompleteCode) {
            ResolveResult[] resolveResultArray = GrIndexPropertyImpl.this.multiResolve(incompleteCode);
            if (resolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/path/GrIndexPropertyImpl$MyReference", "multiResolve"));
            }
            return resolveResultArray;
        }
    }
}

