/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.util.ReflectionUtil;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import org.jetbrains.idea.maven.server.Maven3ServerGlobals;

public class MavenLeakDetector {
    private IdentityHashMap<Thread, Thread> markedHooks = new IdentityHashMap();

    public MavenLeakDetector mark() {
        this.markShutdownHooks();
        return this;
    }

    private void markShutdownHooks() {
        this.markedHooks.putAll(this.getShutdownHooks());
    }

    public void check() throws RemoteException {
        this.checkShutdownHooks();
    }

    private void checkShutdownHooks() throws RemoteException {
        IdentityHashMap<Thread, Thread> checkedHooks = new IdentityHashMap<Thread, Thread>(this.getShutdownHooks());
        for (Thread t : this.markedHooks.values()) {
            checkedHooks.remove(t);
        }
        for (Thread t : checkedHooks.values()) {
            this.removeHook(t);
        }
    }

    private void removeHook(Thread thread) throws RemoteException {
        Runtime.getRuntime().removeShutdownHook(thread);
        Maven3ServerGlobals.getLogger().print(String.format("ShutdownHook[%s] was removed to avoid memory leak", thread));
    }

    private Map<Thread, Thread> getShutdownHooks() {
        Class<?> clazz;
        try {
            clazz = Class.forName("java.lang.ApplicationShutdownHooks");
        }
        catch (ClassNotFoundException e) {
            return Collections.emptyMap();
        }
        return (Map)ReflectionUtil.getField(clazz, null, Map.class, (String)"hooks");
    }
}

