/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.code.cfg;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.java.decompiler.code.Instruction;
import org.jetbrains.java.decompiler.code.InstructionSequence;
import org.jetbrains.java.decompiler.code.SimpleInstructionSequence;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.modules.decompiler.decompose.IGraphNode;

public class BasicBlock
implements IGraphNode {
    public int id = 0;
    public int mark = 0;
    private InstructionSequence seq = new SimpleInstructionSequence();
    private List<BasicBlock> preds = new ArrayList<BasicBlock>();
    private List<BasicBlock> succs = new ArrayList<BasicBlock>();
    private List<Integer> instrOldOffsets = new ArrayList<Integer>();
    private List<BasicBlock> predExceptions = new ArrayList<BasicBlock>();
    private List<BasicBlock> succExceptions = new ArrayList<BasicBlock>();

    public BasicBlock() {
    }

    public BasicBlock(int id) {
        this.id = id;
    }

    public Object clone() {
        BasicBlock block = new BasicBlock();
        block.id = this.id;
        block.setSeq(this.seq.clone());
        block.setInstrOldOffsets(new ArrayList<Integer>(this.instrOldOffsets));
        return block;
    }

    public void free() {
        this.preds.clear();
        this.succs.clear();
        this.instrOldOffsets.clear();
        this.succExceptions.clear();
        this.seq = new SimpleInstructionSequence();
    }

    public Instruction getInstruction(int index) {
        return this.seq.getInstr(index);
    }

    public Instruction getLastInstruction() {
        if (this.seq.isEmpty()) {
            return null;
        }
        return this.seq.getLastInstr();
    }

    public Integer getOldOffset(int index) {
        if (index < this.instrOldOffsets.size()) {
            return this.instrOldOffsets.get(index);
        }
        return -1;
    }

    public int size() {
        return this.seq.length();
    }

    public void addPredecessor(BasicBlock block) {
        this.preds.add(block);
    }

    public void removePredecessor(BasicBlock block) {
        while (this.preds.remove(block)) {
        }
    }

    public void addSuccessor(BasicBlock block) {
        this.succs.add(block);
        block.addPredecessor(this);
    }

    public void removeSuccessor(BasicBlock block) {
        while (this.succs.remove(block)) {
        }
        block.removePredecessor(this);
    }

    public void replaceSuccessor(BasicBlock oldBlock, BasicBlock newBlock) {
        int i;
        for (i = 0; i < this.succs.size(); ++i) {
            if (this.succs.get((int)i).id != oldBlock.id) continue;
            this.succs.set(i, newBlock);
            oldBlock.removePredecessor(this);
            newBlock.addPredecessor(this);
        }
        for (i = 0; i < this.succExceptions.size(); ++i) {
            if (this.succExceptions.get((int)i).id != oldBlock.id) continue;
            this.succExceptions.set(i, newBlock);
            oldBlock.removePredecessorException(this);
            newBlock.addPredecessorException(this);
        }
    }

    public void addPredecessorException(BasicBlock block) {
        this.predExceptions.add(block);
    }

    public void removePredecessorException(BasicBlock block) {
        while (this.predExceptions.remove(block)) {
        }
    }

    public void addSuccessorException(BasicBlock block) {
        if (!this.succExceptions.contains(block)) {
            this.succExceptions.add(block);
            block.addPredecessorException(this);
        }
    }

    public void removeSuccessorException(BasicBlock block) {
        while (this.succExceptions.remove(block)) {
        }
        block.removePredecessorException(this);
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int indent) {
        String new_line_separator = DecompilerContext.getNewLineSeparator();
        return this.id + ":" + new_line_separator + this.seq.toString(indent);
    }

    public String toStringOldIndices() {
        String new_line_separator = DecompilerContext.getNewLineSeparator();
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.seq.length(); ++i) {
            if (i < this.instrOldOffsets.size()) {
                buf.append(this.instrOldOffsets.get(i));
            } else {
                buf.append("-1");
            }
            buf.append(": ");
            buf.append(this.seq.getInstr(i).toString());
            buf.append(new_line_separator);
        }
        return buf.toString();
    }

    public boolean isSuccessor(BasicBlock block) {
        for (BasicBlock succ : this.succs) {
            if (succ.id != block.id) continue;
            return true;
        }
        return false;
    }

    public boolean isPredecessor(BasicBlock block) {
        for (int i = 0; i < this.preds.size(); ++i) {
            if (this.preds.get((int)i).id != block.id) continue;
            return true;
        }
        return false;
    }

    public List<Integer> getInstrOldOffsets() {
        return this.instrOldOffsets;
    }

    public void setInstrOldOffsets(List<Integer> instrInds) {
        this.instrOldOffsets = instrInds;
    }

    @Override
    public List<? extends IGraphNode> getPredecessors() {
        ArrayList<BasicBlock> lst = new ArrayList<BasicBlock>(this.preds);
        lst.addAll(this.predExceptions);
        return lst;
    }

    public List<BasicBlock> getPreds() {
        return this.preds;
    }

    public void setPreds(List<BasicBlock> preds) {
        this.preds = preds;
    }

    public InstructionSequence getSeq() {
        return this.seq;
    }

    public void setSeq(InstructionSequence seq) {
        this.seq = seq;
    }

    public List<BasicBlock> getSuccs() {
        return this.succs;
    }

    public void setSuccs(List<BasicBlock> succs) {
        this.succs = succs;
    }

    public List<BasicBlock> getSuccExceptions() {
        return this.succExceptions;
    }

    public void setSuccExceptions(List<BasicBlock> succExceptions) {
        this.succExceptions = succExceptions;
    }

    public List<BasicBlock> getPredExceptions() {
        return this.predExceptions;
    }

    public void setPredExceptions(List<BasicBlock> predExceptions) {
        this.predExceptions = predExceptions;
    }
}

