/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.exps;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.java.decompiler.main.collectors.BytecodeMappingTracer;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ConstExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.vars.CheckTypesResult;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.util.InterpreterUtil;

public class SwitchExprent
extends Exprent {
    private Exprent value;
    private List<List<ConstExprent>> caseValues = new ArrayList<List<ConstExprent>>();

    public SwitchExprent(Exprent value) {
        this.type = 11;
        this.value = value;
    }

    @Override
    public Exprent copy() {
        SwitchExprent swexpr = new SwitchExprent(this.value.copy());
        ArrayList<List<ConstExprent>> lstCaseValues = new ArrayList<List<ConstExprent>>();
        for (List<ConstExprent> lst : this.caseValues) {
            lstCaseValues.add(new ArrayList<ConstExprent>(lst));
        }
        swexpr.setCaseValues(lstCaseValues);
        return swexpr;
    }

    @Override
    public VarType getExprType() {
        return this.value.getExprType();
    }

    @Override
    public CheckTypesResult checkExprTypeBounds() {
        CheckTypesResult result = new CheckTypesResult();
        result.addMinTypeExprent(this.value, VarType.VARTYPE_BYTECHAR);
        result.addMaxTypeExprent(this.value, VarType.VARTYPE_INT);
        VarType valtype = this.value.getExprType();
        for (List<ConstExprent> lst : this.caseValues) {
            for (ConstExprent expr : lst) {
                VarType casetype;
                if (expr == null || (casetype = expr.getExprType()).equals(valtype)) continue;
                valtype = VarType.getCommonSupertype(casetype, valtype);
                result.addMinTypeExprent(this.value, valtype);
            }
        }
        return result;
    }

    @Override
    public List<Exprent> getAllExprents() {
        ArrayList<Exprent> lst = new ArrayList<Exprent>();
        lst.add(this.value);
        return lst;
    }

    @Override
    public String toJava(int indent, BytecodeMappingTracer tracer) {
        tracer.addMapping(this.bytecode);
        return "switch(" + this.value.toJava(indent, tracer) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof SwitchExprent)) {
            return false;
        }
        SwitchExprent sw = (SwitchExprent)o;
        return InterpreterUtil.equalObjects(this.value, sw.getValue());
    }

    @Override
    public void replaceExprent(Exprent oldexpr, Exprent newexpr) {
        if (oldexpr == this.value) {
            this.value = newexpr;
        }
    }

    public Exprent getValue() {
        return this.value;
    }

    public void setCaseValues(List<List<ConstExprent>> caseValues) {
        this.caseValues = caseValues;
    }
}

