/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.stats;

import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.collectors.BytecodeMappingTracer;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.util.InterpreterUtil;

public class GeneralStatement
extends Statement {
    private GeneralStatement() {
        this.type = 0;
    }

    public GeneralStatement(Statement head, Collection<Statement> statements, Statement post) {
        this();
        this.first = head;
        this.stats.addWithKey(head, head.id);
        HashSet<Statement> set = new HashSet<Statement>(statements);
        set.remove(head);
        for (Statement st : set) {
            this.stats.addWithKey(st, st.id);
        }
        this.post = post;
    }

    @Override
    public String toJava(int indent, BytecodeMappingTracer tracer) {
        String indstr = InterpreterUtil.getIndentString(indent);
        StringBuilder buf = new StringBuilder();
        String new_line_separator = DecompilerContext.getNewLineSeparator();
        if (this.isLabeled()) {
            buf.append(indstr).append("label").append(this.id).append(":").append(new_line_separator);
        }
        buf.append(indstr).append("abstract statement {").append(new_line_separator);
        for (int i = 0; i < this.stats.size(); ++i) {
            buf.append(((Statement)this.stats.get(i)).toJava(indent + 1, tracer));
        }
        buf.append(indstr).append("}");
        return buf.toString();
    }
}

