/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import java.util.Map;
import java.util.Set;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.model.MavenProfileKind;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.ProjectBundle;
import org.jetbrains.idea.maven.utils.MavenDataKeys;
import org.jetbrains.idea.maven.utils.actions.MavenAction;
import org.jetbrains.idea.maven.utils.actions.MavenActionUtil;

public class ToggleProfileAction
extends MavenAction {
    @Override
    public void update(AnActionEvent e) {
        String text;
        super.update(e);
        if (!this.isAvailable(e)) {
            return;
        }
        MavenProfileKind targetState = ToggleProfileAction.getTargetState(e);
        switch (targetState) {
            case NONE: {
                text = ProjectBundle.message("maven.profile.deactivate", new Object[0]);
                break;
            }
            case EXPLICIT: {
                text = ProjectBundle.message("maven.profile.activate", new Object[0]);
                break;
            }
            default: {
                text = ProjectBundle.message("maven.profile.default", new Object[0]);
            }
        }
        e.getPresentation().setText(text);
    }

    @Override
    protected boolean isAvailable(AnActionEvent e) {
        if (!super.isAvailable(e)) {
            return false;
        }
        return ToggleProfileAction.getTargetState(e) != null;
    }

    private static MavenProfileKind getTargetState(AnActionEvent e) {
        Map selectedProfiles = (Map)e.getData(MavenDataKeys.MAVEN_PROFILES);
        if (selectedProfiles == null || selectedProfiles.isEmpty()) {
            return null;
        }
        MavenProjectsManager projectsManager = MavenActionUtil.getProjectsManager(e.getDataContext());
        return ToggleProfileAction.getTargetState(projectsManager, selectedProfiles);
    }

    private static MavenProfileKind getTargetState(MavenProjectsManager projectsManager, Map<String, MavenProfileKind> profiles) {
        MavenExplicitProfiles explicitProfiles = projectsManager.getExplicitProfiles();
        MavenProfileKind targetState = null;
        for (Map.Entry<String, MavenProfileKind> profile : profiles.entrySet()) {
            MavenProfileKind profileTargetState = ToggleProfileAction.getTargetState(profile, explicitProfiles);
            if (targetState == null) {
                targetState = profileTargetState;
                continue;
            }
            if (targetState.equals((Object)profileTargetState)) continue;
            targetState = null;
            break;
        }
        return targetState;
    }

    private static MavenProfileKind getTargetState(Map.Entry<String, MavenProfileKind> profile, MavenExplicitProfiles explicitProfiles) {
        MavenProfileKind targetState = explicitProfiles.getDisabledProfiles().contains(profile.getKey()) ? MavenProfileKind.EXPLICIT : (explicitProfiles.getEnabledProfiles().contains(profile.getKey()) ? MavenProfileKind.IMPLICIT : (MavenProfileKind.NONE.equals((Object)profile.getValue()) ? MavenProfileKind.EXPLICIT : MavenProfileKind.NONE));
        return targetState;
    }

    public void actionPerformed(AnActionEvent e) {
        MavenProjectsManager manager = MavenActionUtil.getProjectsManager(e.getDataContext());
        Map selectedProfiles = (Map)e.getData(MavenDataKeys.MAVEN_PROFILES);
        Set selectedProfileIds = selectedProfiles.keySet();
        MavenProfileKind targetState = ToggleProfileAction.getTargetState(manager, selectedProfiles);
        MavenExplicitProfiles newExplicitProfiles = manager.getExplicitProfiles().clone();
        switch (targetState) {
            case NONE: {
                newExplicitProfiles.getEnabledProfiles().removeAll(selectedProfileIds);
                newExplicitProfiles.getDisabledProfiles().addAll(selectedProfileIds);
                break;
            }
            case EXPLICIT: {
                newExplicitProfiles.getDisabledProfiles().removeAll(selectedProfileIds);
                newExplicitProfiles.getEnabledProfiles().addAll(selectedProfileIds);
                break;
            }
            default: {
                newExplicitProfiles.getEnabledProfiles().removeAll(selectedProfileIds);
                newExplicitProfiles.getDisabledProfiles().removeAll(selectedProfileIds);
            }
        }
        manager.setExplicitProfiles(newExplicitProfiles);
    }
}

