/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.history.Label;
import com.intellij.ide.BrowserUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vcs.update.ActionInfo;
import com.intellij.openapi.vcs.update.UpdateInfoTree;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import git4idea.branch.GitBranchUtil;
import git4idea.push.GitPushRepoResult;
import git4idea.push.GitPushResult;
import git4idea.push.GroupedPushResult;
import git4idea.repo.GitRepository;
import git4idea.update.GitUpdateResult;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitPushResultNotification
extends Notification {
    public static final String VIEW_FILES_UPDATED_DURING_THE_PUSH = "<a href='UpdatedFiles'>View files updated during the push</a>";
    public static final String UPDATE_WITH_RESOLVED_CONFLICTS = "push has been cancelled, because there were conflicts during update.<br/>Check that conflicts were resolved correctly, and invoke push again.";
    public static final String INCOMPLETE_UPDATE = "push has been cancelled, because not all conflicts were resolved during update.<br/>Resolve the conflicts and invoke push again.";
    public static final String UPDATE_WITH_ERRORS = "push was rejected, and update failed with error";
    private static final Logger LOG = Logger.getInstance(GitPushResultNotification.class);

    public GitPushResultNotification(@NotNull String groupDisplayId, @NotNull String title, @NotNull String content, @NotNull NotificationType type, @Nullable NotificationListener listener) {
        if (groupDisplayId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupDisplayId", "git4idea/push/GitPushResultNotification", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "git4idea/push/GitPushResultNotification", "<init>"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "git4idea/push/GitPushResultNotification", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "git4idea/push/GitPushResultNotification", "<init>"));
        }
        super(groupDisplayId, title, content, type, listener);
    }

    @NotNull
    static GitPushResultNotification create(@NotNull Project project, @NotNull GitPushResult pushResult, boolean multiRepoProject) {
        NotificationType type;
        String title;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/push/GitPushResultNotification", "create"));
        }
        if (pushResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pushResult", "git4idea/push/GitPushResultNotification", "create"));
        }
        GroupedPushResult grouped = GroupedPushResult.group(pushResult.getResults());
        if (!grouped.errors.isEmpty()) {
            title = !grouped.successful.isEmpty() ? "Push partially failed" : "Push failed";
            type = NotificationType.ERROR;
        } else if (!grouped.rejected.isEmpty()) {
            title = !grouped.successful.isEmpty() ? "Push partially rejected" : "Push rejected";
            type = NotificationType.WARNING;
        } else {
            title = "Push successful";
            type = NotificationType.INFORMATION;
        }
        String description = GitPushResultNotification.formDescription(pushResult.getResults(), multiRepoProject);
        ViewUpdatedFilesNotificationListener listener = null;
        UpdatedFiles updatedFiles = pushResult.getUpdatedFiles();
        if (!updatedFiles.isEmpty()) {
            description = description + "<br/><a href='UpdatedFiles'>View files updated during the push</a>";
            listener = new ViewUpdatedFilesNotificationListener(project, updatedFiles, pushResult.getBeforeUpdateLabel(), pushResult.getAfterUpdateLabel());
        }
        NotificationGroup group = type == NotificationType.INFORMATION ? VcsNotifier.NOTIFICATION_GROUP_ID : VcsNotifier.IMPORTANT_ERROR_NOTIFICATION;
        GitPushResultNotification gitPushResultNotification = new GitPushResultNotification(group.getDisplayId(), title, description, type, listener);
        if (gitPushResultNotification == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushResultNotification", "create"));
        }
        return gitPushResultNotification;
    }

    private static String formDescription(@NotNull Map<GitRepository, GitPushRepoResult> results, final boolean multiRepoProject) {
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "git4idea/push/GitPushResultNotification", "formDescription"));
        }
        List entries = ContainerUtil.sorted(results.entrySet(), (Comparator)new Comparator<Map.Entry<GitRepository, GitPushRepoResult>>(){

            @Override
            public int compare(Map.Entry<GitRepository, GitPushRepoResult> o1, Map.Entry<GitRepository, GitPushRepoResult> o2) {
                int compareResultTypes = GitPushRepoResult.TYPE_COMPARATOR.compare(o1.getValue().getType(), o2.getValue().getType());
                if (compareResultTypes != 0) {
                    return compareResultTypes;
                }
                return DvcsUtil.REPOSITORY_COMPARATOR.compare(o1.getKey(), o2.getKey());
            }
        });
        return StringUtil.join((Collection)entries, (Function)new Function<Map.Entry<GitRepository, GitPushRepoResult>, String>(){

            public String fun(Map.Entry<GitRepository, GitPushRepoResult> entry) {
                GitRepository repository = entry.getKey();
                GitPushRepoResult result = entry.getValue();
                String description = GitPushResultNotification.formRepoDescription(result);
                description = !multiRepoProject ? StringUtil.capitalize((String)description) : DvcsUtil.getShortRepositoryName((Repository)repository) + ": " + description;
                return description;
            }
        }, (String)"<br/>");
    }

    private static String formRepoDescription(@NotNull GitPushRepoResult result) {
        String description;
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "git4idea/push/GitPushResultNotification", "formRepoDescription"));
        }
        String sourceBranch = GitBranchUtil.stripRefsPrefix(result.getSourceBranch());
        String targetBranch = GitBranchUtil.stripRefsPrefix(result.getTargetBranch());
        String tagDescription = GitPushResultNotification.formTagDescription(result.getPushedTags(), result.getTargetRemote());
        switch (result.getType()) {
            case SUCCESS: {
                int commitNum = result.getNumberOfPushedCommits();
                String commits = StringUtil.pluralize((String)"commit", (int)commitNum);
                description = String.format("pushed %d %s to %s", commitNum, commits, targetBranch);
                if (tagDescription == null) break;
                description = description + ", and " + tagDescription;
                break;
            }
            case NEW_BRANCH: {
                description = String.format("pushed %s to new branch %s", sourceBranch, targetBranch);
                if (tagDescription == null) break;
                description = description + ", and " + tagDescription;
                break;
            }
            case UP_TO_DATE: {
                if (tagDescription != null) {
                    description = "pushed " + tagDescription;
                    break;
                }
                description = "everything is up-to-date";
                break;
            }
            case FORCED: {
                description = String.format("force pushed %s to %s", sourceBranch, targetBranch);
                break;
            }
            case REJECTED: {
                description = GitPushResultNotification.formDescriptionBasedOnUpdateResult(result.getUpdateResult(), targetBranch);
                break;
            }
            case ERROR: {
                description = "failed with error: " + result.getError();
                break;
            }
            default: {
                LOG.error("Unexpected push result: " + result);
                description = "";
            }
        }
        return description;
    }

    @Nullable
    private static String formTagDescription(@NotNull List<String> pushedTags, @NotNull String remoteName) {
        if (pushedTags == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pushedTags", "git4idea/push/GitPushResultNotification", "formTagDescription"));
        }
        if (remoteName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteName", "git4idea/push/GitPushResultNotification", "formTagDescription"));
        }
        if (pushedTags.isEmpty()) {
            return null;
        }
        if (pushedTags.size() == 1) {
            return "tag " + GitBranchUtil.stripRefsPrefix(pushedTags.get(0)) + " to " + remoteName;
        }
        return pushedTags.size() + " tags to " + remoteName;
    }

    private static String formDescriptionBasedOnUpdateResult(GitUpdateResult updateResult, String targetBranch) {
        if (updateResult == null || updateResult == GitUpdateResult.SUCCESS || updateResult == GitUpdateResult.NOTHING_TO_UPDATE) {
            return String.format("push to %s was rejected", targetBranch);
        }
        if (updateResult == GitUpdateResult.SUCCESS_WITH_RESOLVED_CONFLICTS) {
            return UPDATE_WITH_RESOLVED_CONFLICTS;
        }
        if (updateResult == GitUpdateResult.INCOMPLETE) {
            return INCOMPLETE_UPDATE;
        }
        return UPDATE_WITH_ERRORS;
    }

    private static class ViewUpdatedFilesNotificationListener
    implements NotificationListener {
        private final Project myProject;
        private final UpdatedFiles myUpdatedFiles;
        private final Label myBeforeUpdateLabel;
        private final Label myAfterUpdateLabel;

        public ViewUpdatedFilesNotificationListener(@NotNull Project project, @NotNull UpdatedFiles updatedFiles, @Nullable Label beforeUpdate, @Nullable Label afterUpdate) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/push/GitPushResultNotification$ViewUpdatedFilesNotificationListener", "<init>"));
            }
            if (updatedFiles == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updatedFiles", "git4idea/push/GitPushResultNotification$ViewUpdatedFilesNotificationListener", "<init>"));
            }
            this.myProject = project;
            this.myUpdatedFiles = updatedFiles;
            this.myBeforeUpdateLabel = beforeUpdate;
            this.myAfterUpdateLabel = afterUpdate;
        }

        public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
            if (notification == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "git4idea/push/GitPushResultNotification$ViewUpdatedFilesNotificationListener", "hyperlinkUpdate"));
            }
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "git4idea/push/GitPushResultNotification$ViewUpdatedFilesNotificationListener", "hyperlinkUpdate"));
            }
            if (event.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                if (event.getDescription().equals("UpdatedFiles")) {
                    ProjectLevelVcsManagerEx vcsManager = ProjectLevelVcsManagerEx.getInstanceEx((Project)this.myProject);
                    UpdateInfoTree tree = vcsManager.showUpdateProjectInfo(this.myUpdatedFiles, "Update", ActionInfo.UPDATE, false);
                    tree.setBefore(this.myBeforeUpdateLabel);
                    tree.setAfter(this.myAfterUpdateLabel);
                } else {
                    BrowserUtil.browse((String)event.getDescription());
                }
            }
        }
    }
}

