/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct.attr;

import java.io.IOException;
import org.jetbrains.java.decompiler.struct.attr.StructGeneralAttribute;
import org.jetbrains.java.decompiler.struct.consts.ConstantPool;
import org.jetbrains.java.decompiler.util.DataInputFullStream;
import org.jetbrains.java.decompiler.util.InterpreterUtil;

public class StructLineNumberTableAttribute
extends StructGeneralAttribute {
    private int[] myLineInfo = InterpreterUtil.EMPTY_INT_ARRAY;

    @Override
    public void initContent(ConstantPool pool) throws IOException {
        DataInputFullStream data = this.stream();
        int len = data.readUnsignedShort() * 2;
        if (len > 0) {
            this.myLineInfo = new int[len];
            for (int i = 0; i < len; i += 2) {
                this.myLineInfo[i] = data.readUnsignedShort();
                this.myLineInfo[i + 1] = data.readUnsignedShort();
            }
        } else if (this.myLineInfo.length > 0) {
            this.myLineInfo = InterpreterUtil.EMPTY_INT_ARRAY;
        }
    }

    public int getFirstLine() {
        return this.myLineInfo.length > 0 ? this.myLineInfo[1] : -1;
    }

    public int findLineNumber(int pc) {
        for (int i = 0; i < this.myLineInfo.length; i += 2) {
            if (pc < this.myLineInfo[i]) continue;
            return this.myLineInfo[i + 1];
        }
        return -1;
    }
}

