/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct.gen;

import org.jetbrains.java.decompiler.util.InterpreterUtil;

public class VarType {
    public static final int FALSEBOOLEAN = 1;
    public static final VarType VARTYPE_UNKNOWN = new VarType(17);
    public static final VarType VARTYPE_INT = new VarType(4);
    public static final VarType VARTYPE_FLOAT = new VarType(3);
    public static final VarType VARTYPE_LONG = new VarType(5);
    public static final VarType VARTYPE_DOUBLE = new VarType(2);
    public static final VarType VARTYPE_BYTE = new VarType(0);
    public static final VarType VARTYPE_CHAR = new VarType(1);
    public static final VarType VARTYPE_SHORT = new VarType(6);
    public static final VarType VARTYPE_BOOLEAN = new VarType(7);
    public static final VarType VARTYPE_BYTECHAR = new VarType(15);
    public static final VarType VARTYPE_SHORTCHAR = new VarType(16);
    public static final VarType VARTYPE_NULL = new VarType(13, 0, null);
    public static final VarType VARTYPE_GROUP2EMPTY = new VarType(12);
    public static final VarType VARTYPE_STRING = new VarType(8, 0, "java/lang/String");
    public static final VarType VARTYPE_CLASS = new VarType(8, 0, "java/lang/Class");
    public static final VarType VARTYPE_OBJECT = new VarType(8, 0, "java/lang/Object");
    public static final VarType VARTYPE_VOID = new VarType(10);
    public int type;
    public int type_family;
    public int arraydim;
    public String value;
    public int stack_size;
    public int convinfo;

    public VarType(int type) {
        this.type = type;
        this.arraydim = 0;
        this.value = VarType.getChar(type);
        this.setStackSize(type);
        this.setFamily();
    }

    public VarType(int type, int arraydim) {
        this(type);
        this.arraydim = arraydim;
        this.setFamily();
    }

    public VarType(int type, int arraydim, String value) {
        this(type);
        this.arraydim = arraydim;
        this.value = value;
        this.setFamily();
    }

    public VarType(String strtype) {
        this(strtype, false);
    }

    public VarType(String strtype, boolean cltype) {
        this.parseTypeString(strtype, cltype);
        this.setStackSize(this.type);
        this.setFamily();
    }

    public void decArrayDim() {
        if (this.arraydim > 0) {
            --this.arraydim;
            this.setFamily();
        }
    }

    public String toString() {
        String res = "";
        for (int i = 0; i < this.arraydim; ++i) {
            res = res + "[";
        }
        res = this.type == 8 ? res + "L" + this.value + ";" : res + this.value;
        return res;
    }

    public VarType copy() {
        VarType v = new VarType(this.type, this.arraydim, this.value);
        v.convinfo = this.convinfo;
        return v;
    }

    public boolean isFalseBoolean() {
        return (this.convinfo & 1) != 0;
    }

    public boolean isSuperset(VarType val) {
        return this.equals(val) || this.isStrictSuperset(val);
    }

    public boolean isStrictSuperset(VarType val) {
        int valtype = val.type;
        if (valtype == 17 && this.type != 17) {
            return true;
        }
        if (val.arraydim > 0) {
            return this.equals(VARTYPE_OBJECT);
        }
        if (this.arraydim > 0) {
            return valtype == 13;
        }
        boolean res = false;
        switch (this.type) {
            case 4: {
                res |= valtype == 6 || valtype == 1;
            }
            case 6: {
                res |= valtype == 0;
            }
            case 1: {
                res |= valtype == 16;
            }
            case 0: 
            case 16: {
                res |= valtype == 15;
            }
            case 15: {
                res |= valtype == 7;
                break;
            }
            case 8: {
                if (valtype == 13) {
                    return true;
                }
                if (!this.equals(VARTYPE_OBJECT)) break;
                return valtype == 8 && !val.equals(VARTYPE_OBJECT);
            }
        }
        return res;
    }

    public static VarType getCommonMinType(VarType type1, VarType type2) {
        if (type1.type == 7 && type2.type == 7) {
            return type1.isFalseBoolean() ? type2 : type1;
        }
        if (type1.isSuperset(type2)) {
            return type2;
        }
        if (type2.isSuperset(type1)) {
            return type1;
        }
        if (type1.type_family == type2.type_family) {
            switch (type1.type_family) {
                case 2: {
                    if (type1.type == 1 && type2.type == 6 || type1.type == 6 && type2.type == 1) {
                        return VARTYPE_SHORTCHAR;
                    }
                    return VARTYPE_BYTECHAR;
                }
                case 6: {
                    return VARTYPE_NULL;
                }
            }
        }
        return null;
    }

    public static VarType getCommonSupertype(VarType type1, VarType type2) {
        if (type1.type == 7 && type2.type == 7) {
            return type1.isFalseBoolean() ? type1 : type2;
        }
        if (type1.isSuperset(type2)) {
            return type1;
        }
        if (type2.isSuperset(type1)) {
            return type2;
        }
        if (type1.type_family == type2.type_family) {
            switch (type1.type_family) {
                case 2: {
                    if (type1.type == 16 && type2.type == 0 || type1.type == 0 && type2.type == 16) {
                        return VARTYPE_SHORT;
                    }
                    return VARTYPE_INT;
                }
                case 6: {
                    return VARTYPE_OBJECT;
                }
            }
        }
        return null;
    }

    public static VarType getMinTypeInFamily(int family) {
        switch (family) {
            case 1: {
                return VARTYPE_BOOLEAN;
            }
            case 2: {
                return VARTYPE_BYTECHAR;
            }
            case 6: {
                return VARTYPE_NULL;
            }
            case 3: {
                return VARTYPE_FLOAT;
            }
            case 4: {
                return VARTYPE_LONG;
            }
            case 5: {
                return VARTYPE_DOUBLE;
            }
            case 0: {
                return VARTYPE_UNKNOWN;
            }
        }
        throw new RuntimeException("invalid type family!");
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof VarType)) {
            return false;
        }
        VarType vt = (VarType)o;
        return this.type == vt.type && this.arraydim == vt.arraydim && InterpreterUtil.equalObjects(this.value, vt.value);
    }

    private void parseTypeString(String strtype, boolean cltype) {
        block4: for (int i = 0; i < strtype.length(); ++i) {
            switch (strtype.charAt(i)) {
                case '[': {
                    ++this.arraydim;
                    continue block4;
                }
                case 'L': {
                    if (strtype.charAt(strtype.length() - 1) == ';') {
                        this.type = 8;
                        this.value = strtype.substring(i + 1, strtype.length() - 1);
                        return;
                    }
                }
                default: {
                    this.value = strtype.substring(i, strtype.length());
                    this.type = cltype && i == 0 || this.value.length() > 1 ? 8 : VarType.getType(this.value.charAt(0));
                    return;
                }
            }
        }
    }

    private void setStackSize(int type) {
        this.stack_size = this.arraydim > 0 ? 1 : (type == 2 || type == 5 ? 2 : (type == 10 || type == 12 ? 0 : 1));
    }

    private static int getType(char c) {
        switch (c) {
            case 'B': {
                return 0;
            }
            case 'C': {
                return 1;
            }
            case 'D': {
                return 2;
            }
            case 'F': {
                return 3;
            }
            case 'I': {
                return 4;
            }
            case 'J': {
                return 5;
            }
            case 'S': {
                return 6;
            }
            case 'Z': {
                return 7;
            }
            case 'V': {
                return 10;
            }
            case 'G': {
                return 12;
            }
            case 'N': {
                return 14;
            }
            case 'A': {
                return 9;
            }
            case 'X': {
                return 15;
            }
            case 'Y': {
                return 16;
            }
            case 'U': {
                return 17;
            }
        }
        throw new RuntimeException("Invalid type");
    }

    private static String getChar(int type) {
        switch (type) {
            case 0: {
                return "B";
            }
            case 1: {
                return "C";
            }
            case 2: {
                return "D";
            }
            case 3: {
                return "F";
            }
            case 4: {
                return "I";
            }
            case 5: {
                return "J";
            }
            case 6: {
                return "S";
            }
            case 7: {
                return "Z";
            }
            case 10: {
                return "V";
            }
            case 12: {
                return "G";
            }
            case 14: {
                return "N";
            }
            case 9: {
                return "A";
            }
            case 15: {
                return "X";
            }
            case 16: {
                return "Y";
            }
            case 17: {
                return "U";
            }
            case 8: 
            case 13: {
                return null;
            }
        }
        throw new RuntimeException("Invalid type");
    }

    public void setFamily() {
        if (this.arraydim > 0) {
            this.type_family = 6;
            return;
        }
        switch (this.type) {
            case 0: 
            case 1: 
            case 4: 
            case 6: 
            case 15: 
            case 16: {
                this.type_family = 2;
                break;
            }
            case 2: {
                this.type_family = 5;
                break;
            }
            case 3: {
                this.type_family = 3;
                break;
            }
            case 5: {
                this.type_family = 4;
                break;
            }
            case 7: {
                this.type_family = 1;
                break;
            }
            case 8: 
            case 13: {
                this.type_family = 6;
                break;
            }
            default: {
                this.type_family = 0;
            }
        }
    }
}

