/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.avdmanager.AvdSummaryAction;
import com.android.tools.idea.avdmanager.AvdUiAction;
import com.android.tools.idea.avdmanager.DeleteAvdAction;
import com.android.tools.idea.avdmanager.DuplicateAvdAction;
import com.android.tools.idea.avdmanager.EditAvdAction;
import com.android.tools.idea.avdmanager.RunAvdAction;
import com.android.tools.idea.avdmanager.ShowAvdOnDiskAction;
import com.android.tools.idea.avdmanager.WipeAvdDataAction;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.JBMenuItem;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLabel;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AvdActionPanel
extends JPanel
implements AvdUiAction.AvdInfoProvider {
    private static final Logger LOG = Logger.getInstance(AvdActionPanel.class);
    @NotNull
    private final AvdInfo myAvdInfo;
    private final AvdRefreshProvider myRefreshProvider;
    private Map<JComponent, AvdUiAction> myButtonActionMap;
    private final JBPopupMenu myOverflowMenu;
    private final JBLabel myOverflowMenuButton;
    private final Border myMargins;

    public AvdActionPanel(@NotNull AvdInfo avdInfo, int numVisibleActions, AvdRefreshProvider refreshProvider) {
        if (avdInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "avdInfo", "com/android/tools/idea/avdmanager/AvdActionPanel", "<init>"));
        }
        this.myButtonActionMap = Maps.newHashMap();
        this.myOverflowMenu = new JBPopupMenu();
        this.myOverflowMenuButton = new JBLabel(AllIcons.ToolbarDecorator.Mac.MoveDown);
        this.myMargins = IdeBorderFactory.createEmptyBorder((int)5, (int)3, (int)5, (int)3);
        this.myRefreshProvider = refreshProvider;
        this.setOpaque(true);
        this.setBorder(IdeBorderFactory.createEmptyBorder((int)10, (int)10, (int)10, (int)10));
        this.myAvdInfo = avdInfo;
        List<AvdUiAction> actions = this.getActions();
        this.setLayout(new FlowLayout(2, 3, 0));
        int visibleActionCount = 0;
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ((AvdUiAction)AvdActionPanel.this.myButtonActionMap.get(e.getSource())).actionPerformed(null);
            }
        };
        boolean errorState = false;
        if (avdInfo.getStatus() != AvdInfo.AvdStatus.OK) {
            if (AvdManagerConnection.isAvdRepairable(avdInfo.getStatus())) {
                JBLabel repairAction = new JBLabel("Repair Device", AllIcons.General.BalloonWarning, 10);
                this.myButtonActionMap.put((JComponent)repairAction, new EditAvdAction(this));
                repairAction.addMouseListener((MouseListener)mouseAdapter);
                this.add((Component)repairAction, "Repair Device");
            } else {
                this.add((Component)new JBLabel("Failed to load", AllIcons.General.BalloonError, 10));
            }
            numVisibleActions = 0;
            errorState = true;
        }
        for (AvdUiAction action : actions) {
            JBLabel actionLabel;
            if (errorState || numVisibleActions != -1 && visibleActionCount >= numVisibleActions) {
                JBMenuItem menuItem = new JBMenuItem((Action)action);
                menuItem.setText(action.getText());
                this.myOverflowMenu.add((JMenuItem)menuItem);
                actionLabel = menuItem;
            } else {
                actionLabel = new JBLabel(action.getIcon());
                this.add((Component)actionLabel);
                actionLabel.addMouseListener(mouseAdapter);
                ++visibleActionCount;
            }
            actionLabel.setToolTipText(action.getDescription());
            actionLabel.setBorder(this.myMargins);
            this.myButtonActionMap.put((JComponent)actionLabel, action);
        }
        this.myOverflowMenuButton.setBorder(this.myMargins);
        this.add((Component)this.myOverflowMenuButton);
        this.myOverflowMenuButton.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                AvdActionPanel.this.myOverflowMenu.show((Component)AvdActionPanel.this.myOverflowMenuButton, e.getX() - ((AvdActionPanel)AvdActionPanel.this).myOverflowMenu.getPreferredSize().width, e.getY());
            }
        });
    }

    @NotNull
    private List<AvdUiAction> getActions() {
        ImmutableList immutableList = ImmutableList.of((Object)new RunAvdAction(this), (Object)new EditAvdAction(this), (Object)new DuplicateAvdAction(this), (Object)new WipeAvdDataAction(this), (Object)new ShowAvdOnDiskAction(this), (Object)new AvdSummaryAction(this), (Object)new DeleteAvdAction(this));
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdActionPanel", "getActions"));
        }
        return immutableList;
    }

    @Override
    @NotNull
    public AvdInfo getAvdInfo() {
        AvdInfo avdInfo = this.myAvdInfo;
        if (avdInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdActionPanel", "getAvdInfo"));
        }
        return avdInfo;
    }

    @Override
    public void refreshAvds() {
        this.myRefreshProvider.refreshAvds();
    }

    @Override
    @Nullable
    public Project getProject() {
        return this.myRefreshProvider.getProject();
    }

    @Override
    public void notifyRun() {
        this.myRefreshProvider.notifyRun();
    }

    public void showPopup(@NotNull Component c, @NotNull MouseEvent e) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/android/tools/idea/avdmanager/AvdActionPanel", "showPopup"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/avdmanager/AvdActionPanel", "showPopup"));
        }
        this.myOverflowMenu.show(c, e.getX(), e.getY());
    }

    public static interface AvdRefreshProvider {
        public void refreshAvds();

        @Nullable
        public Project getProject();

        public void notifyRun();
    }
}

