/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome;

import com.android.sdklib.internal.repository.sources.SdkSources;
import com.android.sdklib.internal.repository.updater.SettingsController;
import com.android.sdklib.repository.descriptors.PkgType;
import com.android.sdklib.repository.remote.RemotePkgInfo;
import com.android.sdklib.repository.remote.RemoteSdk;
import com.android.tools.idea.avdmanager.LogWrapper;
import com.android.tools.idea.sdk.DefaultSdks;
import com.android.tools.idea.welcome.AndroidFirstRunPersistentData;
import com.android.tools.idea.welcome.FirstRunWizardHost;
import com.android.tools.idea.welcome.FirstRunWizardMode;
import com.android.tools.idea.welcome.InstallerData;
import com.android.utils.ILogger;
import com.android.utils.NullLogger;
import com.google.common.collect.Multimap;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.wm.WelcomeScreen;
import com.intellij.openapi.wm.WelcomeScreenProvider;
import javax.swing.JRootPane;
import org.jetbrains.android.AndroidPlugin;
import org.jetbrains.annotations.Nullable;

public final class AndroidStudioWelcomeScreenProvider
implements WelcomeScreenProvider {
    public static final String SYSTEM_PROPERTY_DISABLE_WIZARD = "disable.android.first.run";
    private static boolean ourWasShown = false;

    @Nullable
    public static FirstRunWizardMode getWizardMode() {
        AndroidFirstRunPersistentData persistentData = AndroidFirstRunPersistentData.getInstance();
        if (AndroidStudioWelcomeScreenProvider.isHandoff(persistentData)) {
            return FirstRunWizardMode.INSTALL_HANDOFF;
        }
        if (!persistentData.isSdkUpToDate()) {
            return FirstRunWizardMode.NEW_INSTALL;
        }
        if (DefaultSdks.getEligibleAndroidSdks().isEmpty()) {
            return FirstRunWizardMode.MISSING_SDK;
        }
        return null;
    }

    private static boolean isHandoff(AndroidFirstRunPersistentData persistentData) {
        return InstallerData.exists() && (!persistentData.isSdkUpToDate() || !persistentData.isSameTimestamp(InstallerData.get().getTimestamp()));
    }

    private static boolean isWizardDisabled() {
        return AndroidPlugin.isGuiTestingMode() || Boolean.getBoolean(SYSTEM_PROPERTY_DISABLE_WIZARD);
    }

    @Nullable
    public WelcomeScreen createWelcomeScreen(JRootPane rootPane) {
        Multimap remotePackages = (Multimap)ProgressManager.getInstance().runProcessWithProgressSynchronously((ThrowableComputable)new ThrowableComputable<Multimap<PkgType, RemotePkgInfo>, RuntimeException>(){

            public Multimap<PkgType, RemotePkgInfo> compute() throws RuntimeException {
                return AndroidStudioWelcomeScreenProvider.this.fetchPackages();
            }
        }, "Fetching Android SDK component information", false, null);
        FirstRunWizardMode wizardMode = AndroidStudioWelcomeScreenProvider.getWizardMode();
        assert (wizardMode != null);
        ourWasShown = true;
        return new FirstRunWizardHost(wizardMode, (Multimap<PkgType, RemotePkgInfo>)remotePackages);
    }

    private Multimap<PkgType, RemotePkgInfo> fetchPackages() {
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (progressIndicator != null) {
            progressIndicator.setIndeterminate(true);
        }
        RemoteSdk remoteSdk = new RemoteSdk(new SettingsController((ILogger)new LogWrapper(Logger.getInstance(this.getClass()))));
        SdkSources sdkSources = remoteSdk.fetchSources(86400000L, (ILogger)new NullLogger());
        return remoteSdk.fetch(sdkSources, (ILogger)new NullLogger());
    }

    public boolean isAvailable() {
        return !ourWasShown && !AndroidStudioWelcomeScreenProvider.isWizardDisabled() && AndroidStudioWelcomeScreenProvider.getWizardMode() != null;
    }
}

