/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.run.testing;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.testIntegration.TestLocationProvider;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidTestLocationProvider
implements TestLocationProvider {
    @NonNls
    public static final String PROTOCOL_ID = "android";

    @NotNull
    public List<Location> getLocation(@NotNull String protocolId, @NotNull String locationData, Project project) {
        PsiElement element;
        if (protocolId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "protocolId", "org/jetbrains/android/run/testing/AndroidTestLocationProvider", "getLocation"));
        }
        if (locationData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "locationData", "org/jetbrains/android/run/testing/AndroidTestLocationProvider", "getLocation"));
        }
        if (PROTOCOL_ID.equals(protocolId) && (element = AndroidTestLocationProvider.findElement(locationData, project)) != null) {
            List<PsiLocation> list = Collections.singletonList(new PsiLocation(project, element));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/run/testing/AndroidTestLocationProvider", "getLocation"));
            }
            return list;
        }
        List<Location> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/run/testing/AndroidTestLocationProvider", "getLocation"));
        }
        return list;
    }

    @Nullable
    private static PsiElement findElement(String link, Project project) {
        int idx = link.indexOf(":");
        if (idx <= 0) {
            return null;
        }
        String moduleName = link.substring(0, idx);
        Module module = ModuleManager.getInstance((Project)project).findModuleByName(moduleName);
        link = link.substring(idx + 1);
        GlobalSearchScope scope = module != null ? module.getModuleWithDependenciesScope() : GlobalSearchScope.allScope((Project)project);
        PsiClass aClass = JavaPsiFacade.getInstance((Project)project).findClass(link, scope);
        if (aClass != null) {
            return aClass;
        }
        if (link.contains(".") && link.endsWith("()")) {
            idx = link.lastIndexOf(46);
            String className = link.substring(0, idx);
            aClass = JavaPsiFacade.getInstance((Project)project).findClass(className, scope);
            if (aClass != null) {
                String methodName = link.substring(idx + 1, link.length() - 2);
                PsiMethod[] methods = aClass.findMethodsByName(methodName, false);
                if (methods.length == 0) {
                    return null;
                }
                if (methods.length == 1) {
                    return methods[0];
                }
                for (PsiMethod method : methods) {
                    if (method.getParameterList().getParametersCount() != 0) continue;
                    return method;
                }
                return methods[0];
            }
        }
        return null;
    }
}

