/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.WaitForProgressToShow;
import java.io.File;
import org.jetbrains.idea.svn.SvnStatusUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.actions.BasicAction;
import org.jetbrains.idea.svn.dialogs.RelocateDialog;
import org.jetbrains.idea.svn.info.Info;

public class RelocateAction
extends BasicAction {
    @Override
    protected String getActionName(AbstractVcs vcs) {
        return "Relocate working copy to a different URL";
    }

    @Override
    protected boolean isEnabled(Project project, SvnVcs vcs, VirtualFile file) {
        return SvnStatusUtil.isUnderControl(project, file);
    }

    @Override
    protected boolean needsFiles() {
        return true;
    }

    @Override
    protected void perform(final Project project, final SvnVcs activeVcs, final VirtualFile file, DataContext context) throws VcsException {
        String afterURL;
        Info info = activeVcs.getInfo(file);
        assert (info != null);
        RelocateDialog dlg = new RelocateDialog(project, info.getURL());
        dlg.show();
        if (!dlg.isOK()) {
            return;
        }
        final String beforeURL = dlg.getBeforeURL();
        if (beforeURL.equals(afterURL = dlg.getAfterURL())) {
            return;
        }
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                if (indicator != null) {
                    indicator.setIndeterminate(true);
                }
                try {
                    File path = new File(file.getPath());
                    activeVcs.getFactory(path).createRelocateClient().relocate(path, beforeURL, afterURL);
                    VcsDirtyScopeManager.getInstance((Project)project).markEverythingDirty();
                }
                catch (VcsException e) {
                    WaitForProgressToShow.runOrInvokeLaterAboveProgress((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            Messages.showErrorDialog((Project)project, (String)("Error relocating working copy: " + e.getMessage()), (String)"Relocate Working Copy");
                        }
                    }, null, (Project)project);
                }
            }
        }, "Relocating Working Copy", false, project);
    }

    @Override
    protected void batchPerform(Project project, SvnVcs activeVcs, VirtualFile[] file, DataContext context) throws VcsException {
    }

    @Override
    protected boolean isBatchAction() {
        return false;
    }
}

