/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.mergeinfo;

import com.intellij.lifecycle.PeriodicalTasksCloser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.TransparentlyFailedValue;
import com.intellij.openapi.vcs.changes.TransparentlyFailedValueI;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SoftHashMap;
import com.intellij.util.messages.Topic;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.dialogs.WCInfoWithBranches;
import org.jetbrains.idea.svn.dialogs.WCPaths;
import org.jetbrains.idea.svn.history.CopyData;
import org.jetbrains.idea.svn.history.FirstInBranch;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.mergeinfo.BranchInfo;
import org.jetbrains.idea.svn.mergeinfo.MergeinfoCached;

public class SvnMergeInfoCache {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.mergeinfo.SvnMergeInfoCache");
    private final Project myProject;
    private final Map<String, MyCurrentUrlData> myCurrentUrlMapping;
    public static Topic<SvnMergeInfoCacheListener> SVN_MERGE_INFO_CACHE = new Topic("SVN_MERGE_INFO_CACHE", SvnMergeInfoCacheListener.class);

    private SvnMergeInfoCache(Project project) {
        this.myProject = project;
        this.myCurrentUrlMapping = ContainerUtil.newHashMap();
    }

    public static SvnMergeInfoCache getInstance(Project project) {
        return (SvnMergeInfoCache)PeriodicalTasksCloser.getInstance().safeGetService(project, SvnMergeInfoCache.class);
    }

    public void clear(WCPaths info, String branchPath) {
        BranchInfo mergeChecker;
        String currentUrl = info.getRootUrl();
        MyCurrentUrlData rootMapping = this.myCurrentUrlMapping.get(currentUrl);
        if (rootMapping != null && (mergeChecker = rootMapping.getBranchInfo(branchPath)) != null) {
            mergeChecker.clear();
        }
    }

    @Nullable
    public MergeinfoCached getCachedState(WCPaths info, String branchPath) {
        BranchInfo branchInfo;
        String currentUrl = info.getRootUrl();
        MyCurrentUrlData rootMapping = this.myCurrentUrlMapping.get(currentUrl);
        if (rootMapping != null && (branchInfo = rootMapping.getBranchInfo(branchPath)) != null) {
            return branchInfo.getCached();
        }
        return null;
    }

    public MergeCheckResult getState(WCInfoWithBranches info, SvnChangeList list, WCInfoWithBranches.Branch selectedBranch) {
        return this.getState(info, list, selectedBranch, null);
    }

    public MergeCheckResult getState(WCInfoWithBranches info, SvnChangeList list, WCInfoWithBranches.Branch selectedBranch, String branchPath) {
        String currentUrl = info.getRootUrl();
        String branchUrl = selectedBranch.getUrl();
        MyCurrentUrlData rootMapping = this.myCurrentUrlMapping.get(currentUrl);
        BranchInfo mergeChecker = null;
        if (rootMapping == null) {
            rootMapping = new MyCurrentUrlData();
            this.myCurrentUrlMapping.put(currentUrl, rootMapping);
        } else {
            mergeChecker = rootMapping.getBranchInfo(branchPath);
        }
        if (mergeChecker == null) {
            mergeChecker = new BranchInfo(SvnVcs.getInstance(this.myProject), info.getRepoUrl(), branchUrl, currentUrl, info.getTrunkRoot());
            rootMapping.addBranchInfo(branchPath, mergeChecker);
        }
        return mergeChecker.checkList(list, branchPath);
    }

    public boolean isMixedRevisions(WCInfoWithBranches info, String branchPath) {
        BranchInfo branchInfo;
        String currentUrl = info.getRootUrl();
        MyCurrentUrlData rootMapping = this.myCurrentUrlMapping.get(currentUrl);
        if (rootMapping != null && (branchInfo = rootMapping.getBranchInfo(branchPath)) != null) {
            return branchInfo.isMixedRevisionsFound();
        }
        return false;
    }

    public static interface SvnMergeInfoCacheListener {
        public void copyRevisionUpdated();
    }

    private static class MyCurrentUrlData {
        private final Map<String, BranchInfo> myBranchInfo = new SoftHashMap();

        private MyCurrentUrlData() {
        }

        public BranchInfo getBranchInfo(String branchUrl) {
            return this.myBranchInfo.get(branchUrl);
        }

        public void addBranchInfo(String branchUrl, BranchInfo mergeChecker) {
            this.myBranchInfo.put(branchUrl, mergeChecker);
        }
    }

    static class CopyRevison {
        private final String myPath;
        private volatile long myRevision;

        CopyRevison(final SvnVcs vcs, String path, String repositoryRoot, String branchUrl, String trunkUrl) {
            this.myPath = path;
            this.myRevision = -1L;
            TransparentlyFailedValue<CopyData, VcsException> result = new TransparentlyFailedValue<CopyData, VcsException>(){

                public void set(CopyData copyData) {
                    if (copyData == null) {
                        return;
                    }
                    CopyRevison.this.myRevision = copyData.getCopySourceRevision();
                    if (CopyRevison.this.myRevision != -1L) {
                        ApplicationManager.getApplication().invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (vcs.getProject().isDisposed()) {
                                    return;
                                }
                                ((SvnMergeInfoCacheListener)vcs.getProject().getMessageBus().syncPublisher(SVN_MERGE_INFO_CACHE)).copyRevisionUpdated();
                            }
                        });
                    }
                }

                public void fail(VcsException e) {
                    LOG.info((Throwable)e);
                    VcsBalloonProblemNotifier.showOverChangesView((Project)vcs.getProject(), (String)e.getMessage(), (MessageType)MessageType.ERROR, (NamedRunnable[])new NamedRunnable[0]);
                }

                public void failRuntime(RuntimeException e) {
                    LOG.info((Throwable)e);
                    VcsBalloonProblemNotifier.showOverChangesView((Project)vcs.getProject(), (String)e.getMessage(), (MessageType)MessageType.ERROR, (NamedRunnable[])new NamedRunnable[0]);
                }
            };
            ApplicationManager.getApplication().executeOnPooledThread((Runnable)new FirstInBranch(vcs, repositoryRoot, branchUrl, trunkUrl, (TransparentlyFailedValueI<CopyData, VcsException>)result));
        }

        public String getPath() {
            return this.myPath;
        }

        public long getRevision() {
            return this.myRevision;
        }
    }

    public static enum MergeCheckResult {
        COMMON,
        MERGED,
        NOT_MERGED,
        NOT_EXISTS,
        NOT_EXISTS_PARTLY_MERGED;


        public static MergeCheckResult getInstance(boolean merged) {
            if (merged) {
                return MERGED;
            }
            return NOT_MERGED;
        }
    }
}

