/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.console;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.console.ConsoleHistoryController;
import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.console.LanguageConsoleViewImpl;
import com.intellij.execution.console.ProcessBackedConsoleExecuteActionHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.runners.AbstractConsoleRunnerWithHistory;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ui.configuration.ModulesAlphaComparator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.util.Consumer;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.config.GroovyFacetUtil;
import org.jetbrains.plugins.groovy.console.BuildAndRestartConsoleAction;
import org.jetbrains.plugins.groovy.console.GroovyShellRunner;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyFileImpl;

public abstract class GroovyShellActionBase
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance(GroovyShellActionBase.class);
    public static final String GROOVY_SHELL_EXECUTE = "Groovy.Shell.Execute";
    public static final Key<Boolean> GROOVY_SHELL_FILE = Key.create((String)"GROOVY_SHELL_FILE");
    private static final String GROOVY_SHELL_LAST_MODULE = "Groovy.Shell.LastModule";

    private List<Module> getGroovyCompatibleModules(Project project) {
        ArrayList<Module> result = new ArrayList<Module>();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            Sdk sdk;
            if (!this.isSuitableModule(module) || (sdk = ModuleRootManager.getInstance((Module)module).getSdk()) == null || !(sdk.getSdkType() instanceof JavaSdkType)) continue;
            result.add(module);
        }
        return result;
    }

    protected boolean isSuitableModule(Module module) {
        return GroovyFacetUtil.isSuitableModule(module);
    }

    public void update(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        boolean enabled = project != null && !this.getGroovyCompatibleModules(project).isEmpty();
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(enabled);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        assert (project != null);
        this.selectModule(project, new Consumer<Module>(){

            public void consume(Module module) {
                GroovyShellActionBase.this.doRunShell(module);
            }
        });
    }

    private void selectModule(Project project, final Consumer<Module> callback) {
        int defaultOption;
        ArrayList<Module> modules = new ArrayList<Module>();
        final HashMap<Module, String> versions = new HashMap<Module, String>();
        for (Module module : this.getGroovyCompatibleModules(project)) {
            GroovyShellRunner runner = this.getRunner(module);
            if (runner == null) continue;
            modules.add(module);
            versions.put(module, runner.getTitle(module));
        }
        if (modules.size() == 1) {
            callback.consume(modules.get(0));
            return;
        }
        Collections.sort(modules, ModulesAlphaComparator.INSTANCE);
        BaseListPopupStep<Module> step = new BaseListPopupStep<Module>("Which module to use classpath of?", modules, PlatformIcons.CONTENT_ROOT_ICON_CLOSED){

            @NotNull
            public String getTextFor(Module value) {
                String string = value.getName() + (String)versions.get(value);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/console/GroovyShellActionBase$2", "getTextFor"));
                }
                return string;
            }

            public String getIndexedString(Module value) {
                return value.getName();
            }

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            public PopupStep onChosen(Module selectedValue, boolean finalChoice) {
                PropertiesComponent.getInstance((Project)selectedValue.getProject()).setValue(GroovyShellActionBase.GROOVY_SHELL_LAST_MODULE, selectedValue.getName());
                callback.consume((Object)selectedValue);
                return null;
            }
        };
        final String lastModuleName = PropertiesComponent.getInstance((Project)project).getValue(GROOVY_SHELL_LAST_MODULE);
        if (lastModuleName != null && (defaultOption = ContainerUtil.indexOf(modules, (Condition)new Condition<Module>(){

            public boolean value(Module module) {
                return module.getName().equals(lastModuleName);
            }
        })) >= 0) {
            step.setDefaultOptionIndex(defaultOption);
        }
        JBPopupFactory.getInstance().createListPopup((ListPopupStep)step).showCenteredInCurrentWindow(project);
    }

    protected void doRunShell(Module module) {
        GroovyShellRunner shellRunner = this.getRunner(module);
        if (shellRunner == null) {
            return;
        }
        GroovyConsoleRunner runner = new GroovyConsoleRunner(this.getTitle(), shellRunner, module);
        try {
            runner.initAndRun();
        }
        catch (ExecutionException e) {
            LOG.info((Throwable)e);
            Messages.showErrorDialog((Project)module.getProject(), (String)e.getMessage(), (String)("Cannot Run " + this.getTitle()));
        }
    }

    protected abstract GroovyShellRunner getRunner(Module var1);

    public abstract String getTitle();

    protected abstract LanguageConsoleImpl createConsole(Project var1, String var2);

    private class GroovyConsoleRunner
    extends AbstractConsoleRunnerWithHistory<LanguageConsoleView> {
        private final GroovyShellRunner myShellRunner;
        private final Module myModule;

        private GroovyConsoleRunner(@NotNull String consoleTitle, @NotNull GroovyShellRunner shellRunner, Module module) {
            if (consoleTitle == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleTitle", "org/jetbrains/plugins/groovy/console/GroovyShellActionBase$GroovyConsoleRunner", "<init>"));
            }
            if (shellRunner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shellRunner", "org/jetbrains/plugins/groovy/console/GroovyShellActionBase$GroovyConsoleRunner", "<init>"));
            }
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/groovy/console/GroovyShellActionBase$GroovyConsoleRunner", "<init>"));
            }
            super(module.getProject(), consoleTitle, shellRunner.getWorkingDirectory(module));
            this.myShellRunner = shellRunner;
            this.myModule = module;
        }

        protected List<AnAction> fillToolBarActions(DefaultActionGroup toolbarActions, Executor defaultExecutor, RunContentDescriptor contentDescriptor) {
            BuildAndRestartConsoleAction rebuildAction = new BuildAndRestartConsoleAction(this.myModule, this.getProject(), defaultExecutor, contentDescriptor, GroovyShellActionBase.this);
            toolbarActions.add((AnAction)rebuildAction);
            List actions = super.fillToolBarActions(toolbarActions, defaultExecutor, contentDescriptor);
            actions.add(rebuildAction);
            Disposer.register((Disposable)this.getConsoleView(), (Disposable)rebuildAction);
            return actions;
        }

        protected LanguageConsoleView createConsoleView() {
            LanguageConsoleViewImpl res = new LanguageConsoleViewImpl(GroovyShellActionBase.this.createConsole(this.getProject(), this.getConsoleTitle()));
            GroovyFileImpl file = (GroovyFileImpl)res.getConsole().getFile();
            assert (file.getContext() == null);
            file.putUserData(GROOVY_SHELL_FILE, Boolean.TRUE);
            file.setContext(this.myShellRunner.getContext(this.myModule));
            return res;
        }

        protected Process createProcess() throws ExecutionException {
            JavaParameters javaParameters = this.myShellRunner.createJavaParameters(this.myModule);
            Sdk sdk = ModuleRootManager.getInstance((Module)this.myModule).getSdk();
            assert (sdk != null);
            SdkTypeId sdkType = sdk.getSdkType();
            assert (sdkType instanceof JavaSdkType);
            String exePath = ((JavaSdkType)sdkType).getVMExecutablePath(sdk);
            return JdkUtil.setupJVMCommandLine((String)exePath, (SimpleJavaParameters)javaParameters, (boolean)true).createProcess();
        }

        protected OSProcessHandler createProcessHandler(Process process) {
            return new OSProcessHandler(process);
        }

        @NotNull
        protected ProcessBackedConsoleExecuteActionHandler createExecuteActionHandler() {
            ProcessBackedConsoleExecuteActionHandler handler = new ProcessBackedConsoleExecuteActionHandler(this.getProcessHandler(), false){

                public void processLine(@NotNull String line) {
                    if (line == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "org/jetbrains/plugins/groovy/console/GroovyShellActionBase$GroovyConsoleRunner$1", "processLine"));
                    }
                    super.processLine(GroovyConsoleRunner.this.myShellRunner.transformUserInput(line));
                }

                public String getEmptyExecuteAction() {
                    return GroovyShellActionBase.GROOVY_SHELL_EXECUTE;
                }
            };
            new ConsoleHistoryController(this.getConsoleTitle(), null, this.getLanguageConsole(), handler.getConsoleHistoryModel()).install();
            ProcessBackedConsoleExecuteActionHandler processBackedConsoleExecuteActionHandler = handler;
            if (processBackedConsoleExecuteActionHandler == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/console/GroovyShellActionBase$GroovyConsoleRunner", "createExecuteActionHandler"));
            }
            return processBackedConsoleExecuteActionHandler;
        }
    }
}

