/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals;

import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteralContainer;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;

public class GrLiteralEscaper
extends LiteralTextEscaper<GrLiteralContainer> {
    private int[] outSourceOffsets;

    public GrLiteralEscaper(GrLiteralContainer literal) {
        super((PsiLanguageInjectionHost)literal);
    }

    public boolean decode(@NotNull TextRange rangeInsideHost, @NotNull StringBuilder outChars) {
        if (rangeInsideHost == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeInsideHost", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/literals/GrLiteralEscaper", "decode"));
        }
        if (outChars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outChars", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/literals/GrLiteralEscaper", "decode"));
        }
        TextRange.assertProperRange((Segment)rangeInsideHost);
        String subText = rangeInsideHost.substring(((GrLiteralContainer)this.myHost).getText());
        this.outSourceOffsets = new int[subText.length() + 1];
        IElementType elementType = ((GrLiteralContainer)this.myHost).getFirstChild().getNode().getElementType();
        if (elementType == GroovyTokenTypes.mSTRING_LITERAL || elementType == GroovyTokenTypes.mGSTRING_LITERAL || elementType == GroovyTokenTypes.mGSTRING_CONTENT) {
            return GrStringUtil.parseStringCharacters(subText, outChars, this.outSourceOffsets);
        }
        if (elementType == GroovyTokenTypes.mREGEX_LITERAL || elementType == GroovyTokenTypes.mREGEX_CONTENT) {
            return GrStringUtil.parseRegexCharacters(subText, outChars, this.outSourceOffsets, true);
        }
        if (elementType == GroovyTokenTypes.mDOLLAR_SLASH_REGEX_LITERAL || elementType == GroovyTokenTypes.mDOLLAR_SLASH_REGEX_CONTENT) {
            return GrStringUtil.parseRegexCharacters(subText, outChars, this.outSourceOffsets, false);
        }
        return false;
    }

    public int getOffsetInHost(int offsetInDecoded, @NotNull TextRange rangeInsideHost) {
        int result;
        if (rangeInsideHost == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeInsideHost", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/literals/GrLiteralEscaper", "getOffsetInHost"));
        }
        int n = result = offsetInDecoded < this.outSourceOffsets.length ? this.outSourceOffsets[offsetInDecoded] : -1;
        if (result == -1) {
            return -1;
        }
        return (result <= rangeInsideHost.getLength() ? result : rangeInsideHost.getLength()) + rangeInsideHost.getStartOffset();
    }

    public boolean isOneLine() {
        Object value = ((GrLiteralContainer)this.myHost).getValue();
        return value instanceof String && ((String)value).indexOf(10) < 0;
    }
}

