/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunProfileWithCompileBeforeLaunchOption;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.lang.ant.config.AntBuildTarget;
import com.intellij.lang.ant.config.AntConfiguration;
import com.intellij.lang.ant.config.execution.AntRunProfileState;
import com.intellij.lang.ant.config.impl.GlobalAntConfiguration;
import com.intellij.lang.ant.config.impl.TargetChooserDialog;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AntRunConfiguration
extends LocatableConfigurationBase
implements RunProfileWithCompileBeforeLaunchOption {
    private AntSettings mySettings = new AntSettings();

    public AntRunConfiguration(Project project, ConfigurationFactory factory, String name) {
        super(project, factory, name);
    }

    public RunConfiguration clone() {
        AntRunConfiguration configuration = (AntRunConfiguration)super.clone();
        configuration.mySettings = this.mySettings.clone();
        return configuration;
    }

    @NotNull
    public Module[] getModules() {
        Module[] moduleArray = new Module[]{};
        if (moduleArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/config/execution/AntRunConfiguration", "getModules"));
        }
        return moduleArray;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        SettingsEditor<RunConfiguration> settingsEditor = new SettingsEditor<RunConfiguration>(){
            private String myFileUrl = null;
            private String myTargetName = null;
            private final JTextField myTextField = new JTextField();
            private ActionListener myActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AntBuildTarget buildTarget = AntRunConfiguration.this.getTarget();
                    TargetChooserDialog dlg = new TargetChooserDialog(AntRunConfiguration.this.getProject(), buildTarget);
                    dlg.show();
                    if (dlg.isOK()) {
                        VirtualFile vFile;
                        myFileUrl = null;
                        myTargetName = null;
                        buildTarget = dlg.getSelectedTarget();
                        if (buildTarget != null && (vFile = buildTarget.getModel().getBuildFile().getVirtualFile()) != null) {
                            myFileUrl = vFile.getUrl();
                            myTargetName = buildTarget.getName();
                        }
                        this.updateTextField();
                    }
                }
            };

            private void updateTextField() {
                this.myTextField.setText("");
                if (this.myFileUrl != null && this.myTargetName != null) {
                    this.myTextField.setText(this.myTargetName);
                }
                this.fireEditorStateChanged();
            }

            protected void resetEditorFrom(RunConfiguration s) {
                AntRunConfiguration configuration = (AntRunConfiguration)s;
                this.myFileUrl = configuration.mySettings.myFileUrl;
                this.myTargetName = configuration.mySettings.myTargetName;
                this.updateTextField();
            }

            protected void applyEditorTo(RunConfiguration s) throws ConfigurationException {
                AntRunConfiguration configuration = (AntRunConfiguration)s;
                configuration.mySettings.myFileUrl = this.myFileUrl;
                configuration.mySettings.myTargetName = this.myTargetName;
            }

            @NotNull
            protected JComponent createEditor() {
                this.myTextField.setEditable(false);
                TextFieldWithBrowseButton textFieldWithBrowseButton = new TextFieldWithBrowseButton(this.myTextField, this.myActionListener);
                if (textFieldWithBrowseButton == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/config/execution/AntRunConfiguration$1", "createEditor"));
                }
                return textFieldWithBrowseButton;
            }
        };
        if (settingsEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/config/execution/AntRunConfiguration", "getConfigurationEditor"));
        }
        return settingsEditor;
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        if (!AntConfiguration.getInstance(this.getProject()).isInitialized()) {
            throw new RuntimeConfigurationException("Ant Configuration still haven't been initialized");
        }
        if (this.getTarget() == null) {
            throw new RuntimeConfigurationException("Target is not specified", "Missing parameters");
        }
    }

    public String suggestedName() {
        AntBuildTarget target = this.getTarget();
        return target != null ? target.getDisplayName() : "";
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/lang/ant/config/execution/AntRunConfiguration", "getState"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/lang/ant/config/execution/AntRunConfiguration", "getState"));
        }
        return new AntRunProfileState(env);
    }

    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        this.mySettings.readExternal(element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        this.mySettings.writeExternal(element);
    }

    public AntBuildTarget getTarget() {
        return GlobalAntConfiguration.getInstance().findTarget(this.getProject(), this.mySettings.myFileUrl, this.mySettings.myTargetName);
    }

    public boolean acceptSettings(AntBuildTarget target) {
        VirtualFile virtualFile = target.getModel().getBuildFile().getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        this.mySettings.myFileUrl = virtualFile.getUrl();
        this.mySettings.myTargetName = target.getName();
        return true;
    }

    public static class AntSettings
    implements Cloneable,
    JDOMExternalizable {
        private static final String SETTINGS = "antsettings";
        private static final String FILE = "antfile";
        private static final String TARGET = "target";
        private String myFileUrl = null;
        private String myTargetName = null;

        public AntSettings() {
        }

        public AntSettings(String fileUrl, String targetName) {
            this.myFileUrl = fileUrl;
            this.myTargetName = targetName;
        }

        public String toString() {
            return this.myTargetName + "@" + this.myFileUrl;
        }

        protected AntSettings clone() {
            return new AntSettings(this.myFileUrl, this.myTargetName);
        }

        public void readExternal(Element element) throws InvalidDataException {
            if ((element = element.getChild(SETTINGS)) != null) {
                this.myFileUrl = element.getAttributeValue(FILE);
                this.myTargetName = element.getAttributeValue(TARGET);
            }
        }

        public void writeExternal(Element element) throws WriteExternalException {
            if (this.myFileUrl != null && this.myTargetName != null) {
                Element child = new Element(SETTINGS);
                child.setAttribute(FILE, this.myFileUrl);
                child.setAttribute(TARGET, this.myTargetName);
                element.addContent(child);
            }
        }
    }
}

