/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.plugins;

import java.net.URI;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.Plugin;
import org.gradle.api.initialization.dsl.ScriptHandler;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.initialization.ScriptHandlerFactory;
import org.gradle.api.internal.plugins.PluginApplicationException;
import org.gradle.api.plugins.ObjectConfigurationAction;
import org.gradle.api.plugins.PluginAware;
import org.gradle.configuration.ScriptPlugin;
import org.gradle.configuration.ScriptPluginFactory;
import org.gradle.groovy.scripts.DefaultScript;
import org.gradle.groovy.scripts.UriScriptSource;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultObjectConfigurationAction
implements ObjectConfigurationAction {
    private final FileResolver resolver;
    private final ScriptPluginFactory configurerFactory;
    private final ScriptHandlerFactory scriptHandlerFactory;
    private final Set<Object> targets = new LinkedHashSet<Object>();
    private final Set<Runnable> actions = new LinkedHashSet<Runnable>();
    private final ClassLoaderScope classLoaderScope;
    private final Object[] defaultTargets;

    public DefaultObjectConfigurationAction(FileResolver resolver, ScriptPluginFactory configurerFactory, ScriptHandlerFactory scriptHandlerFactory, ClassLoaderScope classLoaderScope, Object ... defaultTargets) {
        this.resolver = resolver;
        this.configurerFactory = configurerFactory;
        this.scriptHandlerFactory = scriptHandlerFactory;
        this.classLoaderScope = classLoaderScope;
        this.defaultTargets = defaultTargets;
    }

    @Override
    public ObjectConfigurationAction to(Object ... targets) {
        GUtil.flatten(targets, this.targets);
        return this;
    }

    @Override
    public ObjectConfigurationAction from(final Object script) {
        this.actions.add(new Runnable(){

            public void run() {
                DefaultObjectConfigurationAction.this.applyScript(script);
            }
        });
        return this;
    }

    @Override
    public ObjectConfigurationAction plugin(final Class<? extends Plugin> pluginClass) {
        this.actions.add(new Runnable(){

            public void run() {
                DefaultObjectConfigurationAction.this.applyPlugin(pluginClass);
            }
        });
        return this;
    }

    @Override
    public ObjectConfigurationAction plugin(final String pluginId) {
        this.actions.add(new Runnable(){

            public void run() {
                DefaultObjectConfigurationAction.this.applyPlugin(pluginId);
            }
        });
        return this;
    }

    private void applyScript(Object script) {
        URI scriptUri = this.resolver.resolveUri(script);
        UriScriptSource scriptSource = new UriScriptSource("script", scriptUri);
        ClassLoaderScope classLoaderScopeChild = this.classLoaderScope.createChild();
        ScriptHandler scriptHandler = this.scriptHandlerFactory.create(scriptSource, classLoaderScopeChild);
        ScriptPlugin configurer = this.configurerFactory.create(scriptSource, scriptHandler, classLoaderScopeChild, this.classLoaderScope, "buildscript", DefaultScript.class, false);
        for (Object target : this.targets) {
            configurer.apply(target);
        }
    }

    private void applyPlugin(Class<? extends Plugin> pluginClass) {
        for (Object target : this.targets) {
            if (target instanceof PluginAware) {
                try {
                    ((PluginAware)target).getPlugins().apply(pluginClass);
                    continue;
                }
                catch (Exception e) {
                    throw new PluginApplicationException("class '" + pluginClass.getName() + "'", e);
                }
            }
            throw new UnsupportedOperationException(String.format("Cannot apply plugin of class '%s' to '%s' (class: %s) as it does not implement PluginAware", pluginClass.getName(), target.toString(), target.getClass().getName()));
        }
    }

    private void applyPlugin(String pluginId) {
        for (Object target : this.targets) {
            if (target instanceof PluginAware) {
                try {
                    ((PluginAware)target).getPlugins().apply(pluginId);
                    continue;
                }
                catch (Exception e) {
                    throw new PluginApplicationException("id '" + pluginId + "'", e);
                }
            }
            throw new UnsupportedOperationException(String.format("Cannot apply plugin with id '%s' to '%s' (class: %s) as it does not implement PluginAware", pluginId, target.toString(), target.getClass().getName()));
        }
    }

    public void execute() {
        if (this.targets.isEmpty()) {
            this.to(this.defaultTargets);
        }
        for (Runnable action : this.actions) {
            action.run();
        }
    }
}

