/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.groovy.scripts.internal;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.SourceUnit;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.groovy.scripts.Transformer;
import org.gradle.groovy.scripts.internal.AbstractScriptTransformer;
import org.gradle.groovy.scripts.internal.AstUtils;
import org.gradle.groovy.scripts.internal.FilteringStatementTransformer;
import org.gradle.groovy.scripts.internal.StatementTransformer;
import org.gradle.internal.UncheckedException;

public class StatementExtractingScriptTransformer
extends AbstractScriptTransformer {
    private final String id;
    private final StatementTransformer transformer;

    public StatementExtractingScriptTransformer(String id, StatementTransformer transformer) {
        this.id = id;
        this.transformer = transformer;
    }

    public String getId() {
        return this.id;
    }

    protected int getPhase() {
        return 3;
    }

    public void call(SourceUnit source) throws CompilationFailedException {
        ImportNode importedClass2;
        AstUtils.filterAndTransformStatements(source, this.transformer);
        for (ImportNode importedClass2 : source.getAST().getImports()) {
            if (AstUtils.isVisible(source, importedClass2.getClassName())) continue;
            try {
                Field field = ModuleNode.class.getDeclaredField("imports");
                field.setAccessible(true);
                Map value = (Map)field.get(source.getAST());
                value.remove(importedClass2.getAlias());
            }
            catch (Exception e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }
        Iterator<Object> iter = source.getAST().getStaticImports().values().iterator();
        while (iter.hasNext()) {
            importedClass2 = (ImportNode)iter.next();
            if (AstUtils.isVisible(source, importedClass2.getClassName())) continue;
            iter.remove();
        }
        iter = source.getAST().getStaticStarImports().values().iterator();
        while (iter.hasNext()) {
            importedClass2 = (ImportNode)iter.next();
            if (AstUtils.isVisible(source, importedClass2.getClassName())) continue;
            iter.remove();
        }
        ClassNode scriptClass = AstUtils.getScriptClass(source);
        Iterator classes = source.getAST().getClasses().iterator();
        while (classes.hasNext()) {
            ClassNode classNode = (ClassNode)classes.next();
            if (classNode == scriptClass) continue;
            classes.remove();
        }
        if (scriptClass != null) {
            for (MethodNode methodNode : new ArrayList(scriptClass.getMethods())) {
                if (methodNode.getName().equals("run")) continue;
                AstUtils.removeMethod(scriptClass, methodNode);
            }
        }
        source.getAST().getMethods().clear();
    }

    public Transformer invert() {
        return new Inverse("no_" + this.getId(), (Spec)Specs.not(this.transformer.getSpec()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Inverse
    extends AbstractScriptTransformer {
        private final String id;
        private final Spec<? super Statement> spec;

        private Inverse(String id, Spec<? super Statement> spec) {
            this.id = id;
            this.spec = spec;
        }

        @Override
        protected int getPhase() {
            return 5;
        }

        @Override
        public String getId() {
            return this.id;
        }

        public void call(SourceUnit source) throws CompilationFailedException {
            AstUtils.filterAndTransformStatements(source, new FilteringStatementTransformer(this.spec));
        }
    }
}

