/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.copyright.ui;

import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.maddyhome.idea.copyright.CopyrightManager;
import com.maddyhome.idea.copyright.CopyrightProfile;
import com.maddyhome.idea.copyright.pattern.EntityUtil;
import com.maddyhome.idea.copyright.pattern.VelocityHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class CopyrightConfigurable
extends NamedConfigurable<CopyrightProfile> {
    private final CopyrightProfile myCopyrightProfile;
    private JPanel myWholePanel;
    private final Project myProject;
    private boolean myModified;
    private String myDisplayName;
    private JEditorPane myCopyrightPane;
    private JButton myValidateButton;
    private JTextField myKeywordTf;
    private JTextField myAllowReplaceTextField;

    public CopyrightConfigurable(Project project, CopyrightProfile copyrightProfile, Runnable updater) {
        super(true, updater);
        this.myProject = project;
        this.myCopyrightProfile = copyrightProfile;
        this.$$$setupUI$$$();
        this.myDisplayName = this.myCopyrightProfile.getName();
    }

    public void setDisplayName(String s) {
        this.myCopyrightProfile.setName(s);
    }

    public CopyrightProfile getEditableObject() {
        return this.myCopyrightProfile;
    }

    public String getBannerSlogan() {
        return this.myCopyrightProfile.getName();
    }

    public JComponent createOptionsPanel() {
        this.myCopyrightPane.setFont(EditorColorsManager.getInstance().getGlobalScheme().getFont(EditorFontType.PLAIN));
        this.myValidateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    VelocityHelper.verify(CopyrightConfigurable.this.myCopyrightPane.getText());
                    Messages.showInfoMessage((Project)CopyrightConfigurable.this.myProject, (String)"Velocity template is valid.", (String)"Validation");
                }
                catch (Exception e1) {
                    Messages.showInfoMessage((Project)CopyrightConfigurable.this.myProject, (String)("Velocity template contains error:\n" + e1.getMessage()), (String)"Validation");
                }
            }
        });
        return this.myWholePanel;
    }

    @Nls
    public String getDisplayName() {
        return this.myCopyrightProfile.getName();
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return null;
    }

    public boolean isModified() {
        return this.myModified || !Comparing.strEqual((String)EntityUtil.encode(this.myCopyrightPane.getText().trim()), (String)this.myCopyrightProfile.getNotice()) || !Comparing.strEqual((String)this.myKeywordTf.getText().trim(), (String)this.myCopyrightProfile.getKeyword()) || !Comparing.strEqual((String)this.myAllowReplaceTextField.getText().trim(), (String)this.myCopyrightProfile.getAllowReplaceKeyword()) || !Comparing.strEqual((String)this.myDisplayName, (String)this.myCopyrightProfile.getName());
    }

    public void apply() throws ConfigurationException {
        this.myCopyrightProfile.setNotice(EntityUtil.encode(this.myCopyrightPane.getText().trim()));
        String keyword = this.myKeywordTf.getText().trim();
        try {
            if (!StringUtil.isEmptyOrSpaces((String)keyword)) {
                Pattern.compile(keyword);
            }
        }
        catch (PatternSyntaxException e) {
            throw new ConfigurationException("Keyword pattern syntax is incorrect: " + e.getMessage());
        }
        this.myCopyrightProfile.setKeyword(keyword);
        this.myCopyrightProfile.setAllowReplaceKeyword(this.myAllowReplaceTextField.getText());
        CopyrightManager.getInstance(this.myProject).replaceCopyright(this.myDisplayName, this.myCopyrightProfile);
        this.myDisplayName = this.myCopyrightProfile.getName();
        this.myModified = false;
    }

    public void reset() {
        this.myDisplayName = this.myCopyrightProfile.getName();
        this.myCopyrightPane.setText(EntityUtil.decode(this.myCopyrightProfile.getNotice()));
        this.myKeywordTf.setText(this.myCopyrightProfile.getKeyword());
        this.myAllowReplaceTextField.setText(this.myCopyrightProfile.getAllowReplaceKeyword());
    }

    public void disposeUIResources() {
    }

    public void setModified(boolean modified) {
        this.myModified = modified;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JButton jButton;
        JTextField jTextField2;
        JEditorPane jEditorPane;
        JPanel jPanel;
        this.myWholePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(5, 0, 0, 0), -1, -1, false, false));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 2, 0, 3, 7, 0, null, new Dimension(-1, 200), null));
        this.myCopyrightPane = jEditorPane = new JEditorPane();
        jBScrollPane.setViewportView(jEditorPane);
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Keyword to detect copyright in comments:");
        jPanel.add((Component)jLabel, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myKeywordTf = jTextField2 = new JTextField();
        jPanel.add((Component)jTextField2, new GridConstraints(3, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myValidateButton = jButton = new JButton();
        jButton.setText("Validate");
        jPanel.add((Component)jButton, new GridConstraints(2, 1, 1, 1, 4, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Allow replacing copyright if old copyright contains:");
        jPanel.add((Component)jLabel2, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAllowReplaceTextField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(4, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Copyright text (may contain Velocity templates):");
        jPanel.add((Component)jLabel3, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        jLabel2.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }
}

