/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.arrangement.Rearranger;
import com.intellij.psi.codeStyle.arrangement.engine.ArrangementEngine;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

class RearrangeCommand {
    @NotNull
    private PsiFile myFile;
    @NotNull
    private String myCommandName;
    @NotNull
    private Project myProject;
    private Document myDocument;
    private Runnable myCommand;
    private final Collection<TextRange> myRanges;

    RearrangeCommand(@NotNull Project project, @NotNull PsiFile file, @NotNull String commandName, @NotNull Collection<TextRange> ranges) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/actions/RearrangeCommand", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/RearrangeCommand", "<init>"));
        }
        if (commandName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandName", "com/intellij/codeInsight/actions/RearrangeCommand", "<init>"));
        }
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/intellij/codeInsight/actions/RearrangeCommand", "<init>"));
        }
        this.myProject = project;
        this.myFile = file;
        this.myRanges = ranges;
        this.myCommandName = commandName;
        this.myDocument = PsiDocumentManager.getInstance((Project)project).getDocument(file);
    }

    boolean couldRearrange() {
        return this.myDocument != null && Rearranger.EXTENSION.forLanguage(this.myFile.getLanguage()) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void run() {
        assert (this.myDocument != null);
        this.prepare();
        try {
            CommandProcessor.getInstance().executeCommand(this.myProject, this.myCommand, this.myCommandName, null);
        }
        finally {
            PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(this.myDocument);
        }
    }

    private void prepare() {
        final ArrangementEngine engine = (ArrangementEngine)ServiceManager.getService((Project)this.myProject, ArrangementEngine.class);
        this.myCommand = new Runnable(){

            @Override
            public void run() {
                engine.arrange(RearrangeCommand.this.myFile, RearrangeCommand.this.myRanges);
            }
        };
        PsiDocumentManager.getInstance((Project)this.myProject).doPostponedOperationsAndUnblockDocument(this.myDocument);
    }
}

