/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.codeInsight.daemon.MergeableLineMarkerInfo;
import com.intellij.codeInsight.daemon.impl.MarkerType;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.searches.AllOverridingMethodsSearch;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.FunctionalExpressionSearch;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashSet;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaLineMarkerProvider
implements LineMarkerProvider,
DumbAware {
    protected final DaemonCodeAnalyzerSettings myDaemonSettings;
    protected final EditorColorsManager myColorsManager;

    public JavaLineMarkerProvider(DaemonCodeAnalyzerSettings daemonSettings, EditorColorsManager colorsManager) {
        this.myDaemonSettings = daemonSettings;
        this.myColorsManager = colorsManager;
    }

    @Nullable
    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement element) {
        PsiMethod method;
        MethodSignatureBackedByPsiMethod superSignature;
        PsiElement parent;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/JavaLineMarkerProvider", "getLineMarkerInfo"));
        }
        if (element instanceof PsiIdentifier && (parent = element.getParent()) instanceof PsiMethod && !DumbService.getInstance((Project)element.getProject()).isDumb() && (superSignature = (MethodSignatureBackedByPsiMethod)SuperMethodsSearch.search((PsiMethod)(method = (PsiMethod)parent), null, (boolean)true, (boolean)false).findFirst()) != null) {
            boolean overrides = method.hasModifierProperty("abstract") == superSignature.getMethod().hasModifierProperty("abstract");
            Icon icon = overrides ? AllIcons.Gutter.OverridingMethod : AllIcons.Gutter.ImplementingMethod;
            MarkerType type = MarkerType.OVERRIDING_METHOD;
            return new ArrowUpLineMarkerInfo(element, icon, type);
        }
        PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiElement)element);
        PsiElement firstChild = element.getFirstChild();
        if (interfaceMethod != null && firstChild != null) {
            Icon icon = AllIcons.Gutter.ImplementingMethod;
            MarkerType type = MarkerType.OVERRIDING_METHOD;
            return new ArrowUpLineMarkerInfo(firstChild, icon, type);
        }
        if (this.myDaemonSettings.SHOW_METHOD_SEPARATORS && firstChild == null) {
            PsiElement element1 = element;
            boolean isMember = false;
            while (element1 != null && !(element1 instanceof PsiFile) && element1.getPrevSibling() == null) {
                if (!((element1 = element1.getParent()) instanceof PsiMember)) continue;
                isMember = true;
                break;
            }
            if (isMember && !(element1 instanceof PsiAnonymousClass) && !(element1.getParent() instanceof PsiAnonymousClass)) {
                PsiFile file = element1.getContainingFile();
                Document document = file == null ? null : PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
                boolean drawSeparator = false;
                if (document != null) {
                    CharSequence documentChars = document.getCharsSequence();
                    int category = JavaLineMarkerProvider.getCategory(element1, documentChars);
                    for (PsiElement child = element1.getPrevSibling(); child != null; child = child.getPrevSibling()) {
                        int category1 = JavaLineMarkerProvider.getCategory(child, documentChars);
                        if (category1 == 0) continue;
                        drawSeparator = category != 1 || category1 != 1;
                        break;
                    }
                }
                if (drawSeparator) {
                    LineMarkerInfo info = new LineMarkerInfo(element, element.getTextRange(), null, 4, (Function)FunctionUtil.nullConstant(), null, GutterIconRenderer.Alignment.RIGHT);
                    EditorColorsScheme scheme = this.myColorsManager.getGlobalScheme();
                    info.separatorColor = scheme.getColor(CodeInsightColors.METHOD_SEPARATORS_COLOR);
                    info.separatorPlacement = SeparatorPlacement.TOP;
                    return info;
                }
            }
        }
        return null;
    }

    private static int getCategory(@NotNull PsiElement element, @NotNull CharSequence documentChars) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/JavaLineMarkerProvider", "getCategory"));
        }
        if (documentChars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documentChars", "com/intellij/codeInsight/daemon/impl/JavaLineMarkerProvider", "getCategory"));
        }
        if (element instanceof PsiField || element instanceof PsiTypeParameter) {
            return 1;
        }
        if (element instanceof PsiClass || element instanceof PsiClassInitializer) {
            return 2;
        }
        if (element instanceof PsiMethod) {
            int end;
            if (((PsiMethod)element).hasModifierProperty("abstract")) {
                return 1;
            }
            TextRange textRange = element.getTextRange();
            int start = textRange.getStartOffset();
            int crlf = StringUtil.getLineBreakCount((CharSequence)documentChars.subSequence(start, end = Math.min(documentChars.length(), textRange.getEndOffset())));
            return crlf == 0 ? 1 : 2;
        }
        return 0;
    }

    public void collectSlowLineMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<LineMarkerInfo> result) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/codeInsight/daemon/impl/JavaLineMarkerProvider", "collectSlowLineMarkers"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/daemon/impl/JavaLineMarkerProvider", "collectSlowLineMarkers"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (elements.isEmpty() || DumbService.getInstance((Project)elements.get(0).getProject()).isDumb()) {
            return;
        }
        HashSet methods = new HashSet();
        for (int i = 0; i < elements.size(); ++i) {
            PsiElement element = elements.get(i);
            ProgressManager.checkCanceled();
            if (element instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)element;
                if (!PsiUtil.canBeOverriden((PsiMethod)method)) continue;
                methods.add(method);
                continue;
            }
            if (!(element instanceof PsiClass) || element instanceof PsiTypeParameter) continue;
            JavaLineMarkerProvider.collectInheritingClasses((PsiClass)element, result);
        }
        if (!methods.isEmpty()) {
            JavaLineMarkerProvider.collectOverridingAccessors((Set<PsiMethod>)methods, result);
        }
    }

    public static void collectInheritingClasses(PsiClass aClass, Collection<LineMarkerInfo> result) {
        if (aClass.hasModifierProperty("final")) {
            return;
        }
        if ("java.lang.Object".equals(aClass.getQualifiedName())) {
            return;
        }
        if (ClassInheritorsSearch.search((PsiClass)aClass, (boolean)false).findFirst() != null || FunctionalExpressionSearch.search((PsiClass)aClass).findFirst() != null) {
            Icon icon = aClass.isInterface() ? AllIcons.Gutter.ImplementedMethod : AllIcons.Gutter.OverridenMethod;
            PsiIdentifier range = aClass.getNameIdentifier();
            if (range == null) {
                range = aClass;
            }
            MarkerType type = MarkerType.SUBCLASSED_CLASS;
            LineMarkerInfo info = new LineMarkerInfo((PsiElement)range, range.getTextRange(), icon, 6, type.getTooltip(), type.getNavigationHandler(), GutterIconRenderer.Alignment.RIGHT);
            result.add(info);
        }
    }

    private static void collectOverridingAccessors(final Set<PsiMethod> methods, Collection<LineMarkerInfo> result) {
        HashSet overridden = new HashSet();
        THashSet classes = new THashSet();
        for (PsiMethod method : methods) {
            ProgressManager.checkCanceled();
            PsiClass parentClass = method.getContainingClass();
            if ("java.lang.Object".equals(parentClass.getQualifiedName())) continue;
            classes.add(parentClass);
        }
        for (PsiClass aClass : classes) {
            AllOverridingMethodsSearch.search((PsiClass)aClass).forEach((Processor)new Processor<Pair<PsiMethod, PsiMethod>>((Set)overridden){
                final /* synthetic */ Set val$overridden;
                {
                    this.val$overridden = set2;
                }

                public boolean process(Pair<PsiMethod, PsiMethod> pair) {
                    ProgressManager.checkCanceled();
                    PsiMethod superMethod = (PsiMethod)pair.getFirst();
                    if (methods.remove(superMethod)) {
                        this.val$overridden.add(superMethod);
                    }
                    return !methods.isEmpty();
                }
            });
        }
        if (!methods.isEmpty()) {
            for (PsiClass aClass : classes) {
                PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiClass)aClass);
                if (interfaceMethod == null || FunctionalExpressionSearch.search((PsiClass)aClass).findFirst() == null) continue;
                overridden.add(interfaceMethod);
            }
        }
        for (PsiMethod method : overridden) {
            PsiElement navigationElement;
            Icon icon;
            ProgressManager.checkCanceled();
            boolean overrides = !method.hasModifierProperty("abstract");
            Icon icon2 = icon = overrides ? AllIcons.Gutter.OverridenMethod : AllIcons.Gutter.ImplementedMethod;
            Object range = method.isPhysical() ? method.getNameIdentifier() : ((navigationElement = method.getNavigationElement()) instanceof PsiNameIdentifierOwner ? ((PsiNameIdentifierOwner)navigationElement).getNameIdentifier() : navigationElement);
            if (range == null) {
                range = method;
            }
            MarkerType type = MarkerType.OVERRIDEN_METHOD;
            LineMarkerInfo info = new LineMarkerInfo((PsiElement)range, range.getTextRange(), icon, 6, type.getTooltip(), type.getNavigationHandler(), GutterIconRenderer.Alignment.RIGHT);
            result.add(info);
        }
    }

    private static class ArrowUpLineMarkerInfo
    extends MergeableLineMarkerInfo<PsiElement> {
        private ArrowUpLineMarkerInfo(@NotNull PsiElement element, Icon icon, @NotNull MarkerType markerType) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/JavaLineMarkerProvider$ArrowUpLineMarkerInfo", "<init>"));
            }
            if (markerType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "markerType", "com/intellij/codeInsight/daemon/impl/JavaLineMarkerProvider$ArrowUpLineMarkerInfo", "<init>"));
            }
            super(element, element.getTextRange(), icon, 4, markerType.getTooltip(), markerType.getNavigationHandler(), GutterIconRenderer.Alignment.LEFT);
        }

        public boolean canMergeWith(@NotNull MergeableLineMarkerInfo<?> info) {
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/codeInsight/daemon/impl/JavaLineMarkerProvider$ArrowUpLineMarkerInfo", "canMergeWith"));
            }
            if (!(info instanceof ArrowUpLineMarkerInfo)) {
                return false;
            }
            PsiElement otherElement = info.getElement();
            PsiElement myElement = this.getElement();
            return otherElement != null && myElement != null;
        }

        public Icon getCommonIcon(@NotNull List<MergeableLineMarkerInfo> infos) {
            if (infos == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/codeInsight/daemon/impl/JavaLineMarkerProvider$ArrowUpLineMarkerInfo", "getCommonIcon"));
            }
            return this.myIcon;
        }

        public Function<? super PsiElement, String> getCommonTooltip(@NotNull List<MergeableLineMarkerInfo> infos) {
            if (infos == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/codeInsight/daemon/impl/JavaLineMarkerProvider$ArrowUpLineMarkerInfo", "getCommonTooltip"));
            }
            return new Function<PsiElement, String>(){

                public String fun(PsiElement element) {
                    return "Multiple method overrides";
                }
            };
        }
    }
}

