/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup.impl;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.completion.CompletionPhase;
import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.codeInsight.editorActions.AutoHardWrapHandler;
import com.intellij.codeInsight.editorActions.TypedHandler;
import com.intellij.codeInsight.lookup.CharFilter;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.lookup.impl.actions.ChooseItemAction;
import com.intellij.codeInsight.template.impl.editorActions.TypedActionHandlerBase;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.actionSystem.TypedActionHandler;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import java.awt.Component;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LookupTypedHandler
extends TypedActionHandlerBase {
    public LookupTypedHandler(@Nullable TypedActionHandler originalHandler) {
        super(originalHandler);
    }

    public void execute(@NotNull Editor originalEditor, char charTyped, @NotNull DataContext dataContext) {
        Editor editor;
        PsiFile file;
        if (originalEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalEditor", "com/intellij/codeInsight/lookup/impl/LookupTypedHandler", "execute"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/codeInsight/lookup/impl/LookupTypedHandler", "execute"));
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        PsiFile psiFile = file = project == null ? null : PsiUtilBase.getPsiFileInEditor((Editor)originalEditor, (Project)project);
        if (file == null) {
            if (this.myOriginalHandler != null) {
                this.myOriginalHandler.execute(originalEditor, charTyped, dataContext);
            }
            return;
        }
        if (!CodeInsightUtilBase.prepareEditorForWrite(originalEditor) || !FileDocumentManager.getInstance().requestWriting(originalEditor.getDocument(), project)) {
            return;
        }
        CompletionPhase oldPhase = CompletionServiceImpl.getCompletionPhase();
        if (oldPhase instanceof CompletionPhase.CommittingDocuments && ((CompletionPhase.CommittingDocuments)oldPhase).isRestartingCompletion()) {
            assert (oldPhase.indicator != null);
            oldPhase.indicator.scheduleRestart();
        }
        if ((editor = TypedHandler.injectedEditorIfCharTypedIsSignificant(charTyped, originalEditor, file)) != originalEditor) {
            file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        }
        if (originalEditor.isInsertMode() && LookupTypedHandler.beforeCharTyped(charTyped, project, originalEditor, editor, file)) {
            return;
        }
        if (this.myOriginalHandler != null) {
            this.myOriginalHandler.execute(originalEditor, charTyped, dataContext);
        }
    }

    private static boolean beforeCharTyped(final char charTyped, Project project, final Editor originalEditor, Editor editor, PsiFile file) {
        LookupElement item;
        LookupImpl lookup = (LookupImpl)LookupManager.getActiveLookup(originalEditor);
        if (lookup == null) {
            return false;
        }
        if (charTyped == ' ' && ChooseItemAction.hasTemplatePrefix(lookup, ' ')) {
            return false;
        }
        CharFilter.Result result = LookupTypedHandler.getLookupAction(charTyped, lookup);
        if (lookup.isLookupDisposed()) {
            return false;
        }
        if (result == CharFilter.Result.ADD_TO_PREFIX) {
            CompletionProgressIndicator completion;
            Document document = editor.getDocument();
            long modificationStamp = document.getModificationStamp();
            if (!lookup.performGuardedChange(new Runnable(){

                @Override
                public void run() {
                    EditorModificationUtil.typeInStringAtCaretHonorMultipleCarets((Editor)originalEditor, (String)String.valueOf(charTyped), (boolean)true);
                }
            })) {
                return true;
            }
            lookup.appendPrefix(charTyped);
            if (lookup.isStartCompletionWhenNothingMatches() && lookup.getItems().isEmpty()) {
                completion = CompletionServiceImpl.getCompletionService().getCurrentCompletion();
                if (completion != null) {
                    completion.scheduleRestart();
                } else {
                    AutoPopupController.getInstance(editor.getProject()).scheduleAutoPopup(editor);
                }
            }
            AutoHardWrapHandler.getInstance().wrapLineIfNecessary(editor, DataManager.getInstance().getDataContext((Component)editor.getContentComponent()), modificationStamp);
            completion = CompletionServiceImpl.getCompletionService().getCurrentCompletion();
            if (completion != null) {
                completion.prefixUpdated();
            }
            return true;
        }
        if (result == CharFilter.Result.SELECT_ITEM_AND_FINISH_LOOKUP && lookup.isFocused() && (item = lookup.getCurrentItem()) != null) {
            if (LookupTypedHandler.completeTillTypedCharOccurrence(charTyped, lookup, item)) {
                return true;
            }
            FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.finishByDotEtc");
            lookup.finishLookup(charTyped);
            return true;
        }
        lookup.hide();
        TypedHandler.autoPopupCompletion(editor, charTyped, project, file);
        return false;
    }

    private static boolean completeTillTypedCharOccurrence(char charTyped, LookupImpl lookup, LookupElement item) {
        String oldPrefix;
        PrefixMatcher matcher = lookup.itemMatcher(item);
        PrefixMatcher expanded = matcher.cloneWithPrefix((oldPrefix = matcher.getPrefix() + lookup.getAdditionalPrefix()) + charTyped);
        if (expanded.prefixMatches(item)) {
            for (String s : item.getAllLookupStrings()) {
                if (!matcher.prefixMatches(s)) continue;
                int i = -1;
                while ((i = s.indexOf(charTyped, i + 1)) >= 0) {
                    String newPrefix = s.substring(0, i + 1);
                    if (!expanded.prefixMatches(newPrefix)) continue;
                    lookup.replacePrefix(oldPrefix, newPrefix);
                    return true;
                }
            }
        }
        return false;
    }

    static CharFilter.Result getLookupAction(char charTyped, LookupImpl lookup) {
        CharFilter.Result filtersDecision = LookupTypedHandler.getFiltersDecision(charTyped, lookup);
        LookupElement currentItem = lookup.getCurrentItem();
        if (currentItem != null && charTyped != ' ') {
            String postfix = lookup.getAdditionalPrefix() + charTyped;
            PrefixMatcher matcher = lookup.itemMatcher(currentItem);
            for (String lookupString : currentItem.getAllLookupStrings()) {
                if (!lookupString.startsWith(matcher.getPrefix() + postfix)) continue;
                return CharFilter.Result.ADD_TO_PREFIX;
            }
        }
        if (filtersDecision != null) {
            return filtersDecision;
        }
        throw new AssertionError((Object)("Typed char not handler by char filter: c=" + charTyped + "; prefix=" + currentItem + "; filters=" + Arrays.toString(LookupTypedHandler.getFilters())));
    }

    @Nullable
    private static CharFilter.Result getFiltersDecision(char charTyped, LookupImpl lookup) {
        LookupElement item = lookup.getCurrentItem();
        int prefixLength = item == null ? lookup.getAdditionalPrefix().length() : lookup.itemPattern(item).length();
        for (CharFilter extension : LookupTypedHandler.getFilters()) {
            CharFilter.Result result = extension.acceptChar(charTyped, prefixLength, lookup);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static CharFilter[] getFilters() {
        return (CharFilter[])Extensions.getExtensions(CharFilter.EP_NAME);
    }
}

