/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.navigation.DomGotoRelatedItem;
import com.intellij.codeInsight.navigation.NavigationGutterIconRenderer;
import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.ConstantFunction;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import gnu.trove.THashSet;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NavigationGutterIconBuilder<T> {
    @NonNls
    private static final String PATTERN = "&nbsp;&nbsp;&nbsp;&nbsp;{0}";
    private static final NotNullFunction<PsiElement, Collection<? extends PsiElement>> DEFAULT_PSI_CONVERTOR = new NotNullFunction<PsiElement, Collection<? extends PsiElement>>(){

        @NotNull
        public Collection<? extends PsiElement> fun(PsiElement element) {
            List list = ContainerUtil.createMaybeSingletonList((Object)element);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/navigation/NavigationGutterIconBuilder$1", "fun"));
            }
            return list;
        }
    };
    private final Icon myIcon;
    private final NotNullFunction<T, Collection<? extends PsiElement>> myConverter;
    private NotNullLazyValue<Collection<T>> myTargets;
    private boolean myLazy;
    private String myTooltipText;
    private String myPopupTitle;
    private String myEmptyText;
    private String myTooltipTitle;
    private GutterIconRenderer.Alignment myAlignment;
    private Computable<PsiElementListCellRenderer> myCellRenderer;
    private NullableFunction<T, String> myNamer;
    private final NotNullFunction<T, Collection<? extends GotoRelatedItem>> myGotoRelatedItemProvider;
    public static final NotNullFunction<DomElement, Collection<? extends PsiElement>> DEFAULT_DOM_CONVERTOR = new NotNullFunction<DomElement, Collection<? extends PsiElement>>(){

        @NotNull
        public Collection<? extends PsiElement> fun(DomElement o) {
            List list = ContainerUtil.createMaybeSingletonList((Object)o.getXmlElement());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/navigation/NavigationGutterIconBuilder$2", "fun"));
            }
            return list;
        }
    };
    public static final NotNullFunction<DomElement, Collection<? extends GotoRelatedItem>> DOM_GOTO_RELATED_ITEM_PROVIDER = new NotNullFunction<DomElement, Collection<? extends GotoRelatedItem>>(){

        @NotNull
        public Collection<? extends GotoRelatedItem> fun(DomElement dom) {
            if (dom.getXmlElement() != null) {
                List<DomGotoRelatedItem> list = Collections.singletonList(new DomGotoRelatedItem(dom));
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/navigation/NavigationGutterIconBuilder$3", "fun"));
                }
                return list;
            }
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/navigation/NavigationGutterIconBuilder$3", "fun"));
            }
            return list;
        }
    };
    public static final NotNullFunction<PsiElement, Collection<? extends GotoRelatedItem>> PSI_GOTO_RELATED_ITEM_PROVIDER = new NotNullFunction<PsiElement, Collection<? extends GotoRelatedItem>>(){

        @NotNull
        public Collection<? extends GotoRelatedItem> fun(PsiElement dom) {
            List<GotoRelatedItem> list = Collections.singletonList(new GotoRelatedItem(dom, "XML"));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/navigation/NavigationGutterIconBuilder$4", "fun"));
            }
            return list;
        }
    };

    protected NavigationGutterIconBuilder(@NotNull Icon icon, @NotNull NotNullFunction<T, Collection<? extends PsiElement>> converter) {
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/codeInsight/navigation/NavigationGutterIconBuilder", "<init>"));
        }
        if (converter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "converter", "com/intellij/codeInsight/navigation/NavigationGutterIconBuilder", "<init>"));
        }
        this(icon, converter, null);
    }

    protected NavigationGutterIconBuilder(@NotNull Icon icon, @NotNull NotNullFunction<T, Collection<? extends PsiElement>> converter, @Nullable NotNullFunction<T, Collection<? extends GotoRelatedItem>> gotoRelatedItemProvider) {
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/codeInsight/navigation/NavigationGutterIconBuilder", "<init>"));
        }
        if (converter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "converter", "com/intellij/codeInsight/navigation/NavigationGutterIconBuilder", "<init>"));
        }
        this.myAlignment = GutterIconRenderer.Alignment.CENTER;
        this.myNamer = ElementPresentationManager.namer();
        this.myIcon = icon;
        this.myConverter = converter;
        this.myGotoRelatedItemProvider = gotoRelatedItemProvider;
    }

    public static NavigationGutterIconBuilder<PsiElement> create(@NotNull Icon icon) {
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/codeInsight/navigation/NavigationGutterIconBuilder", "create"));
        }
        return NavigationGutterIconBuilder.create(icon, DEFAULT_PSI_CONVERTOR, PSI_GOTO_RELATED_ITEM_PROVIDER);
    }

    public static <T> NavigationGutterIconBuilder<T> create(@NotNull Icon icon, @NotNull NotNullFunction<T, Collection<? extends PsiElement>> converter) {
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/codeInsight/navigation/NavigationGutterIconBuilder", "create"));
        }
        if (converter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "converter", "com/intellij/codeInsight/navigation/NavigationGutterIconBuilder", "create"));
        }
        return NavigationGutterIconBuilder.create(icon, converter, null);
    }

    public static <T> NavigationGutterIconBuilder<T> create(@NotNull Icon icon, @NotNull NotNullFunction<T, Collection<? extends PsiElement>> converter, @Nullable NotNullFunction<T, Collection<? extends GotoRelatedItem>> gotoRelatedItemProvider) {
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/codeInsight/navigation/NavigationGutterIconBuilder", "create"));
        }
        if (converter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "converter", "com/intellij/codeInsight/navigation/NavigationGutterIconBuilder", "create"));
        }
        return new NavigationGutterIconBuilder<T>(icon, converter, gotoRelatedItemProvider);
    }

    public NavigationGutterIconBuilder<T> setTarget(@Nullable T target) {
        return this.setTargets(ContainerUtil.createMaybeSingletonList(target));
    }

    public NavigationGutterIconBuilder<T> setTargets(T ... targets) {
        if (targets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targets", "com/intellij/codeInsight/navigation/NavigationGutterIconBuilder", "setTargets"));
        }
        return this.setTargets((Collection<? extends T>)Arrays.asList(targets));
    }

    public NavigationGutterIconBuilder<T> setTargets(@NotNull NotNullLazyValue<Collection<? extends T>> targets) {
        if (targets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targets", "com/intellij/codeInsight/navigation/NavigationGutterIconBuilder", "setTargets"));
        }
        this.myTargets = targets;
        this.myLazy = true;
        return this;
    }

    public NavigationGutterIconBuilder<T> setTargets(@NotNull Collection<? extends T> targets) {
        if (targets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targets", "com/intellij/codeInsight/navigation/NavigationGutterIconBuilder", "setTargets"));
        }
        this.myTargets = NotNullLazyValue.createConstantValue(targets);
        return this;
    }

    public NavigationGutterIconBuilder<T> setTooltipText(@NotNull String tooltipText) {
        if (tooltipText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tooltipText", "com/intellij/codeInsight/navigation/NavigationGutterIconBuilder", "setTooltipText"));
        }
        this.myTooltipText = tooltipText;
        return this;
    }

    public NavigationGutterIconBuilder<T> setAlignment(@NotNull GutterIconRenderer.Alignment alignment) {
        if (alignment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "alignment", "com/intellij/codeInsight/navigation/NavigationGutterIconBuilder", "setAlignment"));
        }
        this.myAlignment = alignment;
        return this;
    }

    public NavigationGutterIconBuilder<T> setPopupTitle(@NotNull String popupTitle) {
        if (popupTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popupTitle", "com/intellij/codeInsight/navigation/NavigationGutterIconBuilder", "setPopupTitle"));
        }
        this.myPopupTitle = popupTitle;
        return this;
    }

    public NavigationGutterIconBuilder<T> setEmptyPopupText(@NotNull String emptyText) {
        if (emptyText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "emptyText", "com/intellij/codeInsight/navigation/NavigationGutterIconBuilder", "setEmptyPopupText"));
        }
        this.myEmptyText = emptyText;
        return this;
    }

    public NavigationGutterIconBuilder<T> setTooltipTitle(@NotNull String tooltipTitle) {
        if (tooltipTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tooltipTitle", "com/intellij/codeInsight/navigation/NavigationGutterIconBuilder", "setTooltipTitle"));
        }
        this.myTooltipTitle = tooltipTitle;
        return this;
    }

    public NavigationGutterIconBuilder<T> setNamer(@NotNull NullableFunction<T, String> namer) {
        if (namer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namer", "com/intellij/codeInsight/navigation/NavigationGutterIconBuilder", "setNamer"));
        }
        this.myNamer = namer;
        return this;
    }

    public NavigationGutterIconBuilder<T> setCellRenderer(@NotNull PsiElementListCellRenderer cellRenderer) {
        if (cellRenderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cellRenderer", "com/intellij/codeInsight/navigation/NavigationGutterIconBuilder", "setCellRenderer"));
        }
        this.myCellRenderer = new Computable.PredefinedValueComputable((Object)cellRenderer);
        return this;
    }

    @Nullable
    public Annotation install(@NotNull DomElementAnnotationHolder holder, @Nullable DomElement element) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInsight/navigation/NavigationGutterIconBuilder", "install"));
        }
        if (!this.myLazy && ((Collection)this.myTargets.getValue()).isEmpty() || element == null) {
            return null;
        }
        return this.doInstall(holder.createAnnotation(element, HighlightSeverity.INFORMATION, null), element.getManager().getProject());
    }

    @Nullable
    public Annotation install(@NotNull AnnotationHolder holder, @Nullable PsiElement element) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInsight/navigation/NavigationGutterIconBuilder", "install"));
        }
        if (!this.myLazy && ((Collection)this.myTargets.getValue()).isEmpty() || element == null) {
            return null;
        }
        return this.doInstall(holder.createInfoAnnotation(element, null), element.getProject());
    }

    private Annotation doInstall(@NotNull Annotation annotation, @NotNull Project project) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/codeInsight/navigation/NavigationGutterIconBuilder", "doInstall"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/navigation/NavigationGutterIconBuilder", "doInstall"));
        }
        MyNavigationGutterIconRenderer renderer = this.createGutterIconRenderer(project);
        annotation.setGutterIconRenderer((GutterIconRenderer)renderer);
        annotation.setNeedsUpdateOnTyping(false);
        return annotation;
    }

    public RelatedItemLineMarkerInfo<PsiElement> createLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/navigation/NavigationGutterIconBuilder", "createLineMarkerInfo"));
        }
        MyNavigationGutterIconRenderer renderer = this.createGutterIconRenderer(element.getProject());
        String tooltip = renderer.getTooltipText();
        NotNullLazyValue<Collection<GotoRelatedItem>> gotoTargets = NavigationGutterIconBuilder.createGotoTargetsThunk(this.myLazy, this.myGotoRelatedItemProvider, NavigationGutterIconBuilder.evaluateAndForget(this.myTargets));
        return new RelatedItemLineMarkerInfo(element, element.getTextRange(), renderer.getIcon(), 6, (Function)(tooltip == null ? null : new ConstantFunction((Object)tooltip)), (GutterIconNavigationHandler)(renderer.isNavigateAction() ? renderer : null), renderer.getAlignment(), gotoTargets);
    }

    private static <T> NotNullLazyValue<Collection<? extends GotoRelatedItem>> createGotoTargetsThunk(boolean lazy, final NotNullFunction<T, Collection<? extends GotoRelatedItem>> gotoRelatedItemProvider, final Factory<Collection<T>> factory) {
        if (gotoRelatedItemProvider == null) {
            return NotNullLazyValue.createConstantValue(Collections.emptyList());
        }
        if (lazy) {
            return new NotNullLazyValue<Collection<? extends GotoRelatedItem>>(){

                @NotNull
                protected Collection<? extends GotoRelatedItem> compute() {
                    List list = ContainerUtil.concat((Iterable)((Iterable)factory.create()), (Function)gotoRelatedItemProvider);
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/navigation/NavigationGutterIconBuilder$5", "compute"));
                    }
                    return list;
                }
            };
        }
        List concat = ContainerUtil.concat((Iterable)((Iterable)factory.create()), gotoRelatedItemProvider);
        return NotNullLazyValue.createConstantValue((Object)concat);
    }

    private void checkBuilt() {
        assert (this.myTargets != null) : "Must have called .setTargets() before calling create()";
    }

    private static <T> Factory<T> evaluateAndForget(NotNullLazyValue<T> lazyValue) {
        final Ref ref = Ref.create(lazyValue);
        return new Factory<T>(){

            public T create() {
                Object result = ((NotNullLazyValue)ref.get()).getValue();
                ref.set(null);
                return result;
            }
        };
    }

    private MyNavigationGutterIconRenderer createGutterIconRenderer(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/navigation/NavigationGutterIconBuilder", "createGutterIconRenderer"));
        }
        this.checkBuilt();
        NotNullLazyValue<List<SmartPsiElementPointer>> pointers = NavigationGutterIconBuilder.createPointersThunk(this.myLazy, project, NavigationGutterIconBuilder.evaluateAndForget(this.myTargets), this.myConverter);
        boolean empty = this.isEmpty();
        if (this.myTooltipText == null && !this.myLazy) {
            TreeSet<String> names = new TreeSet<String>();
            for (Object t : (Collection)this.myTargets.getValue()) {
                String text = (String)this.myNamer.fun(t);
                if (text == null) continue;
                names.add(MessageFormat.format(PATTERN, text));
            }
            StringBuilder sb = new StringBuilder("<html><body>");
            if (this.myTooltipTitle != null) {
                sb.append(this.myTooltipTitle).append("<br>");
            }
            for (String name : names) {
                sb.append(name).append("<br>");
            }
            sb.append("</body></html>");
            this.myTooltipText = sb.toString();
        }
        Computable<PsiElementListCellRenderer> renderer = this.myCellRenderer == null ? new Computable<PsiElementListCellRenderer>(){

            public PsiElementListCellRenderer compute() {
                return new DefaultPsiElementCellRenderer();
            }
        } : this.myCellRenderer;
        return new MyNavigationGutterIconRenderer(this, this.myAlignment, this.myIcon, this.myTooltipText, pointers, renderer, empty);
    }

    private static <T> NotNullLazyValue<List<SmartPsiElementPointer>> createPointersThunk(boolean lazy, final Project project, final Factory<Collection<T>> targets, final NotNullFunction<T, Collection<? extends PsiElement>> converter) {
        if (!lazy) {
            return NotNullLazyValue.createConstantValue(NavigationGutterIconBuilder.calcPsiTargets(project, (Collection)targets.create(), converter));
        }
        return new NotNullLazyValue<List<SmartPsiElementPointer>>(){

            @NotNull
            public List<SmartPsiElementPointer> compute() {
                List list = NavigationGutterIconBuilder.calcPsiTargets(project, (Collection)targets.create(), converter);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/navigation/NavigationGutterIconBuilder$8", "compute"));
                }
                return list;
            }
        };
    }

    private static <T> List<SmartPsiElementPointer> calcPsiTargets(Project project, Collection<? extends T> targets, NotNullFunction<T, Collection<? extends PsiElement>> converter) {
        SmartPointerManager manager = SmartPointerManager.getInstance((Project)project);
        THashSet elements = new THashSet();
        ArrayList<SmartPsiElementPointer> list = new ArrayList<SmartPsiElementPointer>(targets.size());
        for (T target : targets) {
            for (PsiElement psiElement : (Collection)converter.fun(target)) {
                if (!elements.add(psiElement) || !psiElement.isValid()) continue;
                list.add(manager.createSmartPsiElementPointer(psiElement));
            }
        }
        return list;
    }

    private boolean isEmpty() {
        if (this.myLazy) {
            return false;
        }
        THashSet elements = new THashSet();
        Collection targets = (Collection)this.myTargets.getValue();
        for (Object target : targets) {
            for (PsiElement psiElement : (Collection)this.myConverter.fun(target)) {
                if (!elements.add(psiElement)) continue;
                return false;
            }
        }
        return true;
    }

    private static class MyNavigationGutterIconRenderer
    extends NavigationGutterIconRenderer {
        private final GutterIconRenderer.Alignment myAlignment;
        private final Icon myIcon;
        private final String myTooltipText;
        private final boolean myEmpty;

        public MyNavigationGutterIconRenderer(@NotNull NavigationGutterIconBuilder builder, GutterIconRenderer.Alignment alignment, Icon icon, @Nullable String tooltipText, @NotNull NotNullLazyValue<List<SmartPsiElementPointer>> pointers, Computable<PsiElementListCellRenderer> cellRenderer, boolean empty) {
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/codeInsight/navigation/NavigationGutterIconBuilder$MyNavigationGutterIconRenderer", "<init>"));
            }
            if (pointers == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointers", "com/intellij/codeInsight/navigation/NavigationGutterIconBuilder$MyNavigationGutterIconRenderer", "<init>"));
            }
            super(builder.myPopupTitle, builder.myEmptyText, cellRenderer, pointers);
            this.myAlignment = alignment;
            this.myIcon = icon;
            this.myTooltipText = tooltipText;
            this.myEmpty = empty;
        }

        @Override
        public boolean isNavigateAction() {
            return !this.myEmpty;
        }

        @NotNull
        public Icon getIcon() {
            Icon icon = this.myIcon;
            if (icon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/navigation/NavigationGutterIconBuilder$MyNavigationGutterIconRenderer", "getIcon"));
            }
            return icon;
        }

        @Nullable
        public String getTooltipText() {
            return this.myTooltipText;
        }

        public GutterIconRenderer.Alignment getAlignment() {
            return this.myAlignment;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!super.equals(o)) {
                return false;
            }
            MyNavigationGutterIconRenderer that = (MyNavigationGutterIconRenderer)((Object)o);
            if (this.myAlignment != that.myAlignment) {
                return false;
            }
            if (this.myIcon != null ? !this.myIcon.equals(that.myIcon) : that.myIcon != null) {
                return false;
            }
            return !(this.myTooltipText != null ? !this.myTooltipText.equals(that.myTooltipText) : that.myTooltipText != null);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.myAlignment != null ? this.myAlignment.hashCode() : 0);
            result = 31 * result + (this.myIcon != null ? this.myIcon.hashCode() : 0);
            result = 31 * result + (this.myTooltipText != null ? this.myTooltipText.hashCode() : 0);
            return result;
        }
    }
}

