/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.util;

import com.intellij.codeInsight.CodeInsightServicesUtil;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplatePsiInfo;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.introduceVariable.IntroduceVariableBase;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaPostfixTemplatesUtils {
    public static final PostfixTemplatePsiInfo JAVA_PSI_INFO = new PostfixTemplatePsiInfo(){

        @Override
        @NotNull
        public PsiElement createStatement(@NotNull PsiElement context, @NotNull String prefix, @NotNull String suffix) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/template/postfix/util/JavaPostfixTemplatesUtils$1", "createStatement"));
            }
            if (prefix == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/codeInsight/template/postfix/util/JavaPostfixTemplatesUtils$1", "createStatement"));
            }
            if (suffix == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffix", "com/intellij/codeInsight/template/postfix/util/JavaPostfixTemplatesUtils$1", "createStatement"));
            }
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)context.getProject()).getElementFactory();
            PsiStatement psiStatement = factory.createStatementFromText(prefix + context.getText() + suffix, context);
            if (psiStatement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/util/JavaPostfixTemplatesUtils$1", "createStatement"));
            }
            return psiStatement;
        }

        @Override
        @NotNull
        public PsiElement createExpression(@NotNull PsiElement context, @NotNull String prefix, @NotNull String suffix) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/template/postfix/util/JavaPostfixTemplatesUtils$1", "createExpression"));
            }
            if (prefix == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/codeInsight/template/postfix/util/JavaPostfixTemplatesUtils$1", "createExpression"));
            }
            if (suffix == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffix", "com/intellij/codeInsight/template/postfix/util/JavaPostfixTemplatesUtils$1", "createExpression"));
            }
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)context.getProject()).getElementFactory();
            PsiExpression psiExpression = factory.createExpressionFromText(prefix + context.getText() + suffix, context);
            if (psiExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/util/JavaPostfixTemplatesUtils$1", "createExpression"));
            }
            return psiExpression;
        }

        @Nullable
        public PsiExpression getTopmostExpression(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/template/postfix/util/JavaPostfixTemplatesUtils$1", "getTopmostExpression"));
            }
            return JavaPostfixTemplatesUtils.getTopmostExpression(element);
        }

        @NotNull
        public PsiExpression getNegatedExpression(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/template/postfix/util/JavaPostfixTemplatesUtils$1", "getNegatedExpression"));
            }
            assert (element instanceof PsiExpression);
            PsiExpression psiExpression = CodeInsightServicesUtil.invertCondition((PsiExpression)((PsiExpression)element));
            if (psiExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/util/JavaPostfixTemplatesUtils$1", "getNegatedExpression"));
            }
            return psiExpression;
        }

        @Override
        @NotNull
        public List<PsiElement> getExpressions(@NotNull PsiElement context, @NotNull Document document, int newOffset) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/template/postfix/util/JavaPostfixTemplatesUtils$1", "getExpressions"));
            }
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/template/postfix/util/JavaPostfixTemplatesUtils$1", "getExpressions"));
            }
            ArrayList arrayList = ContainerUtil.newArrayList(IntroduceVariableBase.collectExpressions(context.getContainingFile(), document, Math.max(newOffset - 1, 0), false));
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/util/JavaPostfixTemplatesUtils$1", "getExpressions"));
            }
            return arrayList;
        }

        @Override
        @NotNull
        public Function<PsiElement, String> getRenderer() {
            Function<PsiElement, String> function = new Function<PsiElement, String>(){

                public String fun(PsiElement element) {
                    assert (element instanceof PsiExpression);
                    return new PsiExpressionTrimRenderer.RenderFunction().fun((PsiExpression)element);
                }
            };
            if (function == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/util/JavaPostfixTemplatesUtils$1", "getRenderer"));
            }
            return function;
        }
    };
    public static Condition<PsiElement> IS_NUMBER = new Condition<PsiElement>(){

        public boolean value(PsiElement element) {
            return element instanceof PsiExpression && JavaPostfixTemplatesUtils.isNumber(((PsiExpression)element).getType());
        }
    };
    public static Condition<PsiElement> IS_BOOLEAN = new Condition<PsiElement>(){

        public boolean value(PsiElement element) {
            return element instanceof PsiExpression && JavaPostfixTemplatesUtils.isBoolean(((PsiExpression)element).getType());
        }
    };
    public static Condition<PsiElement> IS_THROWABLE = new Condition<PsiElement>(){

        public boolean value(PsiElement element) {
            return element instanceof PsiExpression && JavaPostfixTemplatesUtils.isThrowable(((PsiExpression)element).getType());
        }
    };
    public static Condition<PsiElement> IS_NON_VOID = new Condition<PsiElement>(){

        public boolean value(PsiElement element) {
            return element instanceof PsiExpression && JavaPostfixTemplatesUtils.isNonVoid(((PsiExpression)element).getType());
        }
    };
    public static Condition<PsiElement> IS_NOT_PRIMITIVE = new Condition<PsiElement>(){

        public boolean value(PsiElement element) {
            return element instanceof PsiExpression && JavaPostfixTemplatesUtils.isNotPrimitiveTypeExpression((PsiExpression)element);
        }
    };
    public static Condition<PsiElement> IS_ITERABLE_OR_ARRAY = new Condition<PsiElement>(){

        public boolean value(PsiElement element) {
            if (!(element instanceof PsiExpression)) {
                return false;
            }
            PsiType type = ((PsiExpression)element).getType();
            return JavaPostfixTemplatesUtils.isArray(type) || JavaPostfixTemplatesUtils.isIterable(type);
        }
    };

    private JavaPostfixTemplatesUtils() {
    }

    @Contract(value="null -> false")
    public static boolean isNotPrimitiveTypeExpression(@Nullable PsiExpression expression) {
        if (expression == null) {
            return false;
        }
        PsiType type = expression.getType();
        return type != null && !(type instanceof PsiPrimitiveType);
    }

    @Contract(value="null -> false")
    public static boolean isIterable(@Nullable PsiType type) {
        return type != null && InheritanceUtil.isInheritor((PsiType)type, (String)"java.lang.Iterable");
    }

    @Contract(value="null -> false")
    public static boolean isThrowable(@Nullable PsiType type) {
        return type != null && InheritanceUtil.isInheritor((PsiType)type, (String)"java.lang.Throwable");
    }

    @Contract(value="null -> false")
    public static boolean isArray(@Nullable PsiType type) {
        return type != null && type instanceof PsiArrayType;
    }

    @Contract(value="null -> false")
    public static boolean isBoolean(@Nullable PsiType type) {
        return type != null && (PsiType.BOOLEAN.equals((Object)type) || PsiType.BOOLEAN.equals((Object)PsiPrimitiveType.getUnboxedType((PsiType)type)));
    }

    @Contract(value="null -> false")
    public static boolean isNonVoid(@Nullable PsiType type) {
        return type != null && !PsiType.VOID.equals((Object)type);
    }

    @Contract(value="null -> false")
    public static boolean isNumber(@Nullable PsiType type) {
        if (type == null) {
            return false;
        }
        if (PsiType.INT.equals((Object)type) || PsiType.BYTE.equals((Object)type) || PsiType.LONG.equals((Object)type)) {
            return true;
        }
        PsiPrimitiveType unboxedType = PsiPrimitiveType.getUnboxedType((PsiType)type);
        return PsiType.INT.equals((Object)unboxedType) || PsiType.BYTE.equals((Object)unboxedType) || PsiType.LONG.equals((Object)unboxedType);
    }

    @Nullable
    public static PsiExpression getTopmostExpression(PsiElement context) {
        PsiExpressionStatement statement = (PsiExpressionStatement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{PsiExpressionStatement.class});
        return statement != null ? statement.getExpression() : null;
    }
}

