/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.Value;

interface Direction {
    public static final Direction Out = new Direction(){

        public String toString() {
            return "Out";
        }

        public int hashCode() {
            return -1;
        }
    };
    public static final Direction NullableOut = new Direction(){

        public String toString() {
            return "NullableOut";
        }

        public int hashCode() {
            return -2;
        }
    };

    public static final class InOut
    implements Direction {
        final int paramIndex;
        final Value inValue;

        InOut(int paramIndex, Value inValue) {
            this.paramIndex = paramIndex;
            this.inValue = inValue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InOut inOut = (InOut)o;
            if (this.paramIndex != inOut.paramIndex) {
                return false;
            }
            return this.inValue == inOut.inValue;
        }

        public int hashCode() {
            int result = this.paramIndex;
            result = 31 * result + this.inValue.ordinal();
            return result;
        }

        public String toString() {
            return "InOut " + this.paramIndex + " " + this.inValue.toString();
        }

        public int paramId() {
            return this.paramIndex;
        }

        public int valueId() {
            return this.inValue.ordinal();
        }
    }

    public static final class In
    implements Direction {
        static final int NOT_NULL = 0;
        static final int NULLABLE = 1;
        final int paramIndex;
        final int nullityMask;

        In(int paramIndex, int nullityMask) {
            this.paramIndex = paramIndex;
            this.nullityMask = nullityMask;
        }

        public String toString() {
            return "In " + this.paramIndex;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            In in = (In)o;
            if (this.paramIndex != in.paramIndex) {
                return false;
            }
            return this.nullityMask == in.nullityMask;
        }

        public int hashCode() {
            return 31 * this.paramIndex + this.nullityMask;
        }

        public int paramId() {
            return this.paramIndex;
        }
    }
}

