/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.google.common.base.CharMatcher;
import com.intellij.codeInsight.navigation.IncrementalSearchHandler;
import com.intellij.codeInsight.template.impl.editorActions.TypedActionHandlerBase;
import com.intellij.execution.ConsoleFolding;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.actions.ConsoleActionsPostProcessor;
import com.intellij.execution.filters.CompositeFilter;
import com.intellij.execution.filters.CompositeInputFilter;
import com.intellij.execution.filters.ConsoleDependentFilterProvider;
import com.intellij.execution.filters.ConsoleFilterProvider;
import com.intellij.execution.filters.ConsoleFilterProviderEx;
import com.intellij.execution.filters.ConsoleInputFilterProvider;
import com.intellij.execution.filters.FileHyperlinkInfo;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.FilterMixin;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.HyperlinkInfoBase;
import com.intellij.execution.filters.HyperlinkWithPopupMenuInfo;
import com.intellij.execution.filters.InputFilter;
import com.intellij.execution.impl.ConsoleBuffer;
import com.intellij.execution.impl.ConsoleState;
import com.intellij.execution.impl.ConsoleUtil;
import com.intellij.execution.impl.ConsoleViewRunningState;
import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.execution.impl.DisposedPsiManagerCheck;
import com.intellij.execution.impl.EditorHyperlinkSupport;
import com.intellij.execution.impl.MyDiffContainer;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ObservableConsoleView;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.DocCommandGroupId;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.TypedAction;
import com.intellij.openapi.editor.actionSystem.TypedActionHandler;
import com.intellij.openapi.editor.actions.ScrollToTheEndToolbarAction;
import com.intellij.openapi.editor.actions.ToggleUseSoftWrapsToolbarAction;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterClient;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapAppliancePlaces;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.EditorPopupHandler;
import com.intellij.util.SystemProperties;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.ui.UIUtil;
import gnu.trove.TIntObjectHashMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConsoleViewImpl
extends JPanel
implements ConsoleView,
ObservableConsoleView,
DataProvider,
OccurenceNavigator {
    @NonNls
    private static final String CONSOLE_VIEW_POPUP_MENU = "ConsoleView.PopupMenu";
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.impl.ConsoleViewImpl");
    private static final int DEFAULT_FLUSH_DELAY = SystemProperties.getIntProperty((String)"console.flush.delay.ms", (int)200);
    private static final CharMatcher NEW_LINE_MATCHER = CharMatcher.anyOf((CharSequence)"\n\r");
    public static final Key<ConsoleViewImpl> CONSOLE_VIEW_IN_EDITOR_VIEW = Key.create((String)"CONSOLE_VIEW_IN_EDITOR_VIEW");
    private final CommandLineFolding myCommandLineFolding;
    private final DisposedPsiManagerCheck myPsiDisposedCheck;
    private final boolean myIsViewer;
    private ConsoleState myState;
    private final Alarm mySpareTimeAlarm;
    @Nullable
    private final Alarm myHeavyAlarm;
    private int myHeavyUpdateTicket;
    private final Collection<ObservableConsoleView.ChangeListener> myListeners;
    private final List<AnAction> customActions;
    private final ConsoleBuffer myBuffer;
    private boolean myUpdateFoldingsEnabled;
    private EditorHyperlinkSupport myHyperlinks;
    private MyDiffContainer myJLayeredPane;
    private JPanel myMainPanel;
    private final Runnable myFinishProgress;
    private boolean myAllowHeavyFilters;
    private static final int myFlushDelay;
    private boolean myTooMuchOfOutput;
    private boolean myInDocumentUpdate;
    private boolean myDocumentClearing;
    private int myLastAddedTextLength;
    private int consoleTooMuchTextBufferRatio;
    private final Project myProject;
    private boolean myOutputPaused;
    private EditorEx myEditor;
    private final Object LOCK;
    private int myContentSize;
    private final List<TokenInfo> myTokens;
    private final TIntObjectHashMap<ConsoleFolding> myFolding;
    private String myHelpId;
    private final Alarm myFlushUserInputAlarm;
    private final Alarm myFlushAlarm;
    private final Set<MyFlushRunnable> myCurrentRequests;
    protected final CompositeFilter myFilters;
    @Nullable
    private final InputFilter myInputMessageFilter;
    private final Alarm myFoldingAlarm;
    private final List<FoldRegion> myPendingFoldRegions;

    public Editor getEditor() {
        return this.myEditor;
    }

    public EditorHyperlinkSupport getHyperlinks() {
        return this.myHyperlinks;
    }

    public void scrollToEnd() {
        if (this.myEditor == null) {
            return;
        }
        this.myEditor.getCaretModel().moveToOffset(this.myEditor.getDocument().getTextLength());
    }

    public void foldImmediately() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!this.myFlushAlarm.isEmpty()) {
            this.cancelAllFlushRequests();
            new MyFlushRunnable().run();
        }
        this.myFoldingAlarm.cancelAllRequests();
        this.myPendingFoldRegions.clear();
        final FoldingModelEx model = this.myEditor.getFoldingModel();
        model.runBatchFoldingOperation(new Runnable(){

            @Override
            public void run() {
                for (FoldRegion region : model.getAllFoldRegions()) {
                    model.removeFoldRegion(region);
                }
            }
        });
        this.myFolding.clear();
        this.updateFoldings(0, this.myEditor.getDocument().getLineCount() - 1, true);
    }

    public ConsoleViewImpl(Project project, boolean viewer) {
        this(project, GlobalSearchScope.allScope((Project)project), viewer, true);
    }

    public ConsoleViewImpl(@NotNull Project project, @NotNull GlobalSearchScope searchScope, boolean viewer, boolean usePredefinedMessageFilter) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/impl/ConsoleViewImpl", "<init>"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/execution/impl/ConsoleViewImpl", "<init>"));
        }
        this(project, searchScope, viewer, new ConsoleState.NotStartedStated(){

            @Override
            public ConsoleState attachTo(ConsoleViewImpl console, ProcessHandler processHandler) {
                return new ConsoleViewRunningState(console, processHandler, this, true, true);
            }
        }, usePredefinedMessageFilter);
    }

    protected ConsoleViewImpl(@NotNull Project project, @NotNull GlobalSearchScope searchScope, boolean viewer, @NotNull ConsoleState initialState, boolean usePredefinedMessageFilter) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/impl/ConsoleViewImpl", "<init>"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/execution/impl/ConsoleViewImpl", "<init>"));
        }
        if (initialState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialState", "com/intellij/execution/impl/ConsoleViewImpl", "<init>"));
        }
        super(new BorderLayout());
        this.myCommandLineFolding = new CommandLineFolding();
        this.mySpareTimeAlarm = new Alarm((Disposable)this);
        this.myListeners = new CopyOnWriteArraySet<ObservableConsoleView.ChangeListener>();
        this.customActions = new ArrayList<AnAction>();
        this.myBuffer = new ConsoleBuffer();
        this.myUpdateFoldingsEnabled = true;
        this.myAllowHeavyFilters = false;
        this.LOCK = new Object();
        this.myTokens = new ArrayList<TokenInfo>();
        this.myFolding = new TIntObjectHashMap();
        this.myFlushUserInputAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        this.myFlushAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this);
        this.myCurrentRequests = new HashSet<MyFlushRunnable>();
        this.myFoldingAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this);
        this.myPendingFoldRegions = new ArrayList<FoldRegion>();
        this.myIsViewer = viewer;
        this.myState = initialState;
        this.myPsiDisposedCheck = new DisposedPsiManagerCheck(project);
        this.myProject = project;
        this.myFilters = new CompositeFilter(project);
        if (usePredefinedMessageFilter) {
            for (ConsoleFilterProvider eachProvider : (ConsoleFilterProvider[])Extensions.getExtensions((ExtensionPointName)ConsoleFilterProvider.FILTER_PROVIDERS)) {
                Filter[] filters = eachProvider instanceof ConsoleDependentFilterProvider ? ((ConsoleDependentFilterProvider)eachProvider).getDefaultFilters((ConsoleView)this, project, searchScope) : (eachProvider instanceof ConsoleFilterProviderEx ? ((ConsoleFilterProviderEx)eachProvider).getDefaultFilters(project, searchScope) : eachProvider.getDefaultFilters(project));
                for (Filter filter : filters) {
                    this.myFilters.addFilter(filter);
                }
            }
        }
        this.myFilters.setForceUseAllFilters(true);
        this.myHeavyUpdateTicket = 0;
        this.myHeavyAlarm = this.myFilters.isAnyHeavy() ? new Alarm(Alarm.ThreadToUse.SHARED_THREAD, (Disposable)this) : null;
        ConsoleInputFilterProvider[] inputFilters = (ConsoleInputFilterProvider[])Extensions.getExtensions((ExtensionPointName)ConsoleInputFilterProvider.INPUT_FILTER_PROVIDERS);
        if (inputFilters.length > 0) {
            CompositeInputFilter compositeInputFilter = new CompositeInputFilter(project);
            this.myInputMessageFilter = compositeInputFilter;
            for (ConsoleInputFilterProvider eachProvider : inputFilters) {
                InputFilter[] filters;
                for (InputFilter filter : filters = eachProvider.getDefaultFilters(project)) {
                    compositeInputFilter.addFilter(filter);
                }
            }
        } else {
            this.myInputMessageFilter = null;
        }
        this.myFinishProgress = new Runnable(){

            @Override
            public void run() {
                ConsoleViewImpl.this.myJLayeredPane.finishUpdating();
            }
        };
        this.consoleTooMuchTextBufferRatio = Registry.intValue((String)"console.too.much.text.buffer.ratio");
    }

    public void attachToProcess(ProcessHandler processHandler) {
        this.myState = this.myState.attachTo(this, processHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (this.myEditor == null) {
            return;
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.myContentSize = 0;
            this.myBuffer.clear();
            this.myFolding.clear();
        }
        if (this.myFlushAlarm.isDisposed()) {
            return;
        }
        this.cancelAllFlushRequests();
        this.addFlushRequest(new MyClearRunnable());
        this.cancelHeavyAlarm();
    }

    public void scrollTo(final int offset) {
        if (this.myEditor == null || this.myFlushAlarm.isDisposed()) {
            return;
        }
        class ScrollRunnable
        extends MyFlushRunnable {
            private final int myOffset;

            ScrollRunnable() {
                this.myOffset = offset;
            }

            @Override
            public void doRun() {
                ConsoleViewImpl.this.flushDeferredText();
                if (ConsoleViewImpl.this.myEditor == null) {
                    return;
                }
                int moveOffset = Math.min(offset, ConsoleViewImpl.this.myEditor.getDocument().getTextLength());
                if (ConsoleViewImpl.this.myBuffer.isUseCyclicBuffer() && moveOffset >= ConsoleViewImpl.this.myEditor.getDocument().getTextLength()) {
                    moveOffset = 0;
                }
                ConsoleViewImpl.this.myEditor.getCaretModel().moveToOffset(moveOffset);
                ConsoleViewImpl.this.myEditor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
            }

            @Override
            public boolean equals(Object o) {
                return super.equals(o) && this.myOffset == ((ScrollRunnable)o).myOffset;
            }
        }
        this.addFlushRequest(new ScrollRunnable());
    }

    public void requestScrollingToEnd() {
        if (this.myEditor == null || this.myFlushAlarm.isDisposed()) {
            return;
        }
        this.addFlushRequest(new MyFlushRunnable(){

            @Override
            public void doRun() {
                ConsoleViewImpl.this.flushDeferredText();
                if (ConsoleViewImpl.this.myEditor == null || ConsoleViewImpl.this.myFlushAlarm.isDisposed()) {
                    return;
                }
                ConsoleViewImpl.this.myEditor.getCaretModel().moveToOffset(ConsoleViewImpl.this.myEditor.getDocument().getTextLength());
                ConsoleViewImpl.this.myEditor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
            }
        });
    }

    private void addFlushRequest(MyFlushRunnable scrollRunnable) {
        this.addFlushRequest(scrollRunnable, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFlushRequest(MyFlushRunnable flushRunnable, int millis) {
        Set<MyFlushRunnable> set = this.myCurrentRequests;
        synchronized (set) {
            if (!this.myFlushAlarm.isDisposed() && this.myCurrentRequests.add(flushRunnable)) {
                this.myFlushAlarm.addRequest((Runnable)flushRunnable, millis, ConsoleViewImpl.getStateForUpdate());
            }
        }
    }

    private static void assertIsDispatchThread() {
        ApplicationManager.getApplication().assertIsDispatchThread();
    }

    public void setOutputPaused(boolean value) {
        this.myOutputPaused = value;
        if (!value) {
            this.requestFlushImmediately();
        }
    }

    public boolean isOutputPaused() {
        return this.myOutputPaused;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasDeferredOutput() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.myBuffer.getLength() > 0;
        }
    }

    public void performWhenNoDeferredOutput(Runnable runnable) {
        if (!this.hasDeferredOutput()) {
            runnable.run();
        } else {
            this.performLaterWhenNoDeferredOutput(runnable);
        }
    }

    private void performLaterWhenNoDeferredOutput(final Runnable runnable) {
        if (this.mySpareTimeAlarm.isDisposed()) {
            return;
        }
        this.mySpareTimeAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                ConsoleViewImpl.this.performWhenNoDeferredOutput(runnable);
            }
        }, 100, ModalityState.stateForComponent((Component)((Object)this.myJLayeredPane)));
    }

    public JComponent getComponent() {
        if (this.myMainPanel == null) {
            this.myMainPanel = new JPanel(new BorderLayout());
            this.myJLayeredPane = new MyDiffContainer(this.myMainPanel, this.myFilters.getUpdateMessage());
            Disposer.register((Disposable)this, (Disposable)this.myJLayeredPane);
            this.add((Component)((Object)this.myJLayeredPane), "Center");
        }
        if (this.myEditor == null) {
            this.myEditor = this.createEditor();
            this.registerConsoleEditorActions();
            this.myEditor.getScrollPane().setBorder(null);
            this.myHyperlinks = new EditorHyperlinkSupport(this.myEditor, this.myProject);
            this.requestFlushImmediately();
            this.myMainPanel.add((Component)this.createCenterComponent(), "Center");
            this.myEditor.getScrollingModel().addVisibleAreaListener(new VisibleAreaListener(){

                public void visibleAreaChanged(VisibleAreaEvent e) {
                    Rectangle oldRectangle = e.getOldRectangle();
                    if (oldRectangle == null) {
                        return;
                    }
                    Editor myEditor = e.getEditor();
                    if (oldRectangle.height <= 0 && e.getNewRectangle().height > 0 && myEditor.getSoftWrapModel().isSoftWrappingEnabled() && myEditor.getCaretModel().getOffset() == myEditor.getDocument().getTextLength()) {
                        EditorUtil.scrollToTheEnd(myEditor);
                    }
                }
            });
        }
        return this;
    }

    protected JComponent createCenterComponent() {
        return this.myEditor.getComponent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.myState = this.myState.dispose();
        if (this.myEditor != null) {
            this.cancelAllFlushRequests();
            this.mySpareTimeAlarm.cancelAllRequests();
            this.disposeEditor();
            Object object = this.LOCK;
            synchronized (object) {
                this.myBuffer.clear();
            }
            this.myEditor = null;
            this.myHyperlinks = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelAllFlushRequests() {
        Set<MyFlushRunnable> set = this.myCurrentRequests;
        synchronized (set) {
            for (MyFlushRunnable request : this.myCurrentRequests) {
                request.invalidate();
            }
            this.myCurrentRequests.clear();
            this.myFlushAlarm.cancelAllRequests();
        }
    }

    protected void disposeEditor() {
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!ConsoleViewImpl.this.myEditor.isDisposed()) {
                    EditorFactory.getInstance().releaseEditor((Editor)ConsoleViewImpl.this.myEditor);
                }
            }
        });
    }

    public void print(@NotNull String s, @NotNull ConsoleViewContentType contentType) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/execution/impl/ConsoleViewImpl", "print"));
        }
        if (contentType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentType", "com/intellij/execution/impl/ConsoleViewImpl", "print"));
        }
        if (this.myInputMessageFilter == null) {
            this.printHyperlink(s, contentType, null);
            return;
        }
        List result = this.myInputMessageFilter.applyFilter(s, contentType);
        if (result == null) {
            this.printHyperlink(s, contentType, null);
        } else {
            for (Pair pair : result) {
                if (pair.first == null) continue;
                this.printHyperlink((String)pair.first, pair.second == null ? contentType : (ConsoleViewContentType)pair.second, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printHyperlink(@NotNull String s, @NotNull ConsoleViewContentType contentType, @Nullable HyperlinkInfo info) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/execution/impl/ConsoleViewImpl", "printHyperlink"));
        }
        if (contentType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentType", "com/intellij/execution/impl/ConsoleViewImpl", "printHyperlink"));
        }
        Object object = this.LOCK;
        synchronized (object) {
            Pair<String, Integer> pair = this.myBuffer.print(s, contentType, info);
            s = (String)pair.first;
            this.myContentSize += s.length() - (Integer)pair.second;
            if (contentType == ConsoleViewContentType.USER_INPUT && NEW_LINE_MATCHER.indexIn((CharSequence)s) >= 0) {
                this.flushDeferredUserInput();
            }
            if (this.myEditor != null && !this.myFlushAlarm.isDisposed()) {
                boolean shouldFlushNow = this.myBuffer.isUseCyclicBuffer() && this.myBuffer.getLength() >= this.myBuffer.getCyclicBufferSize();
                this.addFlushRequest(new MyFlushRunnable(), shouldFlushNow ? 0 : myFlushDelay);
            }
        }
    }

    private void addToken(int length, @Nullable HyperlinkInfo info, ConsoleViewContentType contentType) {
        ConsoleUtil.addToken(length, info, contentType, this.myTokens);
    }

    private static ModalityState getStateForUpdate() {
        return null;
    }

    private void requestFlushImmediately() {
        if (this.myEditor != null && !this.myFlushAlarm.isDisposed()) {
            this.addFlushRequest(new MyFlushRunnable());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getContentSize() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.myContentSize;
        }
    }

    public boolean canPause() {
        return true;
    }

    public void flushDeferredText() {
        this.flushDeferredText(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushDeferredText(boolean clear) {
        int deferredTokensSize;
        Collection<ConsoleViewContentType> contentTypes;
        String addedText;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myProject.isDisposed()) {
            return;
        }
        EditorEx editor = this.myEditor;
        if (editor == null) {
            return;
        }
        if (clear) {
            final DocumentEx document = editor.getDocument();
            Object object = this.LOCK;
            synchronized (object) {
                this.myTokens.clear();
                this.clearHyperlinkAndFoldings();
            }
            final int documentTextLength = document.getTextLength();
            if (documentTextLength > 0) {
                CommandProcessor.getInstance().executeCommand(this.myProject, new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        document.setInBulkUpdate(true);
                        try {
                            ConsoleViewImpl.this.myInDocumentUpdate = true;
                            ConsoleViewImpl.this.myDocumentClearing = true;
                            document.deleteString(0, documentTextLength);
                        }
                        finally {
                            document.setInBulkUpdate(false);
                            ConsoleViewImpl.this.myDocumentClearing = false;
                            ConsoleViewImpl.this.myInDocumentUpdate = false;
                        }
                    }
                }, null, (Object)DocCommandGroupId.noneGroupId((Document)document));
            }
        }
        Object object = this.LOCK;
        synchronized (object) {
            if (this.myOutputPaused) {
                return;
            }
            if (this.myBuffer.isEmpty()) {
                return;
            }
            addedText = this.myBuffer.getText();
            contentTypes = Collections.unmodifiableCollection(new HashSet<ConsoleViewContentType>(this.myBuffer.getDeferredTokenTypes()));
            List<TokenInfo> deferredTokens = this.myBuffer.getDeferredTokens();
            for (TokenInfo deferredToken : deferredTokens) {
                this.addToken(deferredToken.getLength(), deferredToken.getHyperlinkInfo(), deferredToken.contentType);
            }
            deferredTokensSize = deferredTokens.size();
            this.myBuffer.clear(false);
            this.cancelHeavyAlarm();
        }
        final DocumentEx document = this.myEditor.getDocument();
        final RangeMarker lastProcessedOutput = document.createRangeMarker(document.getTextLength(), document.getTextLength());
        final int caretOffset = this.myEditor.getCaretModel().getOffset();
        boolean isAtLastLine = this.isCaretAtLastLine();
        CommandProcessor.getInstance().executeCommand(this.myProject, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean preserveCurrentVisualArea;
                boolean bl = preserveCurrentVisualArea = caretOffset < document.getTextLength();
                if (preserveCurrentVisualArea) {
                    ConsoleViewImpl.this.myEditor.getScrollingModel().accumulateViewportChanges();
                }
                try {
                    ConsoleViewImpl.this.myInDocumentUpdate = true;
                    String[] strings = addedText.split("\\r");
                    for (int i = 0; i < strings.length - 1; ++i) {
                        document.insertString(document.getTextLength(), (CharSequence)strings[i]);
                        int lastLine = document.getLineCount() - 1;
                        if (lastLine < 0) continue;
                        ConsoleUtil.updateTokensOnTextRemoval(ConsoleViewImpl.this.myTokens, document.getTextLength(), document.getTextLength() + 1);
                        document.deleteString(document.getLineStartOffset(lastLine), document.getTextLength());
                    }
                    if (strings.length > 0) {
                        document.insertString(document.getTextLength(), (CharSequence)strings[strings.length - 1]);
                        ConsoleViewImpl.this.myContentSize -= strings.length - 1;
                    }
                }
                finally {
                    ConsoleViewImpl.this.myInDocumentUpdate = false;
                    if (preserveCurrentVisualArea) {
                        ConsoleViewImpl.this.myEditor.getScrollingModel().flushViewportChanges();
                    }
                }
                if (!contentTypes.isEmpty()) {
                    for (ObservableConsoleView.ChangeListener each : ConsoleViewImpl.this.myListeners) {
                        each.contentAdded(contentTypes);
                    }
                }
            }
        }, null, (Object)DocCommandGroupId.noneGroupId((Document)document));
        Object object2 = this.LOCK;
        synchronized (object2) {
            for (int i = this.myTokens.size() - 1; i >= 0 && deferredTokensSize > 0; --i, --deferredTokensSize) {
                TokenInfo token = this.myTokens.get(i);
                HyperlinkInfo info = token.getHyperlinkInfo();
                if (info == null) continue;
                this.myHyperlinks.createHyperlink(token.startOffset, token.endOffset, null, info);
            }
        }
        this.myPsiDisposedCheck.performCheck();
        this.myLastAddedTextLength = addedText.length();
        if (!this.myTooMuchOfOutput) {
            if (this.isTheAmountOfTextTooBig(this.myLastAddedTextLength)) {
                this.myTooMuchOfOutput = true;
                final EditorNotificationPanel comp = new EditorNotificationPanel().text("Too much output to process").icon(AllIcons.General.ExclMark);
                final Alarm tooMuchOutputAlarm = new Alarm();
                tooMuchOutputAlarm.addRequest(new Runnable(){

                    @Override
                    public void run() {
                        ConsoleViewImpl.this.add((Component)comp, "North");
                    }
                }, 300);
                this.performWhenNoDeferredOutput(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (!ConsoleViewImpl.this.isTheAmountOfTextTooBig(ConsoleViewImpl.this.myLastAddedTextLength)) {
                            try {
                                ConsoleViewImpl.this.highlightHyperlinksAndFoldings(lastProcessedOutput);
                            }
                            finally {
                                ConsoleViewImpl.this.myTooMuchOfOutput = false;
                                ConsoleViewImpl.this.remove((Component)comp);
                                tooMuchOutputAlarm.cancelAllRequests();
                            }
                        } else {
                            ConsoleViewImpl.this.myLastAddedTextLength = 0;
                            ConsoleViewImpl.this.performLaterWhenNoDeferredOutput(this);
                        }
                    }
                });
            } else {
                this.highlightHyperlinksAndFoldings(lastProcessedOutput);
            }
        }
        if (isAtLastLine) {
            EditorUtil.scrollToTheEnd(this.myEditor);
        }
    }

    private boolean isTheAmountOfTextTooBig(int textLength) {
        return textLength > this.myBuffer.getCyclicBufferSize() / this.consoleTooMuchTextBufferRatio;
    }

    private void clearHyperlinkAndFoldings() {
        this.myEditor.getMarkupModel().removeAllHighlighters();
        this.myPendingFoldRegions.clear();
        this.myFolding.clear();
        this.myFoldingAlarm.cancelAllRequests();
        this.myEditor.getFoldingModel().runBatchFoldingOperation(new Runnable(){

            @Override
            public void run() {
                ConsoleViewImpl.this.myEditor.getFoldingModel().clearFoldRegions();
            }
        });
        this.cancelHeavyAlarm();
    }

    private void cancelHeavyAlarm() {
        if (this.myHeavyAlarm != null && !this.myHeavyAlarm.isDisposed()) {
            this.myHeavyAlarm.cancelAllRequests();
            ++this.myHeavyUpdateTicket;
        }
    }

    private void flushDeferredUserInput() {
        final String textToSend = this.myBuffer.cutFirstUserInputLine();
        if (textToSend == null) {
            return;
        }
        this.myFlushUserInputAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                if (ConsoleViewImpl.this.myState.isRunning()) {
                    try {
                        ConsoleViewImpl.this.myState.sendUserInput(textToSend);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }, 0);
    }

    public Object getData(String dataId) {
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            OpenFileDescriptor openFileDescriptor;
            if (this.myEditor == null) {
                return null;
            }
            LogicalPosition pos = this.myEditor.getCaretModel().getLogicalPosition();
            HyperlinkInfo info = this.myHyperlinks.getHyperlinkInfoByLineAndCol(pos.line, pos.column);
            OpenFileDescriptor openFileDescriptor2 = openFileDescriptor = info instanceof FileHyperlinkInfo ? ((FileHyperlinkInfo)info).getDescriptor() : null;
            if (openFileDescriptor == null || !openFileDescriptor.getFile().isValid()) {
                return null;
            }
            return openFileDescriptor;
        }
        if (CommonDataKeys.EDITOR.is(dataId)) {
            return this.myEditor;
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return this.myHelpId;
        }
        if (LangDataKeys.CONSOLE_VIEW.is(dataId)) {
            return this;
        }
        return null;
    }

    public void setHelpId(String helpId) {
        this.myHelpId = helpId;
    }

    public void setUpdateFoldingsEnabled(boolean updateFoldingsEnabled) {
        this.myUpdateFoldingsEnabled = updateFoldingsEnabled;
    }

    public void addMessageFilter(Filter filter) {
        this.myFilters.addFilter(filter);
    }

    public void printHyperlink(String hyperlinkText, HyperlinkInfo info) {
        this.printHyperlink(hyperlinkText, ConsoleViewContentType.NORMAL_OUTPUT, info);
    }

    private EditorEx createEditor() {
        return (EditorEx)ApplicationManager.getApplication().runReadAction((Computable)new Computable<EditorEx>(){

            public EditorEx compute() {
                EditorEx editor = ConsoleViewImpl.this.createRealEditor();
                editor.addEditorMouseListener((EditorMouseListener)new EditorPopupHandler(){

                    @Override
                    public void invokePopup(EditorMouseEvent event) {
                        ConsoleViewImpl.this.popupInvoked(event.getMouseEvent());
                    }
                });
                editor.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                    public void documentChanged(DocumentEvent event) {
                        ConsoleViewImpl.this.onDocumentChanged(event);
                    }
                }, (Disposable)ConsoleViewImpl.this);
                int bufferSize = ConsoleViewImpl.this.myBuffer.isUseCyclicBuffer() ? ConsoleViewImpl.this.myBuffer.getCyclicBufferSize() : 0;
                editor.getDocument().setCyclicBufferSize(bufferSize);
                editor.putUserData(CONSOLE_VIEW_IN_EDITOR_VIEW, ConsoleViewImpl.this);
                editor.getSettings().setAllowSingleLogicalLineFolding(true);
                editor.setHighlighter(ConsoleViewImpl.this.createHighlighter());
                return editor;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onDocumentChanged(DocumentEvent event) {
        if (event.getNewLength() == 0) {
            Object object = this.LOCK;
            synchronized (object) {
                ConsoleUtil.updateTokensOnTextRemoval(this.myTokens, event.getOffset(), event.getOffset() + event.getOldLength());
                int toRemoveLen = event.getOldLength();
                if (!this.myDocumentClearing) {
                    this.myContentSize -= Math.min(this.myContentSize, toRemoveLen);
                }
            }
        } else if (!this.myInDocumentUpdate) {
            int newFragmentLength = event.getNewFragment().length();
            if (event.getOldFragment().length() == 0 && newFragmentLength > 0) {
                Object object = this.LOCK;
                synchronized (object) {
                    this.myContentSize += newFragmentLength;
                    this.addToken(newFragmentLength, null, ConsoleViewContentType.NORMAL_OUTPUT);
                }
            } else {
                LOG.warn("unhandled external change: " + event);
            }
        }
    }

    protected EditorEx createRealEditor() {
        return ConsoleViewUtil.setupConsoleEditor(this.myProject, true, false);
    }

    protected MyHighlighter createHighlighter() {
        return new MyHighlighter();
    }

    private void registerConsoleEditorActions() {
        HyperlinkNavigationAction hyperlinkNavigationAction = new HyperlinkNavigationAction();
        hyperlinkNavigationAction.registerCustomShortcutSet(CommonShortcuts.ENTER, this.myEditor.getContentComponent());
        ConsoleViewImpl.registerActionHandler(this.myEditor, "GotoDeclaration", (AnAction)hyperlinkNavigationAction);
        if (!this.myIsViewer) {
            new EnterHandler().registerCustomShortcutSet(CommonShortcuts.ENTER, this.myEditor.getContentComponent());
            ConsoleViewImpl.registerActionHandler(this.myEditor, "EditorPaste", new PasteHandler());
            ConsoleViewImpl.registerActionHandler(this.myEditor, "EditorBackSpace", new BackSpaceHandler());
            ConsoleViewImpl.registerActionHandler(this.myEditor, "EditorDelete", new DeleteHandler());
            ConsoleViewImpl.registerActionHandler(this.myEditor, "SendEOF", ActionManager.getInstance().getAction("SendEOF"));
        }
    }

    private static void registerActionHandler(Editor editor, String actionId, AnAction action) {
        Keymap keymap = KeymapManager.getInstance().getActiveKeymap();
        Shortcut[] shortcuts = keymap.getShortcuts(actionId);
        action.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcuts), editor.getContentComponent());
    }

    private void popupInvoked(MouseEvent mouseEvent) {
        ActionManager actionManager = ActionManager.getInstance();
        HyperlinkInfo info = this.myHyperlinks != null ? this.myHyperlinks.getHyperlinkInfoByPoint(mouseEvent.getPoint()) : null;
        ActionGroup group = null;
        if (info instanceof HyperlinkWithPopupMenuInfo) {
            group = ((HyperlinkWithPopupMenuInfo)info).getPopupMenuGroup(mouseEvent);
        }
        if (group == null) {
            group = (ActionGroup)actionManager.getAction(CONSOLE_VIEW_POPUP_MENU);
        }
        ConsoleActionsPostProcessor[] postProcessors = (ConsoleActionsPostProcessor[])Extensions.getExtensions((ExtensionPointName)ConsoleActionsPostProcessor.EP_NAME);
        AnAction[] result = group.getChildren(null);
        for (ConsoleActionsPostProcessor postProcessor : postProcessors) {
            result = postProcessor.postProcessPopupActions((ConsoleView)this, result);
        }
        DefaultActionGroup processedGroup = new DefaultActionGroup(result);
        ActionPopupMenu menu = actionManager.createActionPopupMenu("EditorPopup", (ActionGroup)processedGroup);
        menu.getComponent().show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    private void highlightHyperlinksAndFoldings(RangeMarker lastProcessedOutput) {
        boolean canHighlightHyperlinks;
        boolean bl = canHighlightHyperlinks = !this.myFilters.isEmpty() || !this.myFilters.isEmpty();
        if (!canHighlightHyperlinks && this.myUpdateFoldingsEnabled) {
            return;
        }
        int line1 = lastProcessedOutput.isValid() ? this.myEditor.getDocument().getLineNumber(lastProcessedOutput.getEndOffset()) : 0;
        lastProcessedOutput.dispose();
        int endLine = this.myEditor.getDocument().getLineCount() - 1;
        ApplicationManager.getApplication().assertIsDispatchThread();
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        if (canHighlightHyperlinks) {
            this.myHyperlinks.highlightHyperlinks((Filter)this.myFilters, line1, endLine);
        }
        if (this.myAllowHeavyFilters && this.myFilters.isAnyHeavy() && this.myFilters.shouldRunHeavy()) {
            this.runHeavyFilters(line1, endLine);
        }
        if (this.myUpdateFoldingsEnabled) {
            this.updateFoldings(line1, endLine, true);
        }
    }

    private void runHeavyFilters(int line1, int endLine) {
        final int startLine = Math.max(0, line1);
        DocumentEx document = this.myEditor.getDocument();
        final int startOffset = document.getLineStartOffset(startLine);
        String text = document.getText(new TextRange(startOffset, document.getLineEndOffset(endLine)));
        final DocumentImpl documentCopy = new DocumentImpl(text, true);
        documentCopy.setReadOnly(true);
        this.myJLayeredPane.startUpdating();
        final int currentValue = this.myHeavyUpdateTicket;
        assert (this.myHeavyAlarm != null);
        this.myHeavyAlarm.addRequest(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (!ConsoleViewImpl.this.myFilters.shouldRunHeavy()) {
                    return;
                }
                try {
                    ConsoleViewImpl.this.myFilters.applyHeavyFilter(documentCopy, startOffset, startLine, (Consumer)new Consumer<FilterMixin.AdditionalHighlight>(){

                        public void consume(final FilterMixin.AdditionalHighlight additionalHighlight) {
                            if (ConsoleViewImpl.this.myFlushAlarm.isDisposed()) {
                                return;
                            }
                            ConsoleViewImpl.this.addFlushRequest(new MyFlushRunnable(){

                                @Override
                                public void doRun() {
                                    if (ConsoleViewImpl.this.myHeavyUpdateTicket != currentValue) {
                                        return;
                                    }
                                    ConsoleViewImpl.this.myHyperlinks.addHighlighter(additionalHighlight.getStart(), additionalHighlight.getEnd(), additionalHighlight.getTextAttributes(null));
                                }

                                @Override
                                public boolean equals(Object o) {
                                    return this == o && super.equals(o);
                                }
                            });
                        }
                    });
                }
                finally {
                    if (ConsoleViewImpl.this.myHeavyAlarm.isEmpty()) {
                        SwingUtilities.invokeLater(ConsoleViewImpl.this.myFinishProgress);
                    }
                }
            }
        }, 0);
    }

    private void updateFoldings(int line1, int endLine, boolean immediately) {
        DocumentEx document = this.myEditor.getDocument();
        CharSequence chars = document.getCharsSequence();
        int startLine = Math.max(0, line1);
        ArrayList<FoldRegion> toAdd = new ArrayList<FoldRegion>();
        for (int line = startLine; line <= endLine; ++line) {
            this.addFolding(document, chars, line, toAdd);
        }
        if (!toAdd.isEmpty()) {
            this.doUpdateFolding(toAdd, immediately);
        }
    }

    private void doUpdateFolding(List<FoldRegion> toAdd, final boolean immediately) {
        ConsoleViewImpl.assertIsDispatchThread();
        this.myPendingFoldRegions.addAll(toAdd);
        this.myFoldingAlarm.cancelAllRequests();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (ConsoleViewImpl.this.myEditor == null || ConsoleViewImpl.this.myEditor.isDisposed()) {
                    return;
                }
                ConsoleViewImpl.assertIsDispatchThread();
                final FoldingModelEx model = ConsoleViewImpl.this.myEditor.getFoldingModel();
                Runnable operation = new Runnable(){

                    @Override
                    public void run() {
                        ConsoleViewImpl.assertIsDispatchThread();
                        for (FoldRegion region : ConsoleViewImpl.this.myPendingFoldRegions) {
                            region.setExpanded(false);
                            model.addFoldRegion(region);
                        }
                        ConsoleViewImpl.this.myPendingFoldRegions.clear();
                    }
                };
                if (immediately) {
                    model.runBatchFoldingOperation(operation);
                } else {
                    model.runBatchFoldingOperationDoNotCollapseCaret(operation);
                }
            }
        };
        if (immediately || this.myPendingFoldRegions.size() > 100) {
            runnable.run();
        } else {
            this.myFoldingAlarm.addRequest(runnable, 50);
        }
    }

    private boolean isCaretAtLastLine() {
        int caretOffset;
        DocumentEx document = this.myEditor.getDocument();
        return document.getLineNumber(caretOffset = this.myEditor.getCaretModel().getOffset()) >= document.getLineCount() - 1;
    }

    private void addFolding(Document document, CharSequence chars, int line, List<FoldRegion> toAdd) {
        String commandLinePlaceholder = this.myCommandLineFolding.getPlaceholder(line);
        if (commandLinePlaceholder != null) {
            FoldRegion region = this.myEditor.getFoldingModel().createFoldRegion(document.getLineStartOffset(line), document.getLineEndOffset(line), commandLinePlaceholder, null, false);
            toAdd.add(region);
            return;
        }
        ConsoleFolding current = ConsoleViewImpl.foldingForLine(EditorHyperlinkSupport.getLineText(document, line, false));
        if (current != null) {
            this.myFolding.put(line, (Object)current);
        }
        ConsoleFolding prevFolding = (ConsoleFolding)this.myFolding.get(line - 1);
        if (current == null && prevFolding != null) {
            FoldRegion region;
            int lEnd;
            int lStart = lEnd = line - 1;
            while (prevFolding.equals(this.myFolding.get(lStart - 1))) {
                --lStart;
            }
            for (int i = lStart; i <= lEnd; ++i) {
                this.myFolding.remove(i);
            }
            ArrayList<String> toFold = new ArrayList<String>(lEnd - lStart + 1);
            for (int i = lStart; i <= lEnd; ++i) {
                toFold.add(EditorHyperlinkSupport.getLineText(document, i, false));
            }
            int oStart = document.getLineStartOffset(lStart);
            if (oStart > 0) {
                --oStart;
            }
            int oEnd = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(document.getLineEndOffset(lEnd) - 1), (String)" \t") + 1;
            String placeholder = prevFolding.getPlaceholderText(toFold);
            FoldRegion foldRegion = region = placeholder == null ? null : this.myEditor.getFoldingModel().createFoldRegion(oStart, oEnd, placeholder, null, false);
            if (region != null) {
                toAdd.add(region);
            }
        }
    }

    @Nullable
    private static ConsoleFolding foldingForLine(String lineText) {
        for (ConsoleFolding folding : (ConsoleFolding[])ConsoleFolding.EP_NAME.getExtensions()) {
            if (!folding.shouldFoldLine(lineText)) continue;
            return folding;
        }
        return null;
    }

    public JComponent getPreferredFocusableComponent() {
        this.getComponent();
        return this.myEditor.getContentComponent();
    }

    public boolean hasNextOccurence() {
        return this.calcNextOccurrence(1) != null;
    }

    public boolean hasPreviousOccurence() {
        return this.calcNextOccurrence(-1) != null;
    }

    public OccurenceNavigator.OccurenceInfo goNextOccurence() {
        return this.calcNextOccurrence(1);
    }

    @Nullable
    protected OccurenceNavigator.OccurenceInfo calcNextOccurrence(int delta) {
        EditorHyperlinkSupport hyperlinks = this.myHyperlinks;
        if (hyperlinks == null) {
            return null;
        }
        return EditorHyperlinkSupport.getNextOccurrence(this.myEditor, delta, new Consumer<RangeHighlighter>(){

            public void consume(RangeHighlighter next) {
                int offset = next.getStartOffset();
                ConsoleViewImpl.this.scrollTo(offset);
                HyperlinkInfo hyperlinkInfo = EditorHyperlinkSupport.getHyperlinkInfo(next);
                if (hyperlinkInfo instanceof HyperlinkInfoBase) {
                    VisualPosition position = ConsoleViewImpl.this.myEditor.offsetToVisualPosition(offset);
                    Point point = ConsoleViewImpl.this.myEditor.visualPositionToXY(new VisualPosition(position.getLine() + 1, position.getColumn()));
                    ((HyperlinkInfoBase)hyperlinkInfo).navigate(ConsoleViewImpl.this.myProject, new RelativePoint((Component)ConsoleViewImpl.this.myEditor.getContentComponent(), point));
                } else if (hyperlinkInfo != null) {
                    hyperlinkInfo.navigate(ConsoleViewImpl.this.myProject);
                }
            }
        });
    }

    public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
        return this.calcNextOccurrence(-1);
    }

    public String getNextOccurenceActionName() {
        return ExecutionBundle.message((String)"down.the.stack.trace", (Object[])new Object[0]);
    }

    public String getPreviousOccurenceActionName() {
        return ExecutionBundle.message((String)"up.the.stack.trace", (Object[])new Object[0]);
    }

    public void addCustomConsoleAction(@NotNull AnAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/execution/impl/ConsoleViewImpl", "addCustomConsoleAction"));
        }
        this.customActions.add(action);
    }

    @NotNull
    public AnAction[] createConsoleActions() {
        CommonActionsManager actionsManager = CommonActionsManager.getInstance();
        AnAction prevAction = actionsManager.createPrevOccurenceAction((OccurenceNavigator)this);
        prevAction.getTemplatePresentation().setText(this.getPreviousOccurenceActionName());
        AnAction nextAction = actionsManager.createNextOccurenceAction((OccurenceNavigator)this);
        nextAction.getTemplatePresentation().setText(this.getNextOccurenceActionName());
        ToggleUseSoftWrapsToolbarAction switchSoftWrapsAction = new ToggleUseSoftWrapsToolbarAction(SoftWrapAppliancePlaces.CONSOLE){
            private boolean myLastIsSelected;

            @Override
            protected Editor getEditor(AnActionEvent e) {
                return ConsoleViewImpl.this.myEditor;
            }

            @Override
            public boolean isSelected(AnActionEvent e) {
                boolean result = super.isSelected(e);
                if (result ^ this.myLastIsSelected) {
                    this.setSelected(null, result);
                }
                this.myLastIsSelected = result;
                return this.myLastIsSelected;
            }

            @Override
            public void setSelected(AnActionEvent e, boolean state) {
                super.setSelected(e, state);
                if (ConsoleViewImpl.this.myEditor == null) {
                    return;
                }
                final String placeholder = ConsoleViewImpl.this.myCommandLineFolding.getPlaceholder(0);
                final FoldingModelEx foldingModel = ConsoleViewImpl.this.myEditor.getFoldingModel();
                final int firstLineEnd = ConsoleViewImpl.this.myEditor.getDocument().getLineEndOffset(0);
                foldingModel.runBatchFoldingOperation(new Runnable(){

                    @Override
                    public void run() {
                        FoldRegion foldRegion;
                        FoldRegion[] regions = foldingModel.getAllFoldRegions();
                        if (regions.length > 0 && regions[0].getStartOffset() == 0 && regions[0].getEndOffset() == firstLineEnd) {
                            foldingModel.removeFoldRegion(regions[0]);
                        }
                        if (placeholder != null && (foldRegion = foldingModel.addFoldRegion(0, firstLineEnd, placeholder)) != null) {
                            foldRegion.setExpanded(false);
                        }
                    }
                });
            }
        };
        ScrollToTheEndToolbarAction autoScrollToTheEndAction = new ScrollToTheEndToolbarAction(this.myEditor);
        AnAction[] consoleActions = new AnAction[6 + this.customActions.size()];
        consoleActions[0] = prevAction;
        consoleActions[1] = nextAction;
        consoleActions[2] = switchSoftWrapsAction;
        consoleActions[3] = autoScrollToTheEndAction;
        consoleActions[4] = ActionManager.getInstance().getAction("Print");
        consoleActions[5] = new ClearAllAction();
        for (int i = 0; i < this.customActions.size(); ++i) {
            consoleActions[i + 6] = this.customActions.get(i);
        }
        ConsoleActionsPostProcessor[] postProcessors = (ConsoleActionsPostProcessor[])Extensions.getExtensions((ExtensionPointName)ConsoleActionsPostProcessor.EP_NAME);
        AnAction[] result = consoleActions;
        for (ConsoleActionsPostProcessor postProcessor : postProcessors) {
            result = postProcessor.postProcess((ConsoleView)this, result);
        }
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/ConsoleViewImpl", "createConsoleActions"));
        }
        return result;
    }

    public void allowHeavyFilters() {
        this.myAllowHeavyFilters = true;
    }

    public void addChangeListener(final @NotNull ObservableConsoleView.ChangeListener listener, @NotNull Disposable parent) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/execution/impl/ConsoleViewImpl", "addChangeListener"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/execution/impl/ConsoleViewImpl", "addChangeListener"));
        }
        this.myListeners.add(listener);
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            public void dispose() {
                ConsoleViewImpl.this.myListeners.remove(listener);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertUserText(String s, int offset) {
        int startOffset;
        ApplicationManager.getApplication().assertIsDispatchThread();
        ConsoleViewImpl consoleView = this;
        ConsoleBuffer buffer = consoleView.myBuffer;
        EditorEx editor = consoleView.myEditor;
        Document document = editor.getDocument();
        String textToUse = StringUtil.convertLineSeparators((String)s);
        Object object = consoleView.LOCK;
        synchronized (object) {
            if (consoleView.myTokens.isEmpty()) {
                return;
            }
            TokenInfo info = consoleView.myTokens.get(consoleView.myTokens.size() - 1);
            if (info.contentType != ConsoleViewContentType.USER_INPUT && !StringUtil.containsChar((String)textToUse, (char)'\n')) {
                consoleView.print(textToUse, ConsoleViewContentType.USER_INPUT);
                consoleView.flushDeferredText();
                editor.getCaretModel().moveToOffset(document.getTextLength());
                editor.getSelectionModel().removeSelection();
                return;
            }
            if (info.contentType != ConsoleViewContentType.USER_INPUT) {
                this.insertUserText("temp", offset);
                TokenInfo newInfo = consoleView.myTokens.get(consoleView.myTokens.size() - 1);
                this.replaceUserText(textToUse, newInfo.startOffset, newInfo.endOffset);
                return;
            }
            int deferredOffset = this.myContentSize - buffer.getLength() - buffer.getUserInputLength();
            startOffset = offset > info.endOffset ? info.endOffset : Math.max(deferredOffset, Math.max(info.startOffset, offset));
            buffer.addUserText(startOffset - deferredOffset, textToUse);
            int charCountToAdd = textToUse.length();
            info.endOffset += charCountToAdd;
            consoleView.myContentSize += charCountToAdd;
        }
        try {
            this.myInDocumentUpdate = true;
            document.insertString(startOffset, (CharSequence)textToUse);
        }
        finally {
            this.myInDocumentUpdate = false;
        }
        editor.getCaretModel().moveToOffset(Math.min(startOffset + textToUse.length(), document.getTextLength()));
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceUserText(String s, int start, int end) {
        int endOffset;
        int startOffset;
        if (start == end) {
            this.insertUserText(s, start);
            return;
        }
        ConsoleViewImpl consoleView = this;
        ConsoleBuffer buffer = consoleView.myBuffer;
        EditorEx editor = consoleView.myEditor;
        Document document = editor.getDocument();
        Object object = consoleView.LOCK;
        synchronized (object) {
            if (consoleView.myTokens.isEmpty()) {
                return;
            }
            TokenInfo info = consoleView.myTokens.get(consoleView.myTokens.size() - 1);
            if (info.contentType != ConsoleViewContentType.USER_INPUT) {
                consoleView.print(s, ConsoleViewContentType.USER_INPUT);
                consoleView.flushDeferredText();
                editor.getCaretModel().moveToOffset(document.getTextLength());
                editor.getSelectionModel().removeSelection();
                return;
            }
            if (buffer.getUserInputLength() <= 0) {
                return;
            }
            int deferredOffset = this.myContentSize - buffer.getLength() - buffer.getUserInputLength();
            startOffset = ConsoleViewImpl.getStartOffset(start, info, deferredOffset);
            endOffset = ConsoleViewImpl.getEndOffset(end, info);
            if (startOffset == -1 || endOffset == -1 || endOffset <= startOffset) {
                editor.getSelectionModel().removeSelection();
                editor.getCaretModel().moveToOffset(start);
                return;
            }
            int charCountToReplace = s.length() - endOffset + startOffset;
            buffer.replaceUserText(startOffset - deferredOffset, endOffset - deferredOffset, s);
            info.endOffset += charCountToReplace;
            if (info.startOffset == info.endOffset) {
                consoleView.myTokens.remove(consoleView.myTokens.size() - 1);
            }
            consoleView.myContentSize += charCountToReplace;
        }
        try {
            this.myInDocumentUpdate = true;
            document.replaceString(startOffset, endOffset, (CharSequence)s);
        }
        finally {
            this.myInDocumentUpdate = false;
        }
        editor.getCaretModel().moveToOffset(startOffset + s.length());
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        editor.getSelectionModel().removeSelection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteUserText(int offset, int length) {
        int endOffset;
        int startOffset;
        ConsoleViewImpl consoleView = this;
        ConsoleBuffer buffer = consoleView.myBuffer;
        EditorEx editor = consoleView.myEditor;
        Document document = editor.getDocument();
        Object object = consoleView.LOCK;
        synchronized (object) {
            if (consoleView.myTokens.isEmpty()) {
                return;
            }
            TokenInfo info = consoleView.myTokens.get(consoleView.myTokens.size() - 1);
            if (info.contentType != ConsoleViewContentType.USER_INPUT) {
                return;
            }
            if (this.myBuffer.getUserInputLength() == 0) {
                return;
            }
            int deferredOffset = this.myContentSize - buffer.getLength() - buffer.getUserInputLength();
            startOffset = ConsoleViewImpl.getStartOffset(offset, info, deferredOffset);
            endOffset = ConsoleViewImpl.getEndOffset(offset + length, info);
            if (startOffset == -1 || endOffset == -1 || endOffset <= startOffset || startOffset < deferredOffset) {
                editor.getSelectionModel().removeSelection();
                editor.getCaretModel().moveToOffset(offset);
                return;
            }
            buffer.removeUserText(startOffset - deferredOffset, endOffset - deferredOffset);
        }
        try {
            this.myInDocumentUpdate = true;
            document.deleteString(startOffset, endOffset);
        }
        finally {
            this.myInDocumentUpdate = false;
        }
        editor.getCaretModel().moveToOffset(startOffset);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        editor.getSelectionModel().removeSelection();
    }

    private static int getStartOffset(int offset, TokenInfo info, int deferredOffset) {
        int startOffset = offset >= info.startOffset && offset < info.endOffset ? Math.max(offset, deferredOffset) : (offset < info.startOffset ? Math.max(info.startOffset, deferredOffset) : -1);
        return startOffset;
    }

    private static int getEndOffset(int offset, TokenInfo info) {
        int endOffset = offset > info.endOffset ? info.endOffset : (offset <= info.startOffset ? -1 : offset);
        return endOffset;
    }

    public boolean isRunning() {
        return this.myState.isRunning();
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/ConsoleViewImpl", "getProject"));
        }
        return project;
    }

    static {
        EditorActionManager actionManager = EditorActionManager.getInstance();
        TypedAction typedAction = actionManager.getTypedAction();
        typedAction.setupHandler((TypedActionHandler)new MyTypedHandler(typedAction.getHandler()));
        myFlushDelay = DEFAULT_FLUSH_DELAY;
    }

    private class HyperlinkNavigationAction
    extends DumbAwareAction {
        private HyperlinkNavigationAction() {
        }

        public void actionPerformed(AnActionEvent e) {
            Runnable runnable = ConsoleViewImpl.this.myHyperlinks.getLinkNavigationRunnable(ConsoleViewImpl.this.myEditor.getCaretModel().getLogicalPosition());
            assert (runnable != null);
            runnable.run();
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(ConsoleViewImpl.this.myHyperlinks.getLinkNavigationRunnable(ConsoleViewImpl.this.myEditor.getCaretModel().getLogicalPosition()) != null);
        }
    }

    private final class MyClearRunnable
    extends MyFlushRunnable {
        private MyClearRunnable() {
        }

        @Override
        public void doRun() {
            ConsoleViewImpl.this.flushDeferredText(true);
        }
    }

    private class MyFlushRunnable
    implements Runnable {
        private volatile boolean myValid = true;

        private MyFlushRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            Set set = ConsoleViewImpl.this.myCurrentRequests;
            synchronized (set) {
                ConsoleViewImpl.this.myCurrentRequests.remove(this);
            }
            if (this.myValid) {
                this.doRun();
            }
        }

        protected void doRun() {
            ConsoleViewImpl.this.flushDeferredText();
        }

        public void invalidate() {
            this.myValid = false;
        }

        public boolean isValid() {
            return this.myValid;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyFlushRunnable runnable = (MyFlushRunnable)o;
            return this.myValid == runnable.myValid;
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }

    private class CommandLineFolding
    extends ConsoleFolding {
        private CommandLineFolding() {
        }

        @Nullable
        public String getPlaceholder(int line) {
            int index;
            if (ConsoleViewImpl.this.myEditor == null || line != 0) {
                return null;
            }
            String text = EditorHyperlinkSupport.getLineText(ConsoleViewImpl.this.myEditor.getDocument(), 0, false);
            if (text.length() < 1000) {
                return null;
            }
            boolean nonWhiteSpaceFound = false;
            for (index = 0; index < text.length(); ++index) {
                char c = text.charAt(index);
                if (c != ' ' && c != '\t') {
                    nonWhiteSpaceFound = true;
                    continue;
                }
                if (nonWhiteSpaceFound) break;
            }
            assert (index <= text.length());
            return text.substring(0, index) + " ...";
        }

        @Override
        public boolean shouldFoldLine(String line) {
            return false;
        }

        @Override
        public String getPlaceholderText(List<String> lines) {
            return "<...>";
        }
    }

    private static class DeleteHandler
    extends ConsoleAction {
        private DeleteHandler() {
        }

        @Override
        public void execute(ConsoleViewImpl consoleView, DataContext context) {
            EditorEx editor = consoleView.myEditor;
            if (IncrementalSearchHandler.isHintVisible(editor)) {
                DeleteHandler.getDefaultActionHandler().execute((Editor)editor, context);
                return;
            }
            Document document = editor.getDocument();
            int length = document.getTextLength();
            if (length == 0) {
                return;
            }
            ApplicationManager.getApplication().assertIsDispatchThread();
            SelectionModel selectionModel = editor.getSelectionModel();
            if (selectionModel.hasSelection()) {
                consoleView.deleteUserText(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd() - selectionModel.getSelectionStart());
            } else {
                consoleView.deleteUserText(editor.getCaretModel().getOffset(), 1);
            }
        }

        private static EditorActionHandler getDefaultActionHandler() {
            return EditorActionManager.getInstance().getActionHandler("EditorBackSpace");
        }
    }

    private static class BackSpaceHandler
    extends ConsoleAction {
        private BackSpaceHandler() {
        }

        @Override
        public void execute(ConsoleViewImpl consoleView, DataContext context) {
            EditorEx editor = consoleView.myEditor;
            if (IncrementalSearchHandler.isHintVisible(editor)) {
                BackSpaceHandler.getDefaultActionHandler().execute((Editor)editor, context);
                return;
            }
            Document document = editor.getDocument();
            int length = document.getTextLength();
            if (length == 0) {
                return;
            }
            ApplicationManager.getApplication().assertIsDispatchThread();
            SelectionModel selectionModel = editor.getSelectionModel();
            if (selectionModel.hasSelection()) {
                consoleView.deleteUserText(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd() - selectionModel.getSelectionStart());
            } else if (editor.getCaretModel().getOffset() > 0) {
                consoleView.deleteUserText(editor.getCaretModel().getOffset() - 1, 1);
            }
        }

        private static EditorActionHandler getDefaultActionHandler() {
            return EditorActionManager.getInstance().getActionHandler("EditorBackSpace");
        }
    }

    private static class PasteHandler
    extends ConsoleAction {
        private PasteHandler() {
        }

        @Override
        public void execute(ConsoleViewImpl consoleView, DataContext context) {
            String s = (String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor);
            if (s == null) {
                return;
            }
            ApplicationManager.getApplication().assertIsDispatchThread();
            EditorEx editor = consoleView.myEditor;
            SelectionModel selectionModel = editor.getSelectionModel();
            if (selectionModel.hasSelection()) {
                consoleView.replaceUserText(s, selectionModel.getSelectionStart(), selectionModel.getSelectionEnd());
            } else {
                consoleView.insertUserText(s, editor.getCaretModel().getOffset());
            }
        }
    }

    private static class EnterHandler
    extends ConsoleAction {
        private EnterHandler() {
        }

        @Override
        public void execute(ConsoleViewImpl consoleView, DataContext context) {
            consoleView.print("\n", ConsoleViewContentType.USER_INPUT);
            consoleView.flushDeferredText();
            EditorEx editor = consoleView.myEditor;
            editor.getCaretModel().moveToOffset(editor.getDocument().getTextLength());
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        }
    }

    private static abstract class ConsoleAction
    extends AnAction
    implements DumbAware {
        private ConsoleAction() {
        }

        public void actionPerformed(AnActionEvent e) {
            DataContext context = e.getDataContext();
            ConsoleViewImpl console = ConsoleAction.getRunningConsole(context);
            this.execute(console, context);
        }

        protected abstract void execute(ConsoleViewImpl var1, DataContext var2);

        public void update(AnActionEvent e) {
            ConsoleViewImpl console = ConsoleAction.getRunningConsole(e.getDataContext());
            e.getPresentation().setEnabled(console != null);
        }

        @Nullable
        private static ConsoleViewImpl getRunningConsole(DataContext context) {
            ConsoleViewImpl console;
            Editor editor = (Editor)CommonDataKeys.EDITOR.getData(context);
            if (editor != null && (console = (ConsoleViewImpl)editor.getUserData(CONSOLE_VIEW_IN_EDITOR_VIEW)) != null && console.myState.isRunning()) {
                return console;
            }
            return null;
        }
    }

    private static class MyTypedHandler
    extends TypedActionHandlerBase {
        private MyTypedHandler(TypedActionHandler originalAction) {
            super(originalAction);
        }

        public void execute(@NotNull Editor editor, char charTyped, @NotNull DataContext dataContext) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/execution/impl/ConsoleViewImpl$MyTypedHandler", "execute"));
            }
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/execution/impl/ConsoleViewImpl$MyTypedHandler", "execute"));
            }
            ConsoleViewImpl consoleView = (ConsoleViewImpl)editor.getUserData(CONSOLE_VIEW_IN_EDITOR_VIEW);
            if (consoleView == null || !consoleView.myState.isRunning() || consoleView.myIsViewer) {
                if (this.myOriginalHandler != null) {
                    this.myOriginalHandler.execute(editor, charTyped, dataContext);
                }
            } else {
                String s = String.valueOf(charTyped);
                SelectionModel selectionModel = editor.getSelectionModel();
                if (selectionModel.hasSelection()) {
                    consoleView.replaceUserText(s, selectionModel.getSelectionStart(), selectionModel.getSelectionEnd());
                } else {
                    consoleView.insertUserText(s, editor.getCaretModel().getOffset());
                }
            }
        }
    }

    private class MyHighlighter
    extends DocumentAdapter
    implements EditorHighlighter {
        private HighlighterClient myEditor;

        private MyHighlighter() {
        }

        @NotNull
        public HighlighterIterator createIterator(int startOffset) {
            final int startIndex = ConsoleUtil.findTokenInfoIndexByOffset(ConsoleViewImpl.this.myTokens, startOffset);
            HighlighterIterator highlighterIterator = new HighlighterIterator(){
                private int myIndex;
                {
                    this.myIndex = startIndex;
                }

                public TextAttributes getTextAttributes() {
                    return this.getTokenInfo() == null ? null : this.getTokenInfo().attributes;
                }

                public int getStart() {
                    return this.getTokenInfo() == null ? 0 : this.getTokenInfo().startOffset;
                }

                public int getEnd() {
                    return this.getTokenInfo() == null ? 0 : this.getTokenInfo().endOffset;
                }

                public IElementType getTokenType() {
                    return null;
                }

                public void advance() {
                    ++this.myIndex;
                }

                public void retreat() {
                    --this.myIndex;
                }

                public boolean atEnd() {
                    return this.myIndex < 0 || this.myIndex >= ConsoleViewImpl.this.myTokens.size();
                }

                public Document getDocument() {
                    return MyHighlighter.this.myEditor.getDocument();
                }

                private TokenInfo getTokenInfo() {
                    return (TokenInfo)ConsoleViewImpl.this.myTokens.get(this.myIndex);
                }
            };
            if (highlighterIterator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/ConsoleViewImpl$MyHighlighter", "createIterator"));
            }
            return highlighterIterator;
        }

        public void setText(@NotNull CharSequence text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/execution/impl/ConsoleViewImpl$MyHighlighter", "setText"));
            }
        }

        public void setEditor(@NotNull HighlighterClient editor) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/execution/impl/ConsoleViewImpl$MyHighlighter", "setEditor"));
            }
            LOG.assertTrue(this.myEditor == null, (Object)"Highlighters cannot be reused with different editors");
            this.myEditor = editor;
        }

        public void setColorScheme(@NotNull EditorColorsScheme scheme) {
            if (scheme == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/execution/impl/ConsoleViewImpl$MyHighlighter", "setColorScheme"));
            }
        }
    }

    public static class ClearAllAction
    extends DumbAwareAction {
        public ClearAllAction() {
            super(ExecutionBundle.message((String)"clear.all.from.console.action.name", (Object[])new Object[0]), "Clear the contents of the console", AllIcons.Actions.GC);
        }

        public void update(AnActionEvent e) {
            boolean enabled = e.getData(LangDataKeys.CONSOLE_VIEW) != null;
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            if (editor != null && editor.getDocument().getTextLength() == 0) {
                enabled = false;
            }
            e.getPresentation().setEnabled(enabled);
        }

        public void actionPerformed(AnActionEvent e) {
            ConsoleView consoleView = (ConsoleView)e.getData(LangDataKeys.CONSOLE_VIEW);
            if (consoleView != null) {
                consoleView.clear();
            }
        }
    }

    static class HyperlinkTokenInfo
    extends TokenInfo {
        private final HyperlinkInfo myHyperlinkInfo;

        HyperlinkTokenInfo(ConsoleViewContentType contentType, int startOffset, int endOffset, HyperlinkInfo hyperlinkInfo) {
            super(contentType, startOffset, endOffset);
            this.myHyperlinkInfo = hyperlinkInfo;
        }

        @Override
        public HyperlinkInfo getHyperlinkInfo() {
            return this.myHyperlinkInfo;
        }
    }

    static class TokenInfo {
        final ConsoleViewContentType contentType;
        int startOffset;
        int endOffset;
        private final TextAttributes attributes;

        TokenInfo(ConsoleViewContentType contentType, int startOffset, int endOffset) {
            this.contentType = contentType;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.attributes = contentType.getAttributes();
        }

        public int getLength() {
            return this.endOffset - this.startOffset;
        }

        public String toString() {
            return this.contentType + "[" + this.startOffset + ";" + this.endOffset + "]";
        }

        @Nullable
        public HyperlinkInfo getHyperlinkInfo() {
            return null;
        }
    }
}

