/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.autotest;

import com.intellij.execution.DelayedDocumentWatcher;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.content.Content;
import com.intellij.util.Consumer;
import com.intellij.util.containers.WeakHashMap;
import java.awt.Component;
import java.util.Collections;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutoTestManager {
    static final Key<Boolean> AUTOTESTABLE = Key.create((String)"auto.test.manager.supported");
    public static final String AUTO_TEST_MANAGER_DELAY = "auto.test.manager.delay";
    private static final Key<ProcessListener> ON_TERMINATION_RESTARTER_KEY = Key.create((String)"auto.test.manager.on.termination.restarter");
    private final Project myProject;
    private int myDelay;
    private DelayedDocumentWatcher myDocumentWatcher;
    private final Set<Content> myEnabledDescriptors = Collections.newSetFromMap(new WeakHashMap());

    public static AutoTestManager getInstance(Project project) {
        return (AutoTestManager)ServiceManager.getService((Project)project, AutoTestManager.class);
    }

    public AutoTestManager(Project project) {
        this.myProject = project;
        this.myDelay = PropertiesComponent.getInstance((Project)this.myProject).getOrInitInt(AUTO_TEST_MANAGER_DELAY, 3000);
        this.myDocumentWatcher = this.createWatcher();
    }

    private DelayedDocumentWatcher createWatcher() {
        return new DelayedDocumentWatcher(this.myProject, this.myDelay, new Consumer<Integer>(){

            public void consume(Integer modificationStamp) {
                for (Content content : AutoTestManager.this.myEnabledDescriptors) {
                    AutoTestManager.runAutoTest(content, modificationStamp, AutoTestManager.this.myDocumentWatcher);
                }
            }
        }, new Condition<VirtualFile>(){

            public boolean value(VirtualFile file) {
                return FileEditorManager.getInstance((Project)AutoTestManager.this.myProject).isFileOpen(file);
            }
        });
    }

    public void setAutoTestEnabled(@NotNull RunContentDescriptor descriptor, boolean enabled) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/execution/testframework/autotest/AutoTestManager", "setAutoTestEnabled"));
        }
        Content content = descriptor.getAttachedContent();
        if (enabled) {
            this.myEnabledDescriptors.add(content);
            this.myDocumentWatcher.activate();
        } else {
            AutoTestManager.clearRestarterListener(descriptor.getProcessHandler());
            this.myEnabledDescriptors.remove(content);
            if (this.myEnabledDescriptors.isEmpty()) {
                this.myDocumentWatcher.deactivate();
            }
        }
    }

    private static void clearRestarterListener(@Nullable ProcessHandler processHandler) {
        ProcessListener restarterListener;
        if (processHandler != null && (restarterListener = (ProcessListener)ON_TERMINATION_RESTARTER_KEY.get((UserDataHolder)processHandler, null)) != null) {
            processHandler.removeProcessListener(restarterListener);
            ON_TERMINATION_RESTARTER_KEY.set((UserDataHolder)processHandler, null);
        }
    }

    public boolean isAutoTestEnabled(RunContentDescriptor descriptor) {
        return this.myEnabledDescriptors.contains(descriptor.getAttachedContent());
    }

    private static void runAutoTest(@NotNull Content content, int modificationStamp, @NotNull DelayedDocumentWatcher documentWatcher) {
        DataContext dataContext;
        RunContentDescriptor descriptor;
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/execution/testframework/autotest/AutoTestManager", "runAutoTest"));
        }
        if (documentWatcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documentWatcher", "com/intellij/execution/testframework/autotest/AutoTestManager", "runAutoTest"));
        }
        JComponent component = content.getComponent();
        if (component != null && (descriptor = (RunContentDescriptor)LangDataKeys.RUN_CONTENT_DESCRIPTOR.getData(dataContext = DataManager.getInstance().getDataContext((Component)component))) != null) {
            ProcessHandler processHandler = descriptor.getProcessHandler();
            if (processHandler != null && !processHandler.isProcessTerminated()) {
                AutoTestManager.scheduleRestartOnTermination(descriptor, content, processHandler, modificationStamp, documentWatcher);
            } else {
                AutoTestManager.restart(descriptor, content);
            }
        }
    }

    private static void scheduleRestartOnTermination(final @NotNull RunContentDescriptor descriptor, final @NotNull Content content, final @NotNull ProcessHandler processHandler, final int modificationStamp, final @NotNull DelayedDocumentWatcher documentWatcher) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/execution/testframework/autotest/AutoTestManager", "scheduleRestartOnTermination"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/execution/testframework/autotest/AutoTestManager", "scheduleRestartOnTermination"));
        }
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/execution/testframework/autotest/AutoTestManager", "scheduleRestartOnTermination"));
        }
        if (documentWatcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documentWatcher", "com/intellij/execution/testframework/autotest/AutoTestManager", "scheduleRestartOnTermination"));
        }
        Object restarterListener = (ProcessListener)ON_TERMINATION_RESTARTER_KEY.get((UserDataHolder)processHandler);
        if (restarterListener != null) {
            return;
        }
        restarterListener = new ProcessAdapter(){

            public void processTerminated(ProcessEvent event) {
                AutoTestManager.clearRestarterListener(processHandler);
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (documentWatcher.isUpToDate(modificationStamp)) {
                            AutoTestManager.restart(descriptor, content);
                        }
                    }
                }, ModalityState.any());
            }
        };
        ON_TERMINATION_RESTARTER_KEY.set((UserDataHolder)processHandler, restarterListener);
        processHandler.addProcessListener(restarterListener);
    }

    private static void restart(@NotNull RunContentDescriptor descriptor, @NotNull Content content) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/execution/testframework/autotest/AutoTestManager", "restart"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/execution/testframework/autotest/AutoTestManager", "restart"));
        }
        descriptor.setActivateToolWindowWhenAdded(false);
        descriptor.setReuseToolWindowActivation(true);
        ExecutionUtil.restart((Content)content);
    }

    int getDelay() {
        return this.myDelay;
    }

    void setDelay(int delay) {
        this.myDelay = delay;
        this.myDocumentWatcher.deactivate();
        this.myDocumentWatcher = this.createWatcher();
        if (!this.myEnabledDescriptors.isEmpty()) {
            this.myDocumentWatcher.activate();
        }
        PropertiesComponent.getInstance((Project)this.myProject).setValue(AUTO_TEST_MANAGER_DELAY, String.valueOf(this.myDelay));
    }
}

