/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actions.PasteAction;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.Producer;

public class SimplePasteAction
extends EditorAction {
    public SimplePasteAction() {
        super((EditorActionHandler)new Handler());
    }

    public void update(AnActionEvent e) {
        super.update(e);
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            Presentation presentation = e.getPresentation();
            presentation.setVisible(presentation.isEnabled());
        }
    }

    private static class Handler
    extends EditorWriteActionHandler {
        private Handler() {
        }

        public void executeWriteAction(Editor editor, DataContext dataContext) {
            Producer producer = (Producer)PasteAction.TRANSFERABLE_PROVIDER.getData(dataContext);
            if (!editor.getCaretModel().supportsMultipleCarets() && editor.isColumnMode()) {
                EditorModificationUtil.pasteTransferableAsBlock((Editor)editor, (Producer)producer);
            } else {
                TextRange range = EditorModificationUtil.pasteTransferable((Editor)editor, (Producer)producer);
                editor.putUserData(EditorEx.LAST_PASTED_REGION, (Object)range);
            }
        }

        public boolean isEnabled(Editor editor, DataContext dataContext) {
            return !editor.isViewer();
        }
    }
}

