/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.impl.DataManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPromoter;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.impl.ActionProcessor;
import com.intellij.openapi.keymap.impl.KeyProcessorContext;
import com.intellij.openapi.keymap.impl.KeyState;
import com.intellij.openapi.keymap.impl.keyGestures.KeyboardGestureProcessor;
import com.intellij.openapi.keymap.impl.ui.ShortcutTextField;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.openapi.wm.impl.FloatingDecorator;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.IdeGlassPaneEx;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ComponentWithMnemonics;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBOptionButton;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.util.Alarm;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.MacUIUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.im.InputContext;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IdeKeyEventDispatcher
implements Disposable {
    @NonNls
    private static final String GET_CACHED_STROKE_METHOD_NAME = "getCachedStroke";
    private KeyStroke myFirstKeyStroke;
    private boolean myPressedWasProcessed;
    private KeyState myState = KeyState.STATE_INIT;
    private final PresentationFactory myPresentationFactory = new PresentationFactory();
    private boolean myDisposed = false;
    private boolean myLeftCtrlPressed = false;
    private boolean myRightAltPressed = false;
    private final KeyboardGestureProcessor myKeyGestureProcessor = new KeyboardGestureProcessor(this);
    private final KeyProcessorContext myContext = new KeyProcessorContext();
    private final IdeEventQueue myQueue;
    private final Alarm mySecondStrokeTimeout = new Alarm();
    private final Runnable mySecondStrokeTimeoutRunnable = new Runnable(){

        @Override
        public void run() {
            if (IdeKeyEventDispatcher.this.myState == KeyState.STATE_WAIT_FOR_SECOND_KEYSTROKE) {
                IdeKeyEventDispatcher.this.resetState();
                DataContext dataContext = IdeKeyEventDispatcher.this.myContext.getDataContext();
                StatusBar.Info.set(null, dataContext == null ? null : (Project)CommonDataKeys.PROJECT.getData(dataContext));
            }
        }
    };
    private final Alarm mySecondKeystrokePopupTimeout = new Alarm();
    @NonNls
    private static final Set<String> ALT_GR_LAYOUTS = new HashSet<String>(Arrays.asList("pl", "de", "fi", "fr", "no", "da", "se", "pt", "nl", "tr", "sl", "hu", "bs", "hr", "sr", "sk", "lv"));
    private final ActionProcessor myActionProcessor = new ActionProcessor(){

        @Override
        @NotNull
        public AnActionEvent createEvent(InputEvent inputEvent, @NotNull DataContext context, @NotNull String place, @NotNull Presentation presentation, ActionManager manager) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/keymap/impl/IdeKeyEventDispatcher$3", "createEvent"));
            }
            if (place == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/openapi/keymap/impl/IdeKeyEventDispatcher$3", "createEvent"));
            }
            if (presentation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/openapi/keymap/impl/IdeKeyEventDispatcher$3", "createEvent"));
            }
            AnActionEvent anActionEvent = new AnActionEvent(inputEvent, context, place, presentation, manager, 0);
            if (anActionEvent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/keymap/impl/IdeKeyEventDispatcher$3", "createEvent"));
            }
            return anActionEvent;
        }

        @Override
        public void onUpdatePassed(InputEvent inputEvent, @NotNull AnAction action, @NotNull AnActionEvent actionEvent) {
            if (action == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/keymap/impl/IdeKeyEventDispatcher$3", "onUpdatePassed"));
            }
            if (actionEvent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionEvent", "com/intellij/openapi/keymap/impl/IdeKeyEventDispatcher$3", "onUpdatePassed"));
            }
            IdeKeyEventDispatcher.this.setState(KeyState.STATE_PROCESSED);
            IdeKeyEventDispatcher.this.setPressedWasProcessed(inputEvent.getID() == 401);
        }

        @Override
        public void performAction(InputEvent e, @NotNull AnAction action, @NotNull AnActionEvent actionEvent) {
            if (action == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/keymap/impl/IdeKeyEventDispatcher$3", "performAction"));
            }
            if (actionEvent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionEvent", "com/intellij/openapi/keymap/impl/IdeKeyEventDispatcher$3", "performAction"));
            }
            e.consume();
            action.actionPerformed(actionEvent);
            if (Registry.is((String)"actionSystem.fixLostTyping")) {
                IdeEventQueue.getInstance().doWhenReady(new Runnable(){

                    @Override
                    public void run() {
                        IdeEventQueue.getInstance().getKeyEventDispatcher().resetState();
                    }
                });
            }
        }
    };
    private static KeyboardShortcut CONTROL_ENTER = KeyboardShortcut.fromString((String)"control ENTER");

    public IdeKeyEventDispatcher(IdeEventQueue queue) {
        this.myQueue = queue;
        Application parent = ApplicationManager.getApplication();
        if (parent != null) {
            Disposer.register((Disposable)parent, (Disposable)this);
        }
    }

    public boolean isWaitingForSecondKeyStroke() {
        return this.getState() == KeyState.STATE_WAIT_FOR_SECOND_KEYSTROKE || this.isPressedWasProcessed();
    }

    public boolean dispatchKeyEvent(KeyEvent e) {
        MenuSelectionManager menuSelectionManager;
        MenuElement[] selectedPath;
        if (this.myDisposed) {
            return false;
        }
        if (e.isConsumed()) {
            return false;
        }
        if (IdeKeyEventDispatcher.isSpeedSearchEditing(e)) {
            return false;
        }
        if (e.getKeyCode() == 17) {
            if (e.getID() == 401) {
                this.myLeftCtrlPressed = e.getKeyLocation() == 2;
            } else if (e.getID() == 402) {
                this.myLeftCtrlPressed = false;
            }
        } else if (e.getKeyCode() == 18) {
            if (e.getID() == 401) {
                this.myRightAltPressed = e.getKeyLocation() == 3;
            } else if (e.getID() == 402) {
                this.myRightAltPressed = false;
            }
        }
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component focusOwner = focusManager.getFocusOwner();
        if (focusOwner instanceof ShortcutTextField) {
            return false;
        }
        if (focusOwner instanceof JTextComponent && ((JTextComponent)focusOwner).isEditable() && e.getKeyChar() != '\uffff' && e.getKeyChar() != '\u001b') {
            MacUIUtil.hideCursor();
        }
        if ((selectedPath = (menuSelectionManager = MenuSelectionManager.defaultManager()).getSelectedPath()).length > 0 && !(selectedPath[0] instanceof ComboPopup)) {
            this.setState(KeyState.STATE_PROCESSED);
            this.setPressedWasProcessed(true);
            return false;
        }
        Window focusedWindow = focusManager.getFocusedWindow();
        boolean isModalContext = focusedWindow != null && IdeKeyEventDispatcher.isModalContext(focusedWindow);
        DataManager dataManager = DataManager.getInstance();
        if (dataManager == null) {
            return false;
        }
        DataContext dataContext = dataManager.getDataContext();
        this.myContext.setDataContext(dataContext);
        this.myContext.setFocusOwner(focusOwner);
        this.myContext.setModalContext(isModalContext);
        this.myContext.setInputEvent(e);
        try {
            if (this.getState() == KeyState.STATE_INIT) {
                boolean bl = this.inInitState();
                return bl;
            }
            if (this.getState() == KeyState.STATE_PROCESSED) {
                boolean bl = this.inProcessedState();
                return bl;
            }
            if (this.getState() == KeyState.STATE_WAIT_FOR_SECOND_KEYSTROKE) {
                boolean bl = this.inWaitForSecondStrokeState();
                return bl;
            }
            if (this.getState() == KeyState.STATE_SECOND_STROKE_IN_PROGRESS) {
                boolean bl = this.inSecondStrokeInProgressState();
                return bl;
            }
            if (this.getState() == KeyState.STATE_KEY_GESTURE_PROCESSOR) {
                boolean bl = this.myKeyGestureProcessor.process();
                return bl;
            }
            throw new IllegalStateException("state = " + (Object)((Object)this.getState()));
        }
        finally {
            this.myContext.clear();
        }
    }

    private static boolean isSpeedSearchEditing(KeyEvent e) {
        Component owner;
        int keyCode = e.getKeyCode();
        if (keyCode == 8 && (owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner()) instanceof JComponent) {
            SpeedSearchSupply supply = SpeedSearchSupply.getSupply((JComponent)((JComponent)owner));
            return supply != null && supply.isPopupActive();
        }
        return false;
    }

    public static boolean isModalContext(@NotNull Component component) {
        JBPopup popup;
        boolean isPopup;
        JDialog dialog;
        Component pane;
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/keymap/impl/IdeKeyEventDispatcher", "isModalContext"));
        }
        Window window = component instanceof Window ? (Window)component : SwingUtilities.getWindowAncestor(component);
        if (window instanceof IdeFrameImpl && (pane = ((IdeFrameImpl)window).getGlassPane()) instanceof IdeGlassPaneEx) {
            return ((IdeGlassPaneEx)((Object)pane)).isInModalContext();
        }
        if (window instanceof JDialog && !(dialog = (JDialog)window).isModal()) {
            Window owner = dialog.getOwner();
            return owner != null && IdeKeyEventDispatcher.isModalContext(owner);
        }
        if (window instanceof JFrame) {
            return false;
        }
        boolean isMainFrame = window instanceof IdeFrameImpl;
        boolean isFloatingDecorator = window instanceof FloatingDecorator;
        boolean bl = isPopup = !(component instanceof JFrame) && !(component instanceof JDialog);
        if (isPopup && component instanceof JWindow && (popup = (JBPopup)((JWindow)component).getRootPane().getClientProperty("JBPopup")) != null) {
            return popup.isModalContext();
        }
        return !isMainFrame && !isFloatingDecorator;
    }

    private boolean inWaitForSecondStrokeState() {
        if (401 == this.myContext.getInputEvent().getID()) {
            this.setState(KeyState.STATE_SECOND_STROKE_IN_PROGRESS);
            return this.inSecondStrokeInProgressState();
        }
        return true;
    }

    private static KeyStroke getKeyStrokeWithoutMouseModifiers(KeyStroke originalKeyStroke) {
        int modifier = originalKeyStroke.getModifiers() & 0xFFFFFBFF & 0xFFFFFFEF & 0xFFFFF7FF & 0xFFFFFFF7 & 0xFFFFEFFF & 0xFFFFFFFB;
        try {
            Method[] methods = AWTKeyStroke.class.getDeclaredMethods();
            Method getCachedStrokeMethod = null;
            for (Method method : methods) {
                if (!GET_CACHED_STROKE_METHOD_NAME.equals(method.getName())) continue;
                getCachedStrokeMethod = method;
                getCachedStrokeMethod.setAccessible(true);
                break;
            }
            if (getCachedStrokeMethod == null) {
                throw new IllegalStateException("not found method with name getCachedStrokeMethod");
            }
            Object[] getCachedStrokeMethodArgs = new Object[]{Character.valueOf(originalKeyStroke.getKeyChar()), originalKeyStroke.getKeyCode(), modifier, originalKeyStroke.isOnKeyRelease()};
            return (KeyStroke)getCachedStrokeMethod.invoke((Object)originalKeyStroke, getCachedStrokeMethodArgs);
        }
        catch (Exception exc) {
            throw new IllegalStateException(exc.getMessage());
        }
    }

    private static KeyStroke getKeyStrokeWithoutCtrlModifier(KeyStroke originalKeyStroke) {
        int modifier = originalKeyStroke.getModifiers() & 0xFFFFFFFD & 0xFFFFFF7F;
        try {
            Method[] methods = AWTKeyStroke.class.getDeclaredMethods();
            Method getCachedStrokeMethod = null;
            for (Method method : methods) {
                if (!GET_CACHED_STROKE_METHOD_NAME.equals(method.getName())) continue;
                getCachedStrokeMethod = method;
                getCachedStrokeMethod.setAccessible(true);
                break;
            }
            if (getCachedStrokeMethod == null) {
                throw new IllegalStateException("not found method with name getCachedStrokeMethod");
            }
            Object[] getCachedStrokeMethodArgs = new Object[]{Character.valueOf(originalKeyStroke.getKeyChar()), originalKeyStroke.getKeyCode(), modifier, originalKeyStroke.isOnKeyRelease()};
            return (KeyStroke)getCachedStrokeMethod.invoke((Object)originalKeyStroke, getCachedStrokeMethodArgs);
        }
        catch (Exception exc) {
            throw new IllegalStateException(exc.getMessage());
        }
    }

    private boolean inSecondStrokeInProgressState() {
        KeyEvent e = this.myContext.getInputEvent();
        if (402 == e.getID()) {
            this.myFirstKeyStroke = null;
            this.setState(KeyState.STATE_INIT);
            Project project = (Project)CommonDataKeys.PROJECT.getData(this.myContext.getDataContext());
            StatusBar.Info.set(null, (Project)project);
            return false;
        }
        KeyStroke originalKeyStroke = KeyStroke.getKeyStrokeForEvent(e);
        KeyStroke keyStroke = IdeKeyEventDispatcher.getKeyStrokeWithoutMouseModifiers(originalKeyStroke);
        this.updateCurrentContext(this.myContext.getFoundComponent(), (Shortcut)new KeyboardShortcut(this.myFirstKeyStroke, keyStroke), this.myContext.isModalContext());
        if (this.myContext.getActions().isEmpty()) {
            return true;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(this.myContext.getDataContext());
        StatusBarEx statusBar = (StatusBarEx)WindowManager.getInstance().getStatusBar(project);
        if (this.processAction(e, this.myActionProcessor)) {
            if (statusBar != null) {
                statusBar.setInfo(null);
            }
            return true;
        }
        return false;
    }

    private boolean inProcessedState() {
        KeyEvent e = this.myContext.getInputEvent();
        if (400 == e.getID() && this.isPressedWasProcessed()) {
            return true;
        }
        if (402 == e.getID() && 18 == e.getKeyCode() && this.isPressedWasProcessed()) {
            return true;
        }
        this.setState(KeyState.STATE_INIT);
        this.setPressedWasProcessed(false);
        return this.inInitState();
    }

    private boolean inInitState() {
        Component focusOwner = this.myContext.getFocusOwner();
        boolean isModalContext = this.myContext.isModalContext();
        DataContext dataContext = this.myContext.getDataContext();
        KeyEvent e = this.myContext.getInputEvent();
        if (this.myLeftCtrlPressed && this.myRightAltPressed && focusOwner != null && e.getModifiers() == 10) {
            String language;
            Locale locale;
            if (Registry.is((String)"actionSystem.force.alt.gr")) {
                return false;
            }
            InputContext inputContext = focusOwner.getInputContext();
            if (inputContext != null && (locale = inputContext.getLocale()) != null && ALT_GR_LAYOUTS.contains(language = locale.getLanguage())) {
                return false;
            }
        }
        KeyStroke originalKeyStroke = KeyStroke.getKeyStrokeForEvent(e);
        KeyStroke keyStroke = IdeKeyEventDispatcher.getKeyStrokeWithoutMouseModifiers(originalKeyStroke);
        if (Registry.is((String)"fix.jdk7.alt.shortcuts") && SystemInfo.isMac && SystemInfo.isOracleJvm && (keyStroke.getModifiers() & 8) == 8 && KeymapManager.getInstance().getActiveKeymap().getActionIds((Shortcut)new KeyboardShortcut(keyStroke, null)).length == 0) {
            keyStroke = IdeKeyEventDispatcher.getKeyStrokeWithoutCtrlModifier(keyStroke);
        }
        if (this.myKeyGestureProcessor.processInitState()) {
            return true;
        }
        if (SystemInfo.isMac) {
            boolean keyTyped = e.getID() == 400;
            boolean hasMnemonicsInWindow = e.getID() == 401 && IdeKeyEventDispatcher.hasMnemonicInWindow(focusOwner, e.getKeyCode()) || keyTyped && IdeKeyEventDispatcher.hasMnemonicInWindow(focusOwner, e.getKeyChar());
            boolean imEnabled = IdeEventQueue.getInstance().isInputMethodEnabled();
            if (e.getModifiersEx() == 512 && (hasMnemonicsInWindow || !imEnabled && keyTyped)) {
                this.setPressedWasProcessed(true);
                this.setState(KeyState.STATE_PROCESSED);
                return false;
            }
        }
        this.updateCurrentContext(focusOwner, (Shortcut)new KeyboardShortcut(keyStroke, null), isModalContext);
        if (this.myContext.getActions().isEmpty()) {
            return false;
        }
        if (this.myContext.isHasSecondStroke()) {
            this.myFirstKeyStroke = keyStroke;
            final ArrayList<Pair<AnAction, KeyStroke>> secondKeyStrokes = this.getSecondKeystrokeActions();
            Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            StringBuilder message = new StringBuilder();
            message.append(KeyMapBundle.message((String)"prefix.key.pressed.message", (Object[])new Object[0]));
            message.append(' ');
            for (int i = 0; i < secondKeyStrokes.size(); ++i) {
                Pair<AnAction, KeyStroke> pair = secondKeyStrokes.get(i);
                if (i > 0) {
                    message.append(", ");
                }
                message.append(((AnAction)pair.getFirst()).getTemplatePresentation().getText());
                message.append(" (");
                message.append(KeymapUtil.getKeystrokeText((KeyStroke)((KeyStroke)pair.getSecond())));
                message.append(")");
            }
            StatusBar.Info.set((String)message.toString(), (Project)project);
            this.mySecondStrokeTimeout.cancelAllRequests();
            this.mySecondStrokeTimeout.addRequest(this.mySecondStrokeTimeoutRunnable, Registry.intValue((String)"actionSystem.secondKeystrokeTimeout"));
            if (Registry.is((String)"actionSystem.secondKeystrokeAutoPopupEnabled")) {
                this.mySecondKeystrokePopupTimeout.cancelAllRequests();
                if (secondKeyStrokes.size() > 1) {
                    final DataContext oldContext = this.myContext.getDataContext();
                    this.mySecondKeystrokePopupTimeout.addRequest(new Runnable(){

                        @Override
                        public void run() {
                            if (IdeKeyEventDispatcher.this.myState == KeyState.STATE_WAIT_FOR_SECOND_KEYSTROKE) {
                                StatusBar.Info.set(null, (Project)((Project)CommonDataKeys.PROJECT.getData(oldContext)));
                                new SecondaryKeystrokePopup(IdeKeyEventDispatcher.this.myFirstKeyStroke, secondKeyStrokes, oldContext).showInBestPositionFor(oldContext);
                            }
                        }
                    }, Registry.intValue((String)"actionSystem.secondKeystrokePopupTimeout"));
                }
            }
            this.setState(KeyState.STATE_WAIT_FOR_SECOND_KEYSTROKE);
            return true;
        }
        return this.processAction(e, this.myActionProcessor);
    }

    private ArrayList<Pair<AnAction, KeyStroke>> getSecondKeystrokeActions() {
        ArrayList<Pair<AnAction, KeyStroke>> secondKeyStrokes = new ArrayList<Pair<AnAction, KeyStroke>>();
        for (AnAction action : this.myContext.getActions()) {
            Shortcut[] shortcuts;
            for (Shortcut shortcut : shortcuts = action.getShortcutSet().getShortcuts()) {
                KeyboardShortcut keyShortcut;
                if (!(shortcut instanceof KeyboardShortcut) || !(keyShortcut = (KeyboardShortcut)shortcut).getFirstKeyStroke().equals(this.myFirstKeyStroke)) continue;
                secondKeyStrokes.add((Pair<AnAction, KeyStroke>)Pair.create((Object)action, (Object)keyShortcut.getSecondKeyStroke()));
            }
        }
        return secondKeyStrokes;
    }

    private static boolean hasMnemonicInWindow(Component focusOwner, int keyCode) {
        if (keyCode == 18 || keyCode == 0) {
            return false;
        }
        Container container = IdeKeyEventDispatcher.getContainer(focusOwner);
        return IdeKeyEventDispatcher.hasMnemonic(container, keyCode) || IdeKeyEventDispatcher.hasMnemonicInBalloons(container, keyCode);
    }

    @Nullable
    private static Container getContainer(@Nullable Component focusOwner) {
        if (focusOwner == null) {
            return null;
        }
        if (focusOwner.isLightweight()) {
            Container parent;
            Container container = focusOwner.getParent();
            while (container != null && !((parent = container.getParent()) instanceof JLayeredPane) && parent != null && parent.isLightweight()) {
                container = parent;
            }
            return container;
        }
        return SwingUtilities.windowForComponent(focusOwner);
    }

    private static boolean hasMnemonic(Container container, int keyCode) {
        Component[] components;
        if (container == null) {
            return false;
        }
        for (Component component : components = container.getComponents()) {
            JLabel label;
            AbstractButton button;
            if (component instanceof AbstractButton && ((button = (AbstractButton)component) instanceof JBOptionButton ? ((JBOptionButton)button).isOkToProcessDefaultMnemonics() : button.getMnemonic() == keyCode)) {
                return true;
            }
            if (component instanceof JLabel && (label = (JLabel)component).getDisplayedMnemonic() == keyCode) {
                return true;
            }
            if (!(component instanceof Container) || !IdeKeyEventDispatcher.hasMnemonic((Container)component, keyCode)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasMnemonicInBalloons(Container container, int code) {
        Component parent = UIUtil.findUltimateParent((Component)container);
        if (parent instanceof RootPaneContainer) {
            JLayeredPane pane = ((RootPaneContainer)((Object)parent)).getLayeredPane();
            for (Component component : pane.getComponents()) {
                if (!(component instanceof ComponentWithMnemonics) || !(component instanceof Container) || !IdeKeyEventDispatcher.hasMnemonic((Container)component, code)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean processAction(InputEvent e, @NotNull ActionProcessor processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/keymap/impl/IdeKeyEventDispatcher", "processAction"));
        }
        ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
        Project project = (Project)CommonDataKeys.PROJECT.getData(this.myContext.getDataContext());
        boolean dumb = project != null && DumbService.getInstance((Project)project).isDumb();
        ArrayList<AnActionEvent> nonDumbAwareAction = new ArrayList<AnActionEvent>();
        List<AnAction> actions = this.myContext.getActions();
        for (AnAction action : actions.toArray(new AnAction[actions.size()])) {
            Presentation presentation = this.myPresentationFactory.getPresentation(action);
            AnActionEvent actionEvent = processor.createEvent(e, this.myContext.getDataContext(), "MainMenu", presentation, ActionManager.getInstance());
            ActionUtil.performDumbAwareUpdate((AnAction)action, (AnActionEvent)actionEvent, (boolean)true);
            if (dumb && !action.isDumbAware()) {
                if (Boolean.FALSE.equals(presentation.getClientProperty("WOULD_BE_ENABLED_IF_NOT_DUMB_MODE"))) continue;
                nonDumbAwareAction.add(actionEvent);
                continue;
            }
            if (!presentation.isEnabled()) continue;
            processor.onUpdatePassed(e, action, actionEvent);
            if (this.myContext.getDataContext() instanceof DataManagerImpl.MyDataContext) {
                ((DataManagerImpl.MyDataContext)this.myContext.getDataContext()).setEventCount(IdeEventQueue.getInstance().getEventCount(), this);
            }
            actionManager.fireBeforeActionPerformed(action, actionEvent.getDataContext(), actionEvent);
            Component component = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(actionEvent.getDataContext());
            if (component != null && !component.isShowing()) {
                return true;
            }
            processor.performAction(e, action, actionEvent);
            actionManager.fireAfterActionPerformed(action, actionEvent.getDataContext(), actionEvent);
            return true;
        }
        if (!nonDumbAwareAction.isEmpty()) {
            IdeKeyEventDispatcher.showDumbModeWarningLaterIfNobodyConsumesEvent(e, nonDumbAwareAction.toArray(new AnActionEvent[nonDumbAwareAction.size()]));
        }
        return false;
    }

    private static void showDumbModeWarningLaterIfNobodyConsumesEvent(final InputEvent e, final AnActionEvent ... actionEvents) {
        if (ModalityState.current() == ModalityState.NON_MODAL) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (e.isConsumed()) {
                        return;
                    }
                    ActionUtil.showDumbModeWarning((AnActionEvent[])actionEvents);
                }
            });
        }
    }

    public KeyProcessorContext updateCurrentContext(Component component, Shortcut sc, boolean isModalContext) {
        this.myContext.setFoundComponent(null);
        this.myContext.getActions().clear();
        if (IdeKeyEventDispatcher.isControlEnterOnDialog(component, sc)) {
            return this.myContext;
        }
        boolean hasSecondStroke = false;
        while (component != null) {
            List listOfActions;
            if (component instanceof JComponent && !(listOfActions = ActionUtil.getActions((JComponent)((JComponent)component))).isEmpty()) {
                for (AnAction listOfAction : listOfActions) {
                    if (!(listOfAction instanceof AnAction)) continue;
                    AnAction action = listOfAction;
                    hasSecondStroke |= this.addAction(action, sc);
                }
                if (!this.myContext.getActions().isEmpty()) {
                    this.myContext.setFoundComponent((JComponent)component);
                    break;
                }
            }
            component = component.getParent();
        }
        Keymap keymap = KeymapManager.getInstance().getActiveKeymap();
        String[] actionIds = keymap.getActionIds(sc);
        ActionManager actionManager = ActionManager.getInstance();
        for (String actionId : actionIds) {
            AnAction action = actionManager.getAction(actionId);
            if (action == null || isModalContext && !action.isEnabledInModalContext()) continue;
            hasSecondStroke |= this.addAction(action, sc);
        }
        if (!hasSecondStroke && sc instanceof KeyboardShortcut) {
            KeyboardShortcut keyboardShortcut = (KeyboardShortcut)sc;
            KeyStroke firstKeyStroke = keyboardShortcut.getFirstKeyStroke();
            KeyStroke secondKeyStroke = keyboardShortcut.getSecondKeyStroke();
            if (secondKeyStroke != null && secondKeyStroke.getModifiers() != 0 && firstKeyStroke.getModifiers() != 0) {
                String[] additionalActions;
                KeyboardShortcut altShortCut = new KeyboardShortcut(firstKeyStroke, KeyStroke.getKeyStroke(secondKeyStroke.getKeyCode(), 0));
                for (String actionId : additionalActions = keymap.getActionIds((Shortcut)altShortCut)) {
                    AnAction action = actionManager.getAction(actionId);
                    if (action == null || isModalContext && !action.isEnabledInModalContext()) continue;
                    hasSecondStroke |= this.addAction(action, (Shortcut)altShortCut);
                }
            }
        }
        this.myContext.setHasSecondStroke(hasSecondStroke);
        List<AnAction> actions = this.myContext.getActions();
        if (actions.size() > 1) {
            List<AnAction> readOnlyActions = Collections.unmodifiableList(actions);
            for (ActionPromoter promoter : (ActionPromoter[])ActionPromoter.EP_NAME.getExtensions()) {
                List promoted = promoter.promote(readOnlyActions, this.myContext.getDataContext());
                if (promoted.isEmpty()) continue;
                actions.removeAll(promoted);
                actions.addAll(0, promoted);
            }
        }
        return this.myContext;
    }

    private static boolean isControlEnterOnDialog(Component component, Shortcut sc) {
        return CONTROL_ENTER.equals((Object)sc) && !IdeEventQueue.getInstance().isPopupActive() && DialogWrapper.findInstance((Component)component) != null;
    }

    private boolean addAction(AnAction action, Shortcut sc) {
        Shortcut[] shortcuts;
        boolean hasSecondStroke = false;
        for (Shortcut each : shortcuts = action.getShortcutSet().getShortcuts()) {
            if (!each.isKeyboard() || !each.startsWith(sc)) continue;
            if (!this.myContext.getActions().contains(action)) {
                this.myContext.getActions().add(action);
            }
            if (!(each instanceof KeyboardShortcut)) continue;
            hasSecondStroke |= ((KeyboardShortcut)each).getSecondKeyStroke() != null;
        }
        return hasSecondStroke;
    }

    public KeyProcessorContext getContext() {
        return this.myContext;
    }

    public void dispose() {
        this.myDisposed = true;
    }

    public KeyState getState() {
        return this.myState;
    }

    public void setState(KeyState state) {
        this.myState = state;
        if (this.myQueue != null) {
            this.myQueue.maybeReady();
        }
    }

    public void resetState() {
        this.setState(KeyState.STATE_INIT);
        this.setPressedWasProcessed(false);
    }

    public boolean isPressedWasProcessed() {
        return this.myPressedWasProcessed;
    }

    public void setPressedWasProcessed(boolean pressedWasProcessed) {
        this.myPressedWasProcessed = pressedWasProcessed;
    }

    public boolean isReady() {
        return this.myState == KeyState.STATE_INIT || this.myState == KeyState.STATE_PROCESSED;
    }

    private static class SecondaryKeystrokePopup
    extends ListPopupImpl {
        private SecondaryKeystrokePopup(@NotNull KeyStroke firstKeystroke, @NotNull List<Pair<AnAction, KeyStroke>> actions, DataContext context) {
            if (firstKeystroke == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "firstKeystroke", "com/intellij/openapi/keymap/impl/IdeKeyEventDispatcher$SecondaryKeystrokePopup", "<init>"));
            }
            if (actions == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/intellij/openapi/keymap/impl/IdeKeyEventDispatcher$SecondaryKeystrokePopup", "<init>"));
            }
            super(SecondaryKeystrokePopup.buildStep(actions, context));
            this.registerActions(firstKeystroke, actions, context);
        }

        private void registerActions(final @NotNull KeyStroke firstKeyStroke, @NotNull List<Pair<AnAction, KeyStroke>> actions, final DataContext ctx) {
            if (firstKeyStroke == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "firstKeyStroke", "com/intellij/openapi/keymap/impl/IdeKeyEventDispatcher$SecondaryKeystrokePopup", "registerActions"));
            }
            if (actions == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/intellij/openapi/keymap/impl/IdeKeyEventDispatcher$SecondaryKeystrokePopup", "registerActions"));
            }
            ContainerUtil.process(actions, (Processor)new Processor<Pair<AnAction, KeyStroke>>(){

                public boolean process(final Pair<AnAction, KeyStroke> pair) {
                    String actionText = ((AnAction)pair.getFirst()).getTemplatePresentation().getText();
                    AbstractAction a = new AbstractAction(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            SecondaryKeystrokePopup.this.cancel();
                            SecondaryKeystrokePopup.invokeAction((AnAction)pair.getFirst(), ctx);
                        }
                    };
                    KeyStroke keyStroke = (KeyStroke)pair.getSecond();
                    if (keyStroke != null) {
                        KeyStroke additionalKeyStroke;
                        String _existing;
                        SecondaryKeystrokePopup.this.registerAction(actionText, keyStroke, a);
                        if (keyStroke.getModifiers() == 0 && (_existing = SecondaryKeystrokePopup.this.getActionForKeyStroke(additionalKeyStroke = KeyStroke.getKeyStroke(keyStroke.getKeyCode(), firstKeyStroke.getModifiers()))) == null) {
                            SecondaryKeystrokePopup.this.registerAction("__additional__" + actionText, additionalKeyStroke, a);
                        }
                    }
                    return true;
                }
            });
        }

        private static void invokeAction(final @NotNull AnAction action, final DataContext ctx) {
            if (action == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/keymap/impl/IdeKeyEventDispatcher$SecondaryKeystrokePopup", "invokeAction"));
            }
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    AnActionEvent event = new AnActionEvent(null, ctx, "unknown", action.getTemplatePresentation().clone(), ActionManager.getInstance(), 0);
                    if (ActionUtil.lastUpdateAndCheckDumb((AnAction)action, (AnActionEvent)event, (boolean)true)) {
                        ActionUtil.performActionDumbAware((AnAction)action, (AnActionEvent)event);
                    }
                }
            });
        }

        @Override
        protected ListCellRenderer getListElementRenderer() {
            return new ActionListCellRenderer();
        }

        private static ListPopupStep buildStep(@NotNull List<Pair<AnAction, KeyStroke>> actions, final DataContext ctx) {
            if (actions == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/intellij/openapi/keymap/impl/IdeKeyEventDispatcher$SecondaryKeystrokePopup", "buildStep"));
            }
            return new BaseListPopupStep<Pair<AnAction, KeyStroke>>("Choose an action", ContainerUtil.findAll(actions, (Condition)new Condition<Pair<AnAction, KeyStroke>>(){

                public boolean value(Pair<AnAction, KeyStroke> pair) {
                    AnAction action = (AnAction)pair.getFirst();
                    Presentation presentation = action.getTemplatePresentation().clone();
                    AnActionEvent event = new AnActionEvent(null, ctx, "unknown", presentation, ActionManager.getInstance(), 0);
                    ActionUtil.performDumbAwareUpdate((AnAction)action, (AnActionEvent)event, (boolean)true);
                    return presentation.isEnabled() && presentation.isVisible();
                }
            })){

                public PopupStep onChosen(Pair<AnAction, KeyStroke> selectedValue, boolean finalChoice) {
                    SecondaryKeystrokePopup.invokeAction((AnAction)selectedValue.getFirst(), ctx);
                    return FINAL_CHOICE;
                }
            };
        }

        private static class ActionListCellRenderer
        extends ColoredListCellRenderer {
            private ActionListCellRenderer() {
            }

            protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (value == null) {
                    return;
                }
                if (value instanceof Pair) {
                    Pair pair = (Pair)value;
                    this.append(KeymapUtil.getShortcutText((Shortcut)new KeyboardShortcut((KeyStroke)pair.getSecond(), null)), SimpleTextAttributes.GRAY_ATTRIBUTES);
                    this.appendFixedTextFragmentWidth(30);
                    String text = ((AnAction)pair.getFirst()).getTemplatePresentation().getText();
                    this.append(text, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
            }
        }
    }
}

