/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceBean;
import com.intellij.openapi.components.SettingsSavingComponent;
import com.intellij.openapi.components.impl.stores.IApplicationStore;
import com.intellij.openapi.components.impl.stores.StreamProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.options.ExternalizableScheme;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.options.SchemesManager;
import com.intellij.openapi.options.SchemesManagerFactory;
import com.intellij.openapi.options.SchemesManagerImpl;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SchemesManagerFactoryImpl
extends SchemesManagerFactory
implements SettingsSavingComponent {
    private static final Logger LOG = Logger.getInstance(SchemesManagerFactoryImpl.class);
    private final List<SchemesManagerImpl> myRegisteredManagers = ContainerUtil.createLockFreeCopyOnWriteList();

    public <T extends Scheme, E extends ExternalizableScheme> SchemesManager<T, E> createSchemesManager(@NotNull String fileSpec, @NotNull SchemeProcessor<E> processor, @NotNull RoamingType roamingType) {
        if (fileSpec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSpec", "com/intellij/openapi/options/SchemesManagerFactoryImpl", "createSchemesManager"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/options/SchemesManagerFactoryImpl", "createSchemesManager"));
        }
        if (roamingType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roamingType", "com/intellij/openapi/options/SchemesManagerFactoryImpl", "createSchemesManager"));
        }
        Application application = ApplicationManager.getApplication();
        if (!(application instanceof ApplicationImpl)) {
            return null;
        }
        IApplicationStore applicationStore = ((ApplicationImpl)application).getStateStore();
        String baseDirPath = applicationStore.getStateStorageManager().expandMacros(fileSpec);
        StreamProvider provider = applicationStore.getStateStorageManager().getStreamProvider();
        SchemesManagerImpl manager = new SchemesManagerImpl(fileSpec, processor, roamingType, provider, new File(baseDirPath));
        this.myRegisteredManagers.add(manager);
        return manager;
    }

    public void updateConfigFilesFromStreamProviders() {
        ServiceBean.loadServicesFromBeans((ExtensionPointName)SCHEME_OWNER, Object.class);
        for (SchemesManagerImpl registeredManager : this.myRegisteredManagers) {
            try {
                registeredManager.updateConfigFilesFromStreamProviders();
            }
            catch (Throwable e) {
                LOG.info("Cannot save settings for " + registeredManager.getClass().getName(), e);
            }
        }
    }

    public void save() {
        ServiceBean.loadServicesFromBeans((ExtensionPointName)SCHEME_OWNER, Object.class);
        for (SchemesManagerImpl registeredManager : this.myRegisteredManagers) {
            try {
                registeredManager.save();
            }
            catch (Throwable e) {
                LOG.info("Cannot save settings for " + registeredManager.getClass().getName(), e);
            }
        }
    }
}

