/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListOwner;
import com.intellij.openapi.vcs.changes.LocallyDeletedChange;
import com.intellij.openapi.vcs.changes.ui.ChangeListDragBean;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserFileNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserFilePathNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserIgnoredFilesNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserLocallyDeletedNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserLockedFoldersNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserLogicallyLockedFile;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangesBrowserNode<T>
extends DefaultMutableTreeNode {
    private SimpleTextAttributes myAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
    protected int myCount = -1;
    protected int myDirectoryCount = -1;
    public static final Object IGNORED_FILES_TAG = new Object(){

        public String toString() {
            return VcsBundle.message((String)"changes.nodetitle.ignored.files", (Object[])new Object[0]);
        }
    };
    public static final Object LOCKED_FOLDERS_TAG = new Object(){

        public String toString() {
            return VcsBundle.message((String)"changes.nodetitle.locked.folders", (Object[])new Object[0]);
        }
    };
    public static final Object LOGICALLY_LOCKED_TAG = VcsBundle.message((String)"changes.nodetitle.logicallt.locked.folders", (Object[])new Object[0]);
    public static final Object UNVERSIONED_FILES_TAG = new Object(){

        public String toString() {
            return VcsBundle.message((String)"changes.nodetitle.unversioned.files", (Object[])new Object[0]);
        }
    };
    public static final Object MODIFIED_WITHOUT_EDITING_TAG = new Object(){

        public String toString() {
            return VcsBundle.message((String)"changes.nodetitle.modified.without.editing", (Object[])new Object[0]);
        }
    };
    public static final Object SWITCHED_FILES_TAG = new Object(){

        public String toString() {
            return VcsBundle.message((String)"changes.nodetitle.switched.files", (Object[])new Object[0]);
        }
    };
    public static final Object SWITCHED_ROOTS_TAG = new Object(){

        public String toString() {
            return VcsBundle.message((String)"changes.nodetitle.switched.roots", (Object[])new Object[0]);
        }
    };

    protected ChangesBrowserNode(Object userObject) {
        super(userObject);
    }

    public static ChangesBrowserNode create(Project project, @NotNull LocallyDeletedChange change) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserNode", "create"));
        }
        return new ChangesBrowserLocallyDeletedNode(change, project);
    }

    public static ChangesBrowserNode create(Project project, @NotNull Object userObject) {
        if (userObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "userObject", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserNode", "create"));
        }
        if (userObject instanceof VirtualFile) {
            return new ChangesBrowserFileNode(project, (VirtualFile)userObject);
        }
        if (userObject instanceof FilePath) {
            return new ChangesBrowserFilePathNode((FilePath)userObject);
        }
        if (userObject == IGNORED_FILES_TAG) {
            return new ChangesBrowserIgnoredFilesNode(userObject);
        }
        if (userObject == LOCKED_FOLDERS_TAG) {
            return new ChangesBrowserLockedFoldersNode(project, userObject);
        }
        if (userObject instanceof ChangesBrowserLogicallyLockedFile) {
            return (ChangesBrowserNode)userObject;
        }
        return new ChangesBrowserNode(userObject);
    }

    @Override
    public void insert(MutableTreeNode newChild, int childIndex) {
        super.insert(newChild, childIndex);
        this.myCount = -1;
        this.myDirectoryCount = -1;
    }

    public int getCount() {
        if (this.myCount == -1) {
            this.myCount = 0;
            Enumeration<TreeNode> nodes = this.children();
            while (nodes.hasMoreElements()) {
                ChangesBrowserNode child = (ChangesBrowserNode)nodes.nextElement();
                this.myCount += child.getCount();
            }
        }
        return this.myCount;
    }

    public int getDirectoryCount() {
        if (this.myDirectoryCount == -1) {
            this.myDirectoryCount = this.isDirectory() ? 1 : 0;
            Enumeration<TreeNode> nodes = this.children();
            while (nodes.hasMoreElements()) {
                ChangesBrowserNode child = (ChangesBrowserNode)nodes.nextElement();
                this.myDirectoryCount += child.getDirectoryCount();
            }
        }
        return this.myDirectoryCount;
    }

    protected boolean isDirectory() {
        return false;
    }

    public List<Change> getAllChangesUnder() {
        return this.getAllObjectsUnder(Change.class);
    }

    public <T> List<T> getAllObjectsUnder(Class<T> clazz) {
        ArrayList<T> changes = new ArrayList<T>();
        Enumeration<TreeNode> enumeration = this.preorderEnumeration();
        while (enumeration.hasMoreElements()) {
            ChangesBrowserNode child = (ChangesBrowserNode)enumeration.nextElement();
            T value = child.getUserObject();
            if (!clazz.isAssignableFrom(value.getClass())) continue;
            changes.add(value);
        }
        return changes;
    }

    public List<VirtualFile> getAllFilesUnder() {
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
        Enumeration<TreeNode> enumeration = this.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            VirtualFile file;
            ChangesBrowserNode child = (ChangesBrowserNode)enumeration.nextElement();
            T value = child.getUserObject();
            if (!(value instanceof VirtualFile) || !(file = (VirtualFile)value).isValid()) continue;
            files.add(file);
        }
        return files;
    }

    public List<FilePath> getAllFilePathsUnder() {
        ArrayList<FilePath> files = new ArrayList<FilePath>();
        Enumeration<TreeNode> enumeration = this.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            FilePath ownPath;
            ChangesBrowserNode child = (ChangesBrowserNode)enumeration.nextElement();
            T value = child.getUserObject();
            if (child.isLeaf() && value instanceof FilePath) {
                FilePath file = (FilePath)value;
                files.add(file);
            }
            if ((ownPath = child.getMyPath()) == null) continue;
            files.add(ownPath);
        }
        return files;
    }

    @Nullable
    protected FilePath getMyPath() {
        return null;
    }

    public void render(ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
        renderer.append(this.userObject.toString(), this.myAttributes);
        this.appendCount(renderer);
    }

    protected String getCountText() {
        int count = this.getCount();
        int dirCount = this.getDirectoryCount();
        if (dirCount == 0) {
            return " " + VcsBundle.message((String)"changes.nodetitle.changecount", (Object[])new Object[]{count});
        }
        if (count == 0 && dirCount > 0) {
            return " " + VcsBundle.message((String)"changes.nodetitle.directory.changecount", (Object[])new Object[]{dirCount});
        }
        return " " + VcsBundle.message((String)"changes.nodetitle.directory.file.changecount", (Object[])new Object[]{dirCount, count});
    }

    protected void appendCount(ColoredTreeCellRenderer renderer) {
        String countText = this.getCountText();
        renderer.append(countText, SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
    }

    @Override
    public String toString() {
        return this.getTextPresentation();
    }

    public String getTextPresentation() {
        return this.userObject == null ? "" : this.userObject.toString();
    }

    public T getUserObject() {
        return (T)this.userObject;
    }

    public boolean canAcceptDrop(ChangeListDragBean dragBean) {
        return false;
    }

    public void acceptDrop(ChangeListOwner dragOwner, ChangeListDragBean dragBean) {
    }

    public int getSortWeight() {
        return 8;
    }

    public int compareUserObjects(Object o2) {
        return 0;
    }

    public FilePath[] getFilePathsUnder() {
        return new FilePath[0];
    }

    public void setAttributes(SimpleTextAttributes attributes) {
        this.myAttributes = attributes;
    }
}

