/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vfs.VirtualFile;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="VcsManagerConfiguration", storages={@Storage(file="$MODULE_FILE$")})
public class VcsManagerPerModuleConfiguration
implements ModuleComponent,
PersistentStateComponent<Element> {
    private final Module myModule;
    public String ACTIVE_VCS_NAME = "";
    public boolean USE_PROJECT_VCS = true;

    public static VcsManagerPerModuleConfiguration getInstance(Module module) {
        return (VcsManagerPerModuleConfiguration)module.getComponent(VcsManagerPerModuleConfiguration.class);
    }

    public VcsManagerPerModuleConfiguration(Module module) {
        this.myModule = module;
    }

    public void moduleAdded() {
    }

    public void projectClosed() {
    }

    public void projectOpened() {
    }

    public void disposeComponent() {
    }

    public void initComponent() {
    }

    @NotNull
    public String getComponentName() {
        if ("VcsManagerConfiguration" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/VcsManagerPerModuleConfiguration", "getComponentName"));
        }
        return "VcsManagerConfiguration";
    }

    @Nullable
    public Element getState() {
        return null;
    }

    public void loadState(Element state) {
        try {
            DefaultJDOMExternalizer.readExternal((Object)this, (Element)state);
        }
        catch (InvalidDataException invalidDataException) {
            // empty catch block
        }
        if (!this.USE_PROJECT_VCS) {
            StartupManager.getInstance((Project)this.myModule.getProject()).runWhenProjectIsInitialized(new Runnable(){

                @Override
                public void run() {
                    ProjectLevelVcsManagerImpl vcsManager = (ProjectLevelVcsManagerImpl)ProjectLevelVcsManagerEx.getInstanceEx(VcsManagerPerModuleConfiguration.this.myModule.getProject());
                    for (VirtualFile file : ModuleRootManager.getInstance((Module)VcsManagerPerModuleConfiguration.this.myModule).getContentRoots()) {
                        vcsManager.setDirectoryMapping(file.getPath(), VcsManagerPerModuleConfiguration.this.ACTIVE_VCS_NAME);
                    }
                    vcsManager.cleanupMappings();
                }
            });
        }
    }
}

