/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.platform.ProjectSetReader;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.io.IOException;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.HttpRequestHandler;
import org.jetbrains.io.Responses;

public class ProjectSetRequestHandler
extends HttpRequestHandler {
    @Override
    public boolean isSupported(@NotNull FullHttpRequest request) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/platform/ProjectSetRequestHandler", "isSupported"));
        }
        return request.method() == HttpMethod.POST && "/openProjectSet".equals(request.uri());
    }

    @Override
    public boolean process(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) throws IOException {
        if (urlDecoder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urlDecoder", "com/intellij/platform/ProjectSetRequestHandler", "process"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/platform/ProjectSetRequestHandler", "process"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/platform/ProjectSetRequestHandler", "process"));
        }
        final String desc = request.content().toString(Charset.defaultCharset());
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                new ProjectSetReader().readDescriptor(desc, null);
            }
        });
        Responses.sendStatus(HttpResponseStatus.OK, context.channel(), (HttpRequest)request);
        return true;
    }
}

