/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file.impl;

import com.intellij.ProjectTopics;
import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootAdapter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.PackageIndex;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.file.PsiPackageImpl;
import com.intellij.psi.impl.file.impl.JavaFileManager;
import com.intellij.psi.impl.java.stubs.index.JavaFullClassNameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Query;
import com.intellij.util.containers.ConcurrentHashMap;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class JavaFileManagerImpl
implements JavaFileManager,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.file.impl.JavaFileManagerImpl");
    private final ConcurrentHashMap<GlobalSearchScope, PsiClass> myCachedObjectClassMap = new ConcurrentHashMap();
    private final PsiManagerEx myManager;
    private volatile Set<String> myNontrivialPackagePrefixes = null;
    private boolean myDisposed = false;
    private final PackageIndex myPackageIndex;

    public JavaFileManagerImpl(Project project) {
        this.myManager = (PsiManagerEx)PsiManager.getInstance((Project)project);
        this.myPackageIndex = PackageIndex.getInstance((Project)this.myManager.getProject());
        project.getMessageBus().connect().subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootAdapter(){

            public void rootsChanged(ModuleRootEvent event) {
                JavaFileManagerImpl.this.myNontrivialPackagePrefixes = null;
            }
        });
        this.myManager.registerRunnableToRunOnChange(new Runnable(){

            @Override
            public void run() {
                JavaFileManagerImpl.this.myCachedObjectClassMap.clear();
            }
        });
    }

    public void dispose() {
        this.myDisposed = true;
        this.myCachedObjectClassMap.clear();
    }

    @Override
    @Nullable
    public PsiPackage findPackage(@NotNull String packageName) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/psi/impl/file/impl/JavaFileManagerImpl", "findPackage"));
        }
        Query dirs = this.myPackageIndex.getDirsByPackageName(packageName, true);
        if (dirs.findFirst() == null) {
            return null;
        }
        return new PsiPackageImpl(this.myManager, packageName);
    }

    @Override
    public PsiClass[] findClasses(@NotNull String qName, final @NotNull GlobalSearchScope scope) {
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "com/intellij/psi/impl/file/impl/JavaFileManagerImpl", "findClasses"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/file/impl/JavaFileManagerImpl", "findClasses"));
        }
        Collection<PsiClass> classes = JavaFullClassNameIndex.getInstance().get(qName.hashCode(), this.myManager.getProject(), scope);
        if (classes.isEmpty()) {
            return PsiClass.EMPTY_ARRAY;
        }
        ArrayList<PsiClass> result = new ArrayList<PsiClass>(classes.size());
        for (PsiClass aClass : classes) {
            String qualifiedName = aClass.getQualifiedName();
            if (qualifiedName == null || !qualifiedName.equals(qName)) continue;
            PsiUtilCore.ensureValid((PsiElement)aClass);
            PsiFile file = aClass.getContainingFile();
            if (file == null) {
                throw new AssertionError((Object)("No file for class: " + aClass + " of " + aClass.getClass()));
            }
            VirtualFile vFile = file.getVirtualFile();
            if (!this.hasAcceptablePackage(vFile)) continue;
            result.add(aClass);
        }
        int count = result.size();
        if (count == 0) {
            return PsiClass.EMPTY_ARRAY;
        }
        if (count == 1) {
            return new PsiClass[]{(PsiClass)result.get(0)};
        }
        ContainerUtil.quickSort(result, (Comparator)new Comparator<PsiClass>(){

            @Override
            public int compare(PsiClass o1, PsiClass o2) {
                return scope.compare(o2.getContainingFile().getVirtualFile(), o1.getContainingFile().getVirtualFile());
            }
        });
        return result.toArray(new PsiClass[count]);
    }

    @Override
    @Nullable
    public PsiClass findClass(@NotNull String qName, @NotNull GlobalSearchScope scope) {
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "com/intellij/psi/impl/file/impl/JavaFileManagerImpl", "findClass"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/file/impl/JavaFileManagerImpl", "findClass"));
        }
        LOG.assertTrue(!this.myDisposed);
        if ("java.lang.Object".equals(qName)) {
            PsiClass cached = (PsiClass)this.myCachedObjectClassMap.get((Object)scope);
            if (cached == null && (cached = this.findClassInIndex(qName, scope)) != null) {
                cached = (PsiClass)this.myCachedObjectClassMap.cacheOrGet((Object)scope, (Object)cached);
            }
            return cached;
        }
        return this.findClassInIndex(qName, scope);
    }

    @Nullable
    private PsiClass findClassInIndex(String qName, GlobalSearchScope scope) {
        VirtualFile bestFile = null;
        PsiClass bestClass = null;
        Collection<PsiClass> classes = JavaFullClassNameIndex.getInstance().get(qName.hashCode(), this.myManager.getProject(), scope);
        for (PsiClass aClass : classes) {
            PsiFile file = aClass.getContainingFile();
            if (file == null) {
                LOG.error("aClass=" + aClass + " of class " + aClass.getClass() + "; valid=" + aClass.isValid());
                continue;
            }
            boolean valid = aClass.isValid();
            VirtualFile vFile = file.getVirtualFile();
            if (!valid) {
                LOG.error("Invalid class " + aClass + "; " + file + (file.isValid() ? "" : " (invalid)") + "; virtualFile:" + vFile + (vFile != null && !vFile.isValid() ? " (invalid)" : "") + "; id=" + (vFile == null ? 0 : ((VirtualFileWithId)vFile).getId()), (Throwable)new PsiInvalidElementAccessException((PsiElement)aClass));
                continue;
            }
            String qualifiedName = aClass.getQualifiedName();
            if (qualifiedName == null || !qualifiedName.equals(qName) || !this.hasAcceptablePackage(vFile) || bestFile != null && scope.compare(vFile, bestFile) <= 0) continue;
            bestFile = vFile;
            bestClass = aClass;
        }
        return bestClass;
    }

    private boolean hasAcceptablePackage(VirtualFile vFile) {
        if (vFile.getFileType() == JavaClassFileType.INSTANCE) {
            VirtualFile root = ProjectRootManager.getInstance((Project)this.myManager.getProject()).getFileIndex().getClassRootForFile(vFile);
            PsiNameHelper nameHelper = PsiNameHelper.getInstance((Project)this.myManager.getProject());
            for (VirtualFile parent = vFile.getParent(); parent != null && !Comparing.equal((Object)parent, (Object)root); parent = parent.getParent()) {
                if (nameHelper.isIdentifier(parent.getName())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Collection<String> getNonTrivialPackagePrefixes() {
        Set<String> names = this.myNontrivialPackagePrefixes;
        if (names == null) {
            names = new HashSet<String>();
            ProjectRootManager rootManager = ProjectRootManager.getInstance((Project)this.myManager.getProject());
            List sourceRoots = rootManager.getModuleSourceRoots(JavaModuleSourceRootTypes.SOURCES);
            ProjectFileIndex fileIndex = rootManager.getFileIndex();
            for (VirtualFile sourceRoot : sourceRoots) {
                String packageName;
                if (!sourceRoot.isDirectory() || (packageName = fileIndex.getPackageNameByDirectory(sourceRoot)) == null || packageName.isEmpty()) continue;
                names.add(packageName);
            }
            this.myNontrivialPackagePrefixes = names;
        }
        return names;
    }
}

